/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.gifttarget;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import com.unionyy.mobile.meipai.gift.animation.model.GiftMessage;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import com.unionyy.mobile.meipai.gift.animation.utils.AnimateResourceLoader;
import com.unionyy.mobile.meipai.gift.animation.utils.LedBitmapLoader;
import com.unionyy.mobile.meipai.gift.animation.view.GlAnimationView;
import com.unionyy.mobile.meipai.gift.animation.view.LedTextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.imageloader.ImageLoader;

public class GiftLedTarget
extends GiftTarget {
    private LedTextView mLedTextView;
    private ViewGroup.LayoutParams mImageParams;
    private LedBitmapLoader mLedBitmapLoader;

    public GiftLedTarget() {
        super(false);
    }

    public void loadLedTextBitmap(int width, int height, float scale, GiftMessage message, GiftRule rule, Bitmap suffix) {
        this.mLedBitmapLoader = new LedBitmapLoader(BasicConfig.getInstance().getAppContext());
        this.mLedBitmapLoader.setTextSize(32);
        String text = message.getAnchorName();
        this.mLedBitmapLoader.setText(text);
        this.mLedBitmapLoader.setDotColor(-1, 0);
        int mWidth = width - rule.padding_left - rule.padding_right;
        int mHeight = height - rule.padding_top - rule.padding_bottom;
        this.mLedBitmapLoader.createLedBitmap((int)((float)mWidth * scale), (int)((float)mHeight * scale), suffix);
        if (rule.speed > 0.0f) {
            float moveDis = (float)mWidth / rule.speed;
            rule.display_time = (int)((float)(mWidth + this.mLedBitmapLoader.getLedWidth()) / moveDis);
        }
    }

    @Override
    protected void addGiftImage(final Context context, final ViewGroup group, final float x, final float y, final int z) {
        String imagePath = this.getGiftImagePath();
        AnimateResourceLoader.getInstance().loadBitmap(imagePath, new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
            }

            public void onResourceReady(Bitmap bitmap) {
                if (GiftLedTarget.this.mLedTextView == null) {
                    GiftLedTarget.this.mLedTextView = new LedTextView(context);
                    GiftLedTarget.this.mImageParams = new ViewGroup.LayoutParams(GiftLedTarget.this.getGiftImageWidth(), GiftLedTarget.this.getGiftImageHeight());
                } else {
                    GiftLedTarget.this.mLedTextView.setRotation(0.0f);
                    GiftLedTarget.this.mLedTextView.setAlpha(1.0f);
                    GiftLedTarget.this.mLedTextView.setScaleX(1.0f);
                    GiftLedTarget.this.mLedTextView.setScaleY(1.0f);
                    ((GiftLedTarget)GiftLedTarget.this).mImageParams.width = GiftLedTarget.this.getGiftImageWidth();
                    ((GiftLedTarget)GiftLedTarget.this).mImageParams.height = GiftLedTarget.this.getGiftImageHeight();
                }
                GiftLedTarget.this.mLedTextView.setImageBitmap(bitmap);
                int left = (int)((float)GiftLedTarget.this.mGiftRule.padding_left * GiftLedTarget.this.mImageScale);
                int right = (int)((float)GiftLedTarget.this.mGiftRule.padding_right * GiftLedTarget.this.mImageScale);
                int top = (int)((float)GiftLedTarget.this.mGiftRule.padding_top * GiftLedTarget.this.mImageScale);
                int bottom = (int)((float)GiftLedTarget.this.mGiftRule.padding_bottom * GiftLedTarget.this.mImageScale);
                GiftLedTarget.this.mLedTextView.setLedingPadding(left, right, top, bottom);
                GiftLedTarget.this.mLedTextView.setSpeed(GiftLedTarget.this.mGiftRule.speed);
                GiftLedTarget.this.mLedTextView.setVisibility(8);
                GiftLedTarget.this.mLedTextView.setTranslationX(x);
                GiftLedTarget.this.mLedTextView.setTranslationY(y);
                group.addView((View)GiftLedTarget.this.mLedTextView, z, GiftLedTarget.this.mImageParams);
            }
        });
    }

    @Override
    protected Object getGiftImage() {
        return this.mLedTextView;
    }

    @Override
    public void startGiftAnimation(GiftRule rule) {
        super.startGiftAnimation(rule);
        this.mLedTextView.setVisibility(0);
    }

    @Override
    protected boolean afterBeginningAnimation() {
        if (super.afterBeginningAnimation()) {
            this.mLedTextView.start(this.mLedBitmapLoader);
            return true;
        }
        return false;
    }

    @Override
    protected void onGiftAnimationEnd() {
        if (this.mCurrentState == 4) {
            return;
        }
        if (this.mLedTextView != null) {
            this.mLedTextView.release();
            if (this.mLedTextView.getParent() != null) {
                ((ViewGroup)this.mLedTextView.getParent()).removeView((View)this.mLedTextView);
            }
            this.mLedTextView.setVisibility(8);
        }
        super.onGiftAnimationEnd();
    }

    @Override
    public int onChildTextureDraw(GlAnimationView gl, int z) {
        return z;
    }
}

