/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.dialog.RandomView;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.ui.dialog.RandomView.PKRandomUserPhotoView;
import com.unionyy.mobile.meipai.pk.utils.AvatarRoundUtil;
import com.unionyy.mobile.meipai.pk.utils.MeiPaiScreenUtil;
import com.unionyy.mobile.meipai.pk.utils.UIHelper;
import java.util.Timer;
import java.util.TimerTask;

public class PKRandomSearchView
extends FrameLayout {
    private Timer timer_task;
    private ImageView mPkSearchIcon;
    private ImageView mRealUserPhoto;
    private PKRandomUserPhotoView mPKRandomUserPhotoView;
    private AnimatorSet sAnimatorSet;
    private int angle = 0;
    private static int circle_angle = 360;

    public PKRandomSearchView(Context context) {
        super(context);
        this.init();
    }

    public PKRandomSearchView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PKRandomSearchView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.timer_task = new Timer();
        View view = PKRandomSearchView.inflate((Context)this.getContext(), (int)R.layout.meipai_live_layout_pk_random_search_view, (ViewGroup)this);
        this.mPkSearchIcon = (ImageView)view.findViewById(R.id.image_pk_random_search_icon);
        this.mRealUserPhoto = (ImageView)view.findViewById(R.id.image_user_real_photo);
        this.mPKRandomUserPhotoView = (PKRandomUserPhotoView)view.findViewById(R.id.pk_photo_view);
        this.mPKRandomUserPhotoView.startScale(1000L);
        this.timer_task.schedule(new TimerTask(){

            @Override
            public void run() {
                UIHelper.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        PKRandomSearchView.this.angle = PKRandomSearchView.this.angle + 15;
                        if (PKRandomSearchView.this.angle >= circle_angle) {
                            PKRandomSearchView.this.angle = 0;
                        }
                        PKRandomSearchView.this.rotate(PKRandomSearchView.this.angle);
                    }
                });
            }
        }, 0L, 100L);
    }

    private void rotate(int dr) {
        int dd = (dr -= 8) % circle_angle;
        double d2 = Math.PI * (double)dd / 180.0;
        double r = 40.0;
        if (MeiPaiScreenUtil.isLow640Screen()) {
            r = 30.0;
        }
        float x = (float)(r * Math.cos(d2));
        float y = (float)(r * Math.sin(d2));
        float translationX = this.mPkSearchIcon.getTranslationX();
        float translationY = this.mPkSearchIcon.getTranslationY();
        ObjectAnimator animX = ObjectAnimator.ofFloat((Object)this.mPkSearchIcon, (String)"translationX", (float[])new float[]{translationX, x});
        ObjectAnimator animY = ObjectAnimator.ofFloat((Object)this.mPkSearchIcon, (String)"translationY", (float[])new float[]{translationY, y});
        this.sAnimatorSet = new AnimatorSet();
        this.sAnimatorSet.playTogether(new Animator[]{animX, animY});
        this.sAnimatorSet.setDuration(100L);
        this.sAnimatorSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.sAnimatorSet.start();
    }

    public void loadPhoto(String url) {
        if (this.mRealUserPhoto != null) {
            Glide.with((Context)this.getContext()).load(url).apply(RequestOptions.circleCropTransform().placeholder(AvatarRoundUtil.getRoundAvatar(this.mRealUserPhoto.getContext(), R.drawable.meipai_default_avatar_small))).into(this.mRealUserPhoto);
        }
    }

    public void ExecuteMatchSuccessAnim() {
        this.stopSearchAnim();
    }

    public void stop() {
        if (this.timer_task != null) {
            this.timer_task.cancel();
            this.timer_task.purge();
            this.timer_task = null;
            this.mPkSearchIcon.setVisibility(8);
        }
        if (this.mPKRandomUserPhotoView != null) {
            this.mPKRandomUserPhotoView.stop();
        }
    }

    private void stopSearchAnim() {
        if (this.timer_task != null) {
            this.timer_task.cancel();
            this.timer_task.purge();
            this.timer_task = null;
            this.mPkSearchIcon.setVisibility(8);
        }
        if (this.mPKRandomUserPhotoView != null) {
            this.mPKRandomUserPhotoView.stop();
        }
        if (this.mRealUserPhoto != null) {
            this.mRealUserPhoto.setScaleX(0.0f);
            this.mRealUserPhoto.setScaleY(0.0f);
            this.mRealUserPhoto.setVisibility(0);
            AnimatorSet animatorSet = new AnimatorSet();
            ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)this.mRealUserPhoto, (String)"scaleX", (float[])new float[]{0.0f, 1.0f, 1.15f, 0.98f, 1.05f, 1.0f});
            ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)this.mRealUserPhoto, (String)"scaleY", (float[])new float[]{0.0f, 1.0f, 1.15f, 0.98f, 1.05f, 1.0f});
            animatorSet.setDuration(400L);
            animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            animatorSet.play((Animator)scaleX).with((Animator)scaleY);
            animatorSet.start();
        }
    }
}

