/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.ui;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.decoder.AbstractAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import com.unionyy.mobile.meipai.gift.animation.model.GiftSelectRecorder;
import com.unionyy.mobile.meipai.gift.animation.utils.AnimateResourceLoader;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.unionyy.mobile.meipai.gift.animation.utils.GlideUtil;
import com.unionyy.mobile.meipai.gift.animation.utils.ListUtil;
import com.unionyy.mobile.meipai.gift.animation.view.GiftImageView;
import com.unionyy.mobile.meipai.gift.animation.view.StrokeTextView;
import com.unionyy.mobile.meipai.gift.core.config.Middleware2MPGiftMgr;
import com.unionyy.mobile.meipai.gift.data.bean.GiftMaterialBean;
import com.unionyy.mobile.meipai.gift.ui.GiftComponent;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

public class GiftPageViewFragment
extends Fragment {
    public static final int PAGE_MAX_GIFT_COUNT = 8;
    public static final int COLUMNS = 4;
    public static final int COLUMNS_LAND = 7;
    public static final int PAGE_MAX_GIFT_COUNT_LAND = 7;
    public int mColumnsNums = 4;
    public static final float GRID_ITEM_RATIO = 0.94f;
    public int mPageMaxCount = 8;
    private int mOrientation = 1;
    private int pageIndex = 0;
    private static final String PAGE_INDEX = "page_index";
    private static final String SCREEN_ORRIENTATION = "screen_orientation";
    private static final String KEY_TYPE = "key_type";
    private static final String KEY_PACKAGE = "key_package";
    private RecyclerView mGridView;
    private GridAdapter mGridAdapter;
    private volatile GiftMaterialBean selectItem = null;
    private GiftImageView mCurrentGiftImageView;
    private boolean isActionFirstEnterSelect = false;
    private LoadGiftRuleTask mLoadGifRuleTask;
    private GiftSelectRecorder mGiftSelectRecorder;
    private ArrayList<GiftMaterialBean> mPackageGifts;
    private int mType = 0;
    private GiftSelectCallBack giftSelectCallBack;

    public static GiftPageViewFragment newInstance(int type2, int pageIndex, int orientation) {
        GiftPageViewFragment f = new GiftPageViewFragment();
        Bundle b = new Bundle();
        b.putInt(PAGE_INDEX, pageIndex);
        b.putInt(SCREEN_ORRIENTATION, orientation);
        b.putSerializable(KEY_TYPE, (Serializable)Integer.valueOf(type2));
        f.setArguments(b);
        return f;
    }

    public void setPackageGift(ArrayList<GiftMaterialBean> packageGifts) {
        this.mPackageGifts = packageGifts;
    }

    public void onCreate(Bundle savedInstanceState) {
        this.setRetainInstance(true);
        super.onCreate(savedInstanceState);
        Bundle b = this.getArguments();
        if (null != b) {
            this.pageIndex = b.getInt(PAGE_INDEX);
            this.mOrientation = b.getInt(SCREEN_ORRIENTATION);
            this.mType = b.getInt(KEY_TYPE);
        }
        if (this.mOrientation == 1) {
            this.mColumnsNums = 4;
            this.mPageMaxCount = 8;
        } else {
            this.mColumnsNums = 7;
            this.mPageMaxCount = 7;
        }
        this.mGridAdapter = new GridAdapter();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.meipai_live_live_gift_pager_view, container, false);
        this.mGridView = (RecyclerView)view.findViewById(R.id.live_gift_selector_gridview);
        this.mGridView.setHasFixedSize(true);
        this.mGridView.setItemAnimator(null);
        this.mGridView.setAdapter((RecyclerView.Adapter)this.mGridAdapter);
        this.mGridView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(BasicConfig.getInstance().getAppContext(), this.mColumnsNums));
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.selectFirstEnter(true);
    }

    private void selectFirstEnter(boolean send) {
        if (this.mGiftSelectRecorder != null) {
            if (Middleware2MPGiftMgr.Companion.getInstances().isAssignGift()) {
                send = !Middleware2MPGiftMgr.Companion.getInstances().isAssignGift();
            }
            int lastSelectedPagerCount = send ? this.mGiftSelectRecorder.getLastSendPagerCount() : this.mGiftSelectRecorder.getLastSelectPagerCount();
            int lastSelectedPageIndex = send ? this.mGiftSelectRecorder.getLastSendPageIndex() : this.mGiftSelectRecorder.getLastSelectIndex();
            int lastSelectedPosition = send ? this.mGiftSelectRecorder.getLastSendPosition() : this.mGiftSelectRecorder.getLastSelectPosition();
            int lastSelectedFinalPosition = lastSelectedPageIndex * lastSelectedPagerCount + lastSelectedPosition;
            int finalSelectedPageIndex = 0;
            if (this.getResources().getConfiguration().orientation == 1) {
                finalSelectedPageIndex = (int)Math.ceil((double)(lastSelectedFinalPosition + 1) / 8.0 - 1.0);
                lastSelectedPosition = lastSelectedFinalPosition % 8;
            } else {
                finalSelectedPageIndex = (int)Math.ceil((double)(lastSelectedFinalPosition + 1) / 7.0 - 1.0);
                lastSelectedPosition = lastSelectedFinalPosition % 7;
            }
            if (finalSelectedPageIndex == -1) {
                finalSelectedPageIndex = 0;
            }
            if (lastSelectedFinalPosition == 0 && null != this.mGridAdapter && this.mGridAdapter.getItem(finalSelectedPageIndex) != this.mGridAdapter.EMPTY_GIFT_MATERIAL_BEAN) {
                GiftMaterialBean bean = (GiftMaterialBean)this.mGridAdapter.getItem(finalSelectedPageIndex);
                if (bean != null) {
                    if (bean.isWeekCard()) {
                        GiftMaterialBean beanSecond = (GiftMaterialBean)this.mGridAdapter.getItem(finalSelectedPageIndex + 1);
                        lastSelectedPosition = beanSecond != null && beanSecond.getType() == 11 ? (lastSelectedPosition += 2) : ++lastSelectedPosition;
                    } else if (bean.getType() == 11) {
                        ++lastSelectedPosition;
                    }
                } else {
                    MLog.info((Object)"GiftPageViewFragment", (String)"bean is null", (Object[])new Object[0]);
                }
            }
            if (finalSelectedPageIndex == this.pageIndex && !this.isActionFirstEnterSelect) {
                this.isActionFirstEnterSelect = true;
                this.select(lastSelectedPosition);
            }
        }
    }

    private void selectFirstWhenRefresh() {
        if (0 == this.pageIndex) {
            this.select(0);
        }
    }

    public void select(int position) {
        if (null != this.mGridAdapter) {
            if (this.mGridAdapter.getItem(position) != this.mGridAdapter.EMPTY_GIFT_MATERIAL_BEAN) {
                GiftMaterialBean bean = (GiftMaterialBean)this.mGridAdapter.getItem(position);
                if (bean != this.selectItem) {
                    this.setSelect(bean);
                }
            } else if (position != 0) {
                this.select(0);
            }
        }
    }

    public void onDestroy() {
        if (null != this.mLoadGifRuleTask) {
            this.mLoadGifRuleTask.cancel(true);
        }
        this.setSelect(null);
        super.onDestroy();
    }

    private ArrayList<GiftMaterialBean> getGiftsData() {
        if (this.mType == 0) {
            return (ArrayList)Middleware2MPGiftMgr.Companion.getInstances().getMPGiftList();
        }
        return this.mPackageGifts;
    }

    public void setGiftSelectCallBack(GiftSelectCallBack giftSelectCallBack) {
        this.giftSelectCallBack = giftSelectCallBack;
    }

    private GiftPageViewHolder getViewHolder(int position) {
        if (null == this.mGridView || position < 0) {
            return null;
        }
        return (GiftPageViewHolder)this.mGridView.findViewHolderForAdapterPosition(position);
    }

    private void playThumbAnim(GiftMaterialBean gift) {
        if (null != gift && null != gift.getId()) {
            if (null != this.mLoadGifRuleTask) {
                if (this.mLoadGifRuleTask.isTheSameGiftPlaying(gift)) {
                    return;
                }
                this.mLoadGifRuleTask.cancel(true);
                this.mLoadGifRuleTask = null;
            }
            this.mLoadGifRuleTask = new LoadGiftRuleTask();
            this.mLoadGifRuleTask.execute(new GiftMaterialBean[]{gift});
        }
    }

    public void setSelect(GiftMaterialBean item) {
        if (this.selectItem != item && null != this.mGridAdapter) {
            int updatePosition;
            ArrayList<GiftMaterialBean> data = this.getGiftsData();
            if (null != this.selectItem) {
                if (null != this.mCurrentGiftImageView) {
                    this.mCurrentGiftImageView.release();
                    this.mCurrentGiftImageView = null;
                }
                updatePosition = data.indexOf(this.selectItem) % this.mPageMaxCount;
                this.selectItem = null;
                if (updatePosition >= 0) {
                    this.mGridAdapter.notifyItemChanged(updatePosition);
                }
            }
            this.selectItem = item;
            if (null != item) {
                if (null != this.giftSelectCallBack) {
                    this.giftSelectCallBack.onSelect(this.selectItem, this.pageIndex);
                }
                if ((updatePosition = data.indexOf(item) % this.mPageMaxCount) >= 0) {
                    this.mGridAdapter.notifyItemChanged(updatePosition);
                }
            }
        }
    }

    public void updateClickItem(GiftMaterialBean item) {
        ArrayList<GiftMaterialBean> data;
        int updatePosition;
        if (null != this.mGridAdapter && null != item && (updatePosition = (data = this.getGiftsData()).indexOf(item) % this.mPageMaxCount) >= 0) {
            this.mGridAdapter.notifyItemChanged(updatePosition);
        }
    }

    public void setGiftSelectRecorder(GiftSelectRecorder giftSelectRecorder) {
        this.mGiftSelectRecorder = giftSelectRecorder;
    }

    public void refreshPackageRemain(long packageId, int remain) {
        if (this.mGridAdapter != null) {
            this.mGridAdapter.refreshPackageRemain(packageId, remain);
        }
    }

    protected boolean isScreenLandScape() {
        if (this.getContext() != null) {
            return this.getContext().getResources().getConfiguration().orientation == 2;
        }
        return false;
    }

    private class LoadGiftRuleTask
    extends AsyncTask<GiftMaterialBean, Void, GiftRule> {
        private Bitmap mBitmap;
        private GiftMaterialBean mBindGiftItem;

        private LoadGiftRuleTask() {
        }

        public boolean isTheSameGiftPlaying(GiftMaterialBean target) {
            return this.mBindGiftItem == target;
        }

        protected GiftRule doInBackground(GiftMaterialBean ... params) {
            String imagePath;
            String path;
            if (null == params || params.length == 0 || params[0] == null) {
                return null;
            }
            GiftMaterialBean gift = params[0];
            if (null == gift.getId()) {
                return null;
            }
            this.mBindGiftItem = gift;
            String giftId = String.valueOf(gift.getId());
            GiftRule rule = AbstractAnimateDecoder.commonLoadGiftRule(giftId, path = Middleware2MPGiftMgr.Companion.getInstances().getPreEffectPath(gift.getId()), "rule_pre.json", null);
            if (null != rule && (rule.type == 3 || rule.type == 2) && new File(imagePath = rule.type == 3 ? GiftTarget.getMultiImagePathFormat(rule, path) : path + "/" + rule.image).exists()) {
                this.mBitmap = AnimateResourceLoader.getInstance().synLoadSdCardImage(imagePath);
            }
            return rule;
        }

        protected void onPostExecute(GiftRule rule) {
            GiftPageViewHolder viewHolder;
            int index;
            ArrayList dataList;
            if (null != rule && null != this.mBindGiftItem && this.mBindGiftItem == GiftPageViewFragment.this.selectItem && !(dataList = GiftPageViewFragment.this.getGiftsData()).isEmpty() && (index = dataList.indexOf(this.mBindGiftItem)) >= 0 && null != (viewHolder = GiftPageViewFragment.this.getViewHolder(index %= GiftPageViewFragment.this.mPageMaxCount)) && null != viewHolder.img_gift_thumb) {
                GiftPageViewFragment.this.mCurrentGiftImageView = viewHolder.img_gift_thumb;
                if (null != this.mBitmap && !this.mBitmap.isRecycled()) {
                    viewHolder.img_gift_thumb.setImageBitmap(this.mBitmap);
                }
                int width = viewHolder.img_gift_thumb.getMeasuredWidth();
                int height = viewHolder.img_gift_thumb.getMeasuredHeight();
                viewHolder.img_gift_thumb.setGifParams(rule, width, height);
                viewHolder.img_gift_thumb.startGifAnimation();
            }
            this.mBindGiftItem = null;
        }
    }

    public static interface GiftSelectCallBack {
        public void onSelect(GiftMaterialBean var1, int var2);
    }

    private static class GiftPageViewHolder
    extends RecyclerView.ViewHolder {
        RelativeLayout layout_select_frame;
        TextView tv_gift_price;
        TextView tv_gift_name;
        GiftImageView img_gift_thumb;
        View frameRightView;
        View frameBottomView;
        View rlGiftContainer;
        TextView mTvPackageExpired;
        StrokeTextView mSTvPackageRemain;
        View mViewStvWrap;
        ImageView imageTag;
        View viewRedPointTip;

        public GiftPageViewHolder(View itemView) {
            super(itemView);
        }
    }

    private class GridAdapter
    extends RecyclerView.Adapter<GiftPageViewHolder>
    implements View.OnClickListener {
        private final Object EMPTY_GIFT_MATERIAL_BEAN = new Object();

        private GridAdapter() {
        }

        public GiftPageViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
            View convertView = ((LayoutInflater)GiftPageViewFragment.this.getActivity().getSystemService("layout_inflater")).inflate(R.layout.meipai_live_gift_grid_item_view_live, null);
            GiftPageViewHolder viewHolder = new GiftPageViewHolder(convertView);
            viewHolder.layout_select_frame = (RelativeLayout)convertView.findViewById(R.id.layout_select_frame);
            int vWidth = 0;
            vWidth = GiftPageViewFragment.this.mOrientation == 1 ? DeviceUtils.getScreenWidth() / GiftPageViewFragment.this.mColumnsNums : DeviceUtils.getScreenHeight() / GiftPageViewFragment.this.mColumnsNums;
            int vHeight = (int)((float)vWidth / 0.94f);
            convertView.setLayoutParams(new ViewGroup.LayoutParams(vWidth, vHeight));
            viewHolder.tv_gift_price = (TextView)convertView.findViewById(R.id.tv_gift_item_price);
            viewHolder.tv_gift_name = (TextView)convertView.findViewById(R.id.tv_gift_item_name);
            viewHolder.img_gift_thumb = (GiftImageView)convertView.findViewById(R.id.img_gift_item_thumb);
            viewHolder.frameRightView = convertView.findViewById(R.id.gift_frame_right);
            viewHolder.frameBottomView = convertView.findViewById(R.id.gift_frame_bottom);
            viewHolder.rlGiftContainer = convertView.findViewById(R.id.rl_gift_item_container);
            viewHolder.mTvPackageExpired = (TextView)convertView.findViewById(R.id.tv_package_item_expired);
            viewHolder.mSTvPackageRemain = (StrokeTextView)convertView.findViewById(R.id.stv_package_item_remain);
            viewHolder.mViewStvWrap = convertView.findViewById(R.id.ll_package_remain_wrap);
            viewHolder.imageTag = (ImageView)convertView.findViewById(R.id.image_tag);
            viewHolder.viewRedPointTip = convertView.findViewById(R.id.view_red_point_tip);
            convertView.setTag((Object)viewHolder);
            convertView.setOnClickListener((View.OnClickListener)this);
            return viewHolder;
        }

        public long getItemId(int position) {
            GiftMaterialBean bean;
            ArrayList dataList = GiftPageViewFragment.this.getGiftsData();
            if (position < dataList.size() && null != (bean = (GiftMaterialBean)dataList.get(position))) {
                return bean.hashCode();
            }
            return position;
        }

        public void onClick(View v) {
            Object tag = v.getTag(R.id.img_gift_item_thumb);
            if (tag instanceof GiftMaterialBean) {
                Fragment fragment;
                if (((GiftMaterialBean)tag).getType() == 11) {
                    Fragment fragment2 = GiftPageViewFragment.this.getParentFragment();
                    if (fragment2 instanceof GiftComponent) {
                        ((GiftComponent)fragment2).showGesturePannel((GiftMaterialBean)tag);
                    }
                } else if (!((GiftMaterialBean)tag).getIsRedPacket() && !((GiftMaterialBean)tag).isWeekCard()) {
                    GiftMaterialBean bean = (GiftMaterialBean)tag;
                    GiftPageViewFragment.this.setSelect(bean);
                    int updatePosition = GiftPageViewFragment.this.getGiftsData().indexOf(bean) % GiftPageViewFragment.this.mPageMaxCount;
                    if (updatePosition < 0) {
                        updatePosition = 0;
                    }
                    if (GiftPageViewFragment.this.mGiftSelectRecorder != null) {
                        GiftPageViewFragment.this.mGiftSelectRecorder.recordSelectPosition(GiftPageViewFragment.this.pageIndex, updatePosition, GiftPageViewFragment.this.mGridAdapter.getItemCount());
                        Middleware2MPGiftMgr.Companion.getInstances().setMGiftSelectRecorder(GiftPageViewFragment.this.mGiftSelectRecorder);
                    }
                } else if (((GiftMaterialBean)tag).isWeekCard() && (fragment = GiftPageViewFragment.this.getParentFragment()) instanceof GiftComponent) {
                    ((GiftComponent)fragment).showWeekCard();
                }
            }
        }

        public void onBindViewHolder(GiftPageViewHolder viewHolder, int position) {
            Object unCheckBean = this.getItem(position);
            if (unCheckBean == this.EMPTY_GIFT_MATERIAL_BEAN) {
                if (GiftPageViewFragment.this.isScreenLandScape()) {
                    viewHolder.frameRightView.setVisibility(8);
                }
                viewHolder.layout_select_frame.setVisibility(8);
                viewHolder.rlGiftContainer.setVisibility(8);
                viewHolder.itemView.setBackgroundColor(0);
            } else {
                viewHolder.rlGiftContainer.setVisibility(0);
                GiftMaterialBean bean = (GiftMaterialBean)this.getItem(position);
                viewHolder.itemView.setTag(R.id.img_gift_item_thumb, (Object)bean);
                if (null != bean) {
                    if (!bean.isWeekCard()) {
                        String url = bean.getPic();
                        GlideUtil.loadImage(GiftPageViewFragment.this, url, (ImageView)viewHolder.img_gift_thumb, new LoadGifCallBack(GiftPageViewFragment.this, bean, (ImageView)viewHolder.img_gift_thumb));
                    } else {
                        viewHolder.img_gift_thumb.setImageBitmap(BitmapFactory.decodeResource((Resources)GiftPageViewFragment.this.getContext().getResources(), (int)R.drawable.weekcar));
                    }
                    if (GiftPageViewFragment.this.mType == 1 && bean.getPopularity() > 0) {
                        int popularity = bean.getPopularity();
                        String popularityStr = String.valueOf(popularity) + "\u4eba\u6c14";
                        viewHolder.tv_gift_price.setText((CharSequence)popularityStr);
                    } else if (!bean.getIsRedPacket() && !bean.isWeekCard()) {
                        long cost = null == bean.getPrice() ? 0L : bean.getPrice();
                        String coinText = CommonPref.instance().getInt("isShowDiamondAndroid", 0) == 0 ? "\u91d1\u5e01" : "\u91d1\u94bb";
                        viewHolder.tv_gift_price.setText((CharSequence)(String.valueOf(cost /= 10L) + coinText));
                        if (bean.getPrice() == null || bean.getPrice() <= 0L) {
                            viewHolder.tv_gift_price.setVisibility(4);
                        }
                    } else {
                        viewHolder.tv_gift_price.setText((CharSequence)bean.getDesc());
                        if (bean.isWeekCard()) {
                            viewHolder.viewRedPointTip.setVisibility(bean.isShowRedPoint() ? 0 : 8);
                        }
                    }
                    viewHolder.tv_gift_name.setText((CharSequence)bean.getName());
                    if (!StringUtils.isEmpty((String)bean.getTag_pic()).booleanValue()) {
                        GlideUtil.loadImage(GiftPageViewFragment.this, bean.getTag_pic(), viewHolder.imageTag);
                    }
                    boolean isSelect = false;
                    isSelect = GiftPageViewFragment.this.mType == 0 ? null != GiftPageViewFragment.this.selectItem && null != GiftPageViewFragment.this.selectItem.getId() && !bean.getIsRedPacket() && !bean.isWeekCard() && null != bean.getId() && GiftPageViewFragment.this.selectItem.getId().longValue() == bean.getId().longValue() : null != GiftPageViewFragment.this.selectItem && GiftPageViewFragment.this.selectItem.getBag_gift_id() != null && null != bean.getBag_gift_id() && GiftPageViewFragment.this.selectItem.getBag_gift_id().longValue() == bean.getBag_gift_id().longValue();
                    viewHolder.layout_select_frame.setVisibility(isSelect ? 0 : 8);
                    viewHolder.itemView.setBackgroundColor(isSelect ? GiftPageViewFragment.this.getResources().getColor(R.color.meipai_live_color_8040ff_alpha30) : 0);
                    viewHolder.tv_gift_name.getPaint().setFakeBoldText(isSelect);
                    viewHolder.tv_gift_price.setTextColor(isSelect ? GiftPageViewFragment.this.getResources().getColor(R.color.meipai_live_white) : GiftPageViewFragment.this.getResources().getColor(R.color.meipai_live_white60));
                    if (GiftPageViewFragment.this.mType == 1) {
                        viewHolder.mTvPackageExpired.setVisibility(0);
                        viewHolder.mViewStvWrap.setVisibility(0);
                        viewHolder.mTvPackageExpired.setVisibility(isSelect ? 8 : 0);
                        if (!TextUtils.isEmpty((CharSequence)bean.getExpired_caption())) {
                            viewHolder.mTvPackageExpired.setText((CharSequence)bean.getExpired_caption());
                        } else if (bean.getExpired_at() == 0L) {
                            viewHolder.mTvPackageExpired.setVisibility(8);
                        }
                        viewHolder.mSTvPackageRemain.setText("" + bean.getRemain_num());
                    } else {
                        viewHolder.mTvPackageExpired.setVisibility(8);
                    }
                }
            }
        }

        public int getItemCount() {
            return GiftPageViewFragment.this.mPageMaxCount;
        }

        public Object getItem(int position) {
            int p = position + GiftPageViewFragment.this.pageIndex * GiftPageViewFragment.this.mPageMaxCount;
            ArrayList dataList = GiftPageViewFragment.this.getGiftsData();
            if (null == dataList || dataList.isEmpty()) {
                return null;
            }
            if (p >= dataList.size()) {
                return this.EMPTY_GIFT_MATERIAL_BEAN;
            }
            return dataList.get(p);
        }

        public void refreshPackageRemain(long packageId, int remain) {
            if (ListUtil.isNotEmpty(GiftPageViewFragment.this.mPackageGifts)) {
                Iterator iterator = GiftPageViewFragment.this.mPackageGifts.iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    GiftMaterialBean giftMaterialBean = (GiftMaterialBean)iterator.next();
                    if (giftMaterialBean.getBag_gift_id() != null && giftMaterialBean.getBag_gift_id() == packageId) {
                        int position = index - GiftPageViewFragment.this.pageIndex * GiftPageViewFragment.this.mPageMaxCount;
                        if (remain > 0) {
                            if (giftMaterialBean.getRemain_num() >= remain) {
                                giftMaterialBean.setRemain_num(remain);
                                GiftPageViewHolder holder = GiftPageViewFragment.this.getViewHolder(position);
                                if (holder != null) {
                                    holder.mViewStvWrap.setVisibility(0);
                                    holder.mSTvPackageRemain.setText("" + remain);
                                }
                            }
                        } else {
                            iterator.remove();
                            this.notifyItemRemoved(position);
                            this.notifyItemChanged(position, this.getItemCount());
                        }
                    }
                    ++index;
                }
            }
        }
    }

    private static class LoadGifCallBack
    implements RequestListener<Drawable> {
        private final GiftMaterialBean mGiftBean;
        private final WeakReference<ImageView> imageViewWeakReference;
        private final WeakReference<GiftPageViewFragment> fragmentWeakReference;

        public LoadGifCallBack(GiftPageViewFragment fragment, GiftMaterialBean bean, ImageView imageView) {
            this.mGiftBean = bean;
            this.imageViewWeakReference = new WeakReference<ImageView>(imageView);
            this.fragmentWeakReference = new WeakReference<GiftPageViewFragment>(fragment);
        }

        public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
            return false;
        }

        public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
            GiftPageViewFragment fragment = (GiftPageViewFragment)((Object)this.fragmentWeakReference.get());
            ImageView imageView = (ImageView)this.imageViewWeakReference.get();
            if (null == fragment || null == imageView) {
                return false;
            }
            FragmentActivity activity = fragment.getActivity();
            if (null == activity || activity.isFinishing()) {
                return false;
            }
            GiftMaterialBean selectItem = fragment.selectItem;
            if (null == selectItem || this.mGiftBean != selectItem) {
                return false;
            }
            fragment.playThumbAnim(selectItem);
            return false;
        }
    }
}

