/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;
import com.unionyy.mobile.meipai.gift.animation.model.FansMedalBean;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.unionyy.mobile.meipai.gift.animation.utils.GlideUtil;
import com.yy.mobile.config.BasicConfig;

public class SpanUtils {
    private static final String MEDAL_URL_PREFIX = "http://mvimg2.meitudata.com/medal-";
    private static final String MEDAL_URL_TYPE_LONG_SUB_PREFIX = "long-";
    private static final String MEDAL_URL_SUFFIX = ".png";
    public static final int FANS_METAL_TYPE_LONG = 1;
    public static final int FANS_METAL_TYPE_SHORT = 2;

    public static void addFansMedal(final TextView textView, int type2, FansMedalBean fansMedalBean) {
        if (textView != null) {
            if (SpanUtils.checkFanMedalBean(fansMedalBean)) {
                CharSequence text = textView.getText();
                if (text != null && text.length() != 0) {
                    if (1 == type2) {
                        textView.setCompoundDrawablePadding(DeviceUtils.dip2px(4.0f));
                    } else {
                        textView.setCompoundDrawablePadding(DeviceUtils.dip2px(3.0f));
                    }
                    String icon = SpanUtils.getMedalIconUrl(type2, String.valueOf(fansMedalBean.getId()));
                    GlideUtil.loadImage(textView.getContext(), icon, new SimpleTarget<Drawable>(){

                        public void onResourceReady(Drawable resource, Transition<? super Drawable> transition) {
                            if (resource != null) {
                                SpanUtils.setCompoundDrawable(((BitmapDrawable)resource).getBitmap(), textView);
                            }
                        }
                    });
                }
            } else {
                textView.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
            }
        }
    }

    private static void setCompoundDrawable(final Bitmap loadedImage, final TextView textView) {
        if (textView == null) {
            return;
        }
        int textViewHeight = textView.getHeight();
        if (textViewHeight <= 0) {
            textView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    int textViewHeight = textView.getHeight();
                    if (textViewHeight > 0) {
                        textView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        SpanUtils.setCompoundDrawable(loadedImage, textView);
                    }
                }
            });
        } else {
            Context context = BasicConfig.getInstance().getAppContext();
            BitmapDrawable drawable2 = new BitmapDrawable(context.getResources(), loadedImage);
            float densityValue = SpanUtils.getDensityValue();
            int left = 0;
            int top = 0;
            int bitmapHeight = drawable2.getIntrinsicHeight();
            int bitmapWidth = drawable2.getIntrinsicWidth();
            int height = (int)((float)bitmapHeight * densityValue / 2.0f);
            int width = (int)((float)bitmapWidth * densityValue / 2.0f);
            boolean fontHeight = false;
            float blankRate = 1.1f;
            if ((float)height >= (float)textViewHeight / blankRate) {
                float rate = (float)textViewHeight / blankRate / (float)height;
                height = (int)((float)textViewHeight / blankRate);
                width = (int)(rate * (float)width);
            }
            top = Math.max((int)((float)((textViewHeight - height) / 2) - 2.0f * densityValue), 0);
            int right = width + left;
            int bottom = height + top;
            drawable2.setBounds(left, top, right, bottom);
            textView.setCompoundDrawables(null, null, (Drawable)drawable2, null);
        }
    }

    public static boolean checkFanMedalBean(FansMedalBean fansMedalBean) {
        return fansMedalBean != null && fansMedalBean.getId() != null && fansMedalBean.getId() > 0L;
    }

    private static String getMedalIconUrl(int type2, String medalID) {
        if (TextUtils.isEmpty((CharSequence)medalID)) {
            return null;
        }
        String url = MEDAL_URL_PREFIX + medalID + MEDAL_URL_SUFFIX;
        if (1 == type2) {
            url = "http://mvimg2.meitudata.com/medal-long-" + medalID + MEDAL_URL_SUFFIX;
        }
        return url;
    }

    public static float getDensityValue() {
        DisplayMetrics dm = BasicConfig.getInstance().getAppContext().getResources().getDisplayMetrics();
        return dm.density;
    }
}

