/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai;

import android.content.Context;
import android.graphics.PointF;
import android.hardware.Camera;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.meitu.mtlab.MTAiInterface.MTAiEngineResult;
import com.meitu.mtlab.MTAiInterface.MTFaceModule.MTFace;
import com.meitu.mtlab.MTAiInterface.MTFaceModule.MTFaceOption;
import com.meitu.mtlab.MTAiInterface.MeituAiEngine;
import com.meitu.mtlab.MTAiInterface.common.MTAiEngineEnableOption;
import com.meitu.mtlab.MTAiInterface.common.MTAiEngineFrame;
import com.meitu.mtlab.MTAiInterface.common.MTAiEngineImage;
import com.meitu.mtlab.MTAiInterface.common.MTAiEngineOption;
import com.orangefilter.OrangeFilter;
import com.orangefilter.OrangeFilterApi;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.CameraUtils;
import com.yy.mediaframework.facedetection.AccelerDirection;
import com.yy.mediaframework.facedetection.FacePointInfo;
import com.yy.mediaframework.facedetection.FacePoints;
import com.yy.mediaframework.facedetection.MobileFaceDetection;
import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class MTMobileFaceDetectionWrapper
extends MobileFaceDetection
implements Camera.PreviewCallback {
    private static final String TAG = "MTMobileFaceDetectionWrapper";
    private MeituAiEngine mMeituAiEngine;
    private ArrayList<MTFace> mFaceFeatures;
    private MTAiEngineImage image;
    private int mImageHeight;
    private int mImageWidth;
    private int mScaleWidth;
    private int mScaleHeight;
    private final int mMaxFace = 5;
    private int scaleFactor = 1;
    private byte[] mImageData;
    private byte[] mTmpBuffer;
    private byte[] mScaleBuffer;
    private boolean mIsCreateFaceDetectionHandleSucceeded = false;
    private boolean mIsPaused = false;
    private boolean mCameraChanging = false;
    private static final int MESSAGE_PROCESS_IMAGE = 100;
    private static final int MESSAGE_RESET_FACE = 104;
    private HandlerThread mProcessImageThread;
    private Handler mProcessImageHandler;
    private final Object mMTFaceHandleLock = new Object();
    private final Object nv21Lock = new Object();
    private final Object mLastUpdateLock = new Object();
    private FacePointInfo mLastUpdateFacePointInfo;
    private ConcurrentLinkedQueue<FacePointInfo> mFacePointInfoQueue = null;
    private Context mContext;
    private AtomicBoolean mInited = new AtomicBoolean(false);
    private FacePoints mFacePoints = new FacePoints(0, 0.0f, (float[][])null);
    private int mFaceID = -1;
    private static int STRIDE_MULTIPLE = 4;
    private String resDir = Environment.getExternalStorageDirectory().getPath();

    public MTMobileFaceDetectionWrapper(Context context) {
        this.mContext = context.getApplicationContext();
        this.mFacePointInfoQueue = new ConcurrentLinkedQueue();
        this.mAcc = new AccelerDirection(context);
        for (int i = 0; i < 5; ++i) {
            FacePointInfo pointInfo = new FacePointInfo();
            pointInfo.mFrameData = new OrangeFilter.OF_FrameData();
            this.mFacePointInfoQueue.add(pointInfo);
        }
        YMFLog.info((Object)((Object)this), (String)"MTMobileFaceDetectionWrapper construct");
    }

    public void init() {
        YMFLog.info((String)TAG, (String)"MT init enter");
        this.initMTFace();
        this.mAcc.start();
        YMFLog.info((String)TAG, (String)"MT init exit");
    }

    public void deInit() {
        YMFLog.info((Object)((Object)this), (String)"[Preprocess][face] MT deInit enter");
        this.deInitMTFace();
        this.mAcc.stop();
        YMFLog.info((Object)((Object)this), (String)"[Preprocess][face] MT deInit exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMTFace() {
        Object object = this.mMTFaceHandleLock;
        synchronized (object) {
            if (!this.mInited.get()) {
                YMFLog.info((String)TAG, (String)"[Preprocess][face] MTMobileWrapper initMTMobile begin");
                try {
                    this.mMeituAiEngine = new MeituAiEngine(this.mContext, 1);
                }
                catch (UnsatisfiedLinkError e) {
                    YMFLog.error((Object)TAG, (String)("MTFaceDetector\uff1a" + e));
                    return;
                }
                catch (NoClassDefFoundError e) {
                    YMFLog.error((Object)TAG, (String)("MTFaceDetector\uff1a" + e));
                    return;
                }
                this.mMeituAiEngine.setModelDirectory("MTAiModel");
                YMFLog.info((String)TAG, (String)"initMTFace success");
                MTFaceOption faceDetectorOption = new MTFaceOption();
                faceDetectorOption.mode = 8;
                faceDetectorOption.option = 0xC00001;
                this.mMeituAiEngine.registerModule(0, (MTAiEngineOption)faceDetectorOption);
                this.mIsCreateFaceDetectionHandleSucceeded = true;
                this.mProcessImageThread = new HandlerThread("MT handle thread");
                this.mProcessImageThread.start();
                this.mProcessImageHandler = new Handler(this.mProcessImageThread.getLooper()){

                    public void handleMessage(Message msg) {
                        try {
                            if (!MTMobileFaceDetectionWrapper.this.mIsPaused && MTMobileFaceDetectionWrapper.this.mIsCreateFaceDetectionHandleSucceeded) {
                                switch (msg.what) {
                                    case 100: {
                                        boolean bYUVData = (Boolean)msg.obj;
                                        if (!bYUVData) break;
                                        MTMobileFaceDetectionWrapper.this.processCameraData();
                                        break;
                                    }
                                    case 104: {
                                        MTMobileFaceDetectionWrapper.this.resetFacePointInfo();
                                        break;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            YMFLog.error((Object)MTMobileFaceDetectionWrapper.TAG, (String)("handleMessage  " + msg.what + " :" + YMFLog.stackTraceOf((Throwable)e)));
                        }
                    }
                };
                this.mInited.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deInitMTFace() {
        Object object = this.mMTFaceHandleLock;
        synchronized (object) {
            if (this.mInited.get()) {
                YMFLog.info((String)TAG, (String)"[Preprocess][face] VMTMobileWrapper deInitVenus begin");
                this.mFaceID = -1;
                if (this.mProcessImageHandler != null) {
                    this.mProcessImageHandler.removeCallbacksAndMessages(null);
                    if (Build.VERSION.SDK_INT >= 18) {
                        this.mProcessImageThread.quitSafely();
                    } else {
                        this.mProcessImageThread.quit();
                    }
                    this.mProcessImageHandler = null;
                    this.mProcessImageThread = null;
                }
                YMFLog.info((String)TAG, (String)"[Preprocess][face] VenusMobileWrapper deInitVenus end");
            }
            this.mInited.set(false);
            if (this.mMeituAiEngine != null) {
                this.mMeituAiEngine.unregisterModule(0);
                this.mMeituAiEngine = null;
            } else {
                YMFLog.error((Object)TAG, (String)"[Preprocess][face] deInit MTEngine is null");
            }
        }
        object = this.nv21Lock;
        synchronized (object) {
            this.mImageData = null;
            this.mTmpBuffer = null;
            this.mScaleBuffer = null;
            this.mImageWidth = 0;
            this.mImageHeight = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] data, Camera camera) {
        if (data == null || camera == null) {
            YMFLog.error((Object)TAG, (String)("[Camera]onPreviewFrame error, data: " + data + " ,camera: " + camera));
            return;
        }
        Object object = this.nv21Lock;
        synchronized (object) {
            if (this.mImageWidth == 0 || this.mImageHeight == 0) {
                YMFLog.warn((Object)TAG, (String)"[Camera]onPreviewFrame error mImageWidth or mImageHeight is 0 !!");
                return;
            }
            if (this.mImageData == null || this.mImageData.length != this.mImageHeight * this.mImageWidth * 3 / 2) {
                this.mImageData = new byte[this.mImageWidth * this.mImageHeight * 3 / 2];
            }
            System.arraycopy(data, 0, this.mImageData, 0, data.length);
        }
        if (this.mCallback != null && this.mCallback.get() != null) {
            ((PreviewFrameCallback)this.mCallback.get()).onPreviewFrameAvailable(data, camera);
        }
        CameraInterface.getInstance().addCallbackBuffer(data);
        if (!this.getNeedFaceDetected()) {
            return;
        }
        object = this.mMTFaceHandleLock;
        synchronized (object) {
            if (this.mProcessImageHandler != null && this.mInited.get()) {
                this.mProcessImageHandler.removeMessages(100);
                Message msg = Message.obtain();
                msg.what = 100;
                msg.obj = true;
                this.mProcessImageHandler.sendMessage(msg);
            }
        }
    }

    private void mapMTLabFace2Sense(PointF[] pointF, float[] stPoints) {
        for (int i = 0; i <= 32; ++i) {
            stPoints[i * 2 + 0] = pointF[i].x;
            stPoints[i * 2 + 1] = pointF[i].y;
        }
        stPoints[66] = pointF[33].x;
        stPoints[67] = pointF[33].y;
        stPoints[68] = pointF[34].x;
        stPoints[69] = pointF[34].y;
        stPoints[70] = pointF[35].x;
        stPoints[71] = pointF[35].y;
        stPoints[72] = pointF[36].x;
        stPoints[73] = pointF[36].y;
        stPoints[74] = pointF[37].x;
        stPoints[75] = pointF[37].y;
        stPoints[76] = pointF[42].x;
        stPoints[77] = pointF[42].y;
        stPoints[78] = pointF[43].x;
        stPoints[79] = pointF[43].y;
        stPoints[80] = pointF[44].x;
        stPoints[81] = pointF[44].y;
        stPoints[82] = pointF[45].x;
        stPoints[83] = pointF[45].y;
        stPoints[84] = pointF[46].x;
        stPoints[85] = pointF[46].y;
        stPoints[86] = pointF[71].x;
        stPoints[87] = pointF[71].y;
        stPoints[88] = pointF[72].x;
        stPoints[89] = pointF[72].y;
        stPoints[90] = pointF[73].x;
        stPoints[91] = pointF[73].y;
        stPoints[92] = pointF[74].x;
        stPoints[93] = pointF[74].y;
        stPoints[94] = pointF[78].x;
        stPoints[95] = pointF[78].y;
        stPoints[96] = pointF[79].x;
        stPoints[97] = pointF[79].y;
        stPoints[98] = pointF[80].x;
        stPoints[99] = pointF[80].y;
        stPoints[100] = pointF[81].x;
        stPoints[101] = pointF[81].y;
        stPoints[102] = pointF[82].x;
        stPoints[103] = pointF[82].y;
        stPoints[104] = pointF[51].x;
        stPoints[105] = pointF[51].y;
        stPoints[106] = pointF[52].x;
        stPoints[107] = pointF[52].y;
        stPoints[108] = pointF[54].x;
        stPoints[109] = pointF[54].y;
        stPoints[110] = pointF[55].x;
        stPoints[111] = pointF[55].y;
        stPoints[112] = pointF[56].x;
        stPoints[113] = pointF[56].y;
        stPoints[114] = pointF[58].x;
        stPoints[115] = pointF[58].y;
        stPoints[116] = pointF[61].x;
        stPoints[117] = pointF[61].y;
        stPoints[118] = pointF[62].x;
        stPoints[119] = pointF[62].y;
        stPoints[120] = pointF[64].x;
        stPoints[121] = pointF[64].y;
        stPoints[122] = pointF[65].x;
        stPoints[123] = pointF[65].y;
        stPoints[124] = pointF[66].x;
        stPoints[125] = pointF[66].y;
        stPoints[126] = pointF[68].x;
        stPoints[127] = pointF[68].y;
        stPoints[128] = pointF[41].x;
        stPoints[129] = pointF[41].y;
        stPoints[130] = pointF[40].x;
        stPoints[131] = pointF[40].y;
        stPoints[132] = pointF[39].x;
        stPoints[133] = pointF[39].y;
        stPoints[134] = pointF[38].x;
        stPoints[135] = pointF[38].y;
        stPoints[136] = pointF[50].x;
        stPoints[137] = pointF[50].y;
        stPoints[138] = pointF[49].x;
        stPoints[139] = pointF[49].y;
        stPoints[140] = pointF[48].x;
        stPoints[141] = pointF[48].y;
        stPoints[142] = pointF[47].x;
        stPoints[143] = pointF[47].y;
        stPoints[144] = pointF[53].x;
        stPoints[145] = pointF[53].y;
        stPoints[146] = pointF[57].x;
        stPoints[147] = pointF[57].y;
        stPoints[148] = pointF[60].x;
        stPoints[149] = pointF[60].y;
        stPoints[150] = pointF[63].x;
        stPoints[151] = pointF[63].y;
        stPoints[152] = pointF[67].x;
        stPoints[153] = pointF[67].y;
        stPoints[154] = pointF[70].x;
        stPoints[155] = pointF[70].y;
        stPoints[156] = pointF[75].x;
        stPoints[157] = pointF[75].y;
        stPoints[158] = pointF[85].x;
        stPoints[159] = pointF[85].y;
        stPoints[160] = pointF[76].x;
        stPoints[161] = pointF[76].y;
        stPoints[162] = pointF[84].x;
        stPoints[163] = pointF[84].y;
        stPoints[164] = pointF[77].x;
        stPoints[165] = pointF[77].y;
        stPoints[166] = pointF[83].x;
        stPoints[167] = pointF[83].y;
        stPoints[168] = pointF[86].x;
        stPoints[169] = pointF[86].y;
        stPoints[170] = pointF[87].x;
        stPoints[171] = pointF[87].y;
        stPoints[172] = pointF[88].x;
        stPoints[173] = pointF[88].y;
        stPoints[174] = pointF[89].x;
        stPoints[175] = pointF[89].y;
        stPoints[176] = pointF[90].x;
        stPoints[177] = pointF[90].y;
        stPoints[178] = pointF[91].x;
        stPoints[179] = pointF[91].y;
        stPoints[180] = pointF[92].x;
        stPoints[181] = pointF[92].y;
        stPoints[182] = pointF[93].x;
        stPoints[183] = pointF[93].y;
        stPoints[184] = pointF[94].x;
        stPoints[185] = pointF[94].y;
        stPoints[186] = pointF[95].x;
        stPoints[187] = pointF[95].y;
        stPoints[188] = pointF[96].x;
        stPoints[189] = pointF[96].y;
        stPoints[190] = pointF[97].x;
        stPoints[191] = pointF[97].y;
        stPoints[192] = pointF[98].x;
        stPoints[193] = pointF[98].y;
        stPoints[194] = pointF[99].x;
        stPoints[195] = pointF[99].y;
        stPoints[196] = pointF[100].x;
        stPoints[197] = pointF[100].y;
        stPoints[198] = pointF[101].x;
        stPoints[199] = pointF[101].y;
        stPoints[200] = pointF[102].x;
        stPoints[201] = pointF[102].y;
        stPoints[202] = pointF[103].x;
        stPoints[203] = pointF[103].y;
        stPoints[204] = pointF[104].x;
        stPoints[205] = pointF[104].y;
        stPoints[206] = pointF[105].x;
        stPoints[207] = pointF[105].y;
        stPoints[208] = pointF[60].x;
        stPoints[209] = pointF[60].y;
        stPoints[210] = pointF[70].x;
        stPoints[211] = pointF[70].y;
    }

    private int mapSTDirectionToMT(boolean isFrontCamera, int direction) {
        int orientationMT = 0;
        if (isFrontCamera) {
            switch (direction) {
                case 0: {
                    orientationMT = 1;
                    break;
                }
                case 1: {
                    orientationMT = 6;
                    break;
                }
                case 2: {
                    orientationMT = 3;
                    break;
                }
                case 3: {
                    orientationMT = 8;
                    break;
                }
            }
        } else {
            switch (direction) {
                case 0: {
                    orientationMT = 4;
                    break;
                }
                case 1: {
                    orientationMT = 7;
                    break;
                }
                case 2: {
                    orientationMT = 2;
                    break;
                }
                case 3: {
                    orientationMT = 5;
                    break;
                }
            }
        }
        return orientationMT;
    }

    private void processFacePoint(boolean portrait, boolean frontCamera, double angle, int dir) {
        float x = 0.0f;
        float y = 0.0f;
        if (this.mFaceFeatures != null) {
            int faceCount = this.mFaceFeatures.size();
            for (int i = 0; i < faceCount; ++i) {
                for (int j = 0; j < this.mFaceFeatures.get((int)i).facePoints.length; ++j) {
                    x = this.mFaceFeatures.get((int)i).facePoints[j].x;
                    y = this.mFaceFeatures.get((int)i).facePoints[j].y;
                    if (!frontCamera) {
                        if (!portrait) {
                            this.mFaceFeatures.get((int)i).facePoints[j].x = (x - 0.5f) * (float)Math.cos(Math.PI * angle / 180.0) - (y - 0.5f) * (float)Math.sin(Math.PI * angle / 180.0) + 0.5f;
                            this.mFaceFeatures.get((int)i).facePoints[j].y = (x - 0.5f) * (float)Math.sin(Math.PI * angle / 180.0) + (y - 0.5f) * (float)Math.cos(Math.PI * angle / 180.0) + 0.5f;
                            continue;
                        }
                        this.mFaceFeatures.get((int)i).facePoints[j].x = 1.0f - ((x - 0.5f) * (float)Math.cos(Math.PI * angle / 180.0) - (y - 0.5f) * (float)Math.sin(Math.PI * angle / 180.0) + 0.5f);
                        this.mFaceFeatures.get((int)i).facePoints[j].y = (x - 0.5f) * (float)Math.sin(Math.PI * angle / 180.0) + (y - 0.5f) * (float)Math.cos(Math.PI * angle / 180.0) + 0.5f;
                        continue;
                    }
                    if (!portrait) {
                        this.mFaceFeatures.get((int)i).facePoints[j].x = 1.0f - ((x - 0.5f) * (float)Math.cos(Math.PI * angle / 180.0) + (y - 0.5f) * (float)Math.sin(Math.PI * angle / 180.0) + 0.5f);
                        this.mFaceFeatures.get((int)i).facePoints[j].y = (x - 0.5f) * (float)Math.sin(Math.PI * angle / 180.0) + (y - 0.5f) * (float)Math.cos(Math.PI * angle / 180.0) + 0.5f;
                        continue;
                    }
                    if (dir == 0) {
                        this.mFaceFeatures.get((int)i).facePoints[j].x = (x - 0.5f) * (float)Math.cos(Math.PI * angle / 180.0) + (y - 0.5f) * (float)Math.sin(Math.PI * angle / 180.0) + 0.5f;
                        this.mFaceFeatures.get((int)i).facePoints[j].y = 1.0f - ((x - 0.5f) * (float)Math.sin(Math.PI * angle / 180.0) - (y - 0.5f) * (float)Math.cos(Math.PI * angle / 180.0) + 0.5f);
                        return;
                    }
                    this.mFaceFeatures.get((int)i).facePoints[j].x = 1.0f - ((x - 0.5f) * (float)Math.cos(Math.PI * angle / 180.0) + (y - 0.5f) * (float)Math.sin(Math.PI * angle / 180.0) + 0.5f);
                    this.mFaceFeatures.get((int)i).facePoints[j].y = 1.0f - ((x - 0.5f) * (float)Math.sin(Math.PI * angle / 180.0) + (y - 0.5f) * (float)Math.cos(Math.PI * angle / 180.0) + 0.5f);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCameraData() {
        int dir;
        Object object = this.nv21Lock;
        synchronized (object) {
            if (this.mInited.get()) {
                if (this.mTmpBuffer == null || this.mCameraChanging || this.mTmpBuffer.length != this.mImageHeight * this.mImageWidth * 3 / 2) {
                    this.mTmpBuffer = new byte[this.mImageWidth * this.mImageHeight * 3 / 2];
                }
                if (this.mTmpBuffer == null || this.mImageData == null || this.mTmpBuffer.length != this.mImageData.length) {
                    YMFLog.error((Object)TAG, (String)"mTmpBuffer or mImageData null");
                    return;
                }
            } else {
                return;
            }
            System.arraycopy(this.mImageData, 0, this.mTmpBuffer, 0, this.mImageData.length);
        }
        boolean frontCamera = CameraInterface.getInstance().getCameraFacing() == CameraUtils.CameraFacing.FacingFront;
        int orgDir = dir = AccelerDirection.getDirection();
        if (!frontCamera && dir == 0) {
            dir = 2;
        } else if (!frontCamera && dir == 2) {
            dir = 0;
        }
        if (CameraInterface.getInstance().getCameraInfo().orientation == 270 && (dir & 1) == 1 || CameraInterface.getInstance().getCameraInfo().orientation == 90 && (dir & 1) == 1) {
            dir ^= 2;
        }
        Object object2 = this.mMTFaceHandleLock;
        synchronized (object2) {
            MTFace[] faces;
            if (!this.mIsCreateFaceDetectionHandleSucceeded || !this.mInited.get()) {
                YMFLog.error((Object)TAG, (String)"processCameraData while mSTMobileHumanActionNative is null, just return");
                return;
            }
            if (this.mFaceFeatures != null) {
                this.mFaceFeatures.clear();
            }
            if (this.scaleFactor != 1) {
                OrangeFilterApi.nv12DownSample((byte[])this.mTmpBuffer, (byte[])this.mScaleBuffer, (int)this.mImageHeight, (int)this.mImageWidth, (int)this.mScaleHeight, (int)this.mScaleWidth);
            }
            int orientation = this.mapSTDirectionToMT(frontCamera, dir);
            MTAiEngineEnableOption enableOption = new MTAiEngineEnableOption();
            enableOption.faceOption.option = 1;
            this.image = this.scaleFactor != 1 ? MTAiEngineImage.createImageFromFormatByteBuffer((int)this.mScaleWidth, (int)this.mScaleHeight, (ByteBuffer)ByteBuffer.wrap(this.mScaleBuffer), (int)4, (int)orientation, (int)this.mScaleWidth) : MTAiEngineImage.createImageFromFormatByteBuffer((int)this.mImageWidth, (int)this.mImageHeight, (ByteBuffer)ByteBuffer.wrap(this.mImageData), (int)4, (int)orientation, (int)this.mImageWidth);
            this.mFaceFeatures = new ArrayList();
            MTAiEngineFrame frame = new MTAiEngineFrame();
            frame.colorImage = this.image;
            int finalOrientation = this.getOrientation(frontCamera, dir);
            MTAiEngineResult detectorResult = this.mMeituAiEngine.run(frame, enableOption, finalOrientation);
            if (detectorResult != null && detectorResult.faceResult != null && (faces = detectorResult.faceResult.faces) != null && faces.length > 0) {
                for (MTFace s : faces) {
                    this.mFaceFeatures.add(s);
                }
            }
            if (this.mFaceFeatures != null) {
                this.addCurrentFaceDetectionFrameData(frontCamera, dir);
            }
        }
    }

    private int getOrientation(boolean frontCamera, int dir) {
        if (frontCamera) {
            switch (dir) {
                case 0: {
                    return 7;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 5;
                }
            }
            return 2;
        }
        switch (dir) {
            case 0: {
                return 5;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 7;
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCurrentFaceDetectionFrameData(boolean frontCamera, int dir) {
        try {
            if (this.mCameraChanging || this.mIsPaused || this.mFaceFeatures == null) {
                return;
            }
            FacePointInfo pointInfo = this.mFacePointInfoQueue.poll();
            if (pointInfo == null) {
                YMFLog.error((Object)TAG, (String)"[Preprocess][face] not point info in queue!!!");
                return;
            }
            boolean portrait = CameraInterface.getInstance().getDisplayRotation() == 0;
            int faceCount = this.mFaceFeatures.size();
            if (faceCount > 0) {
                if (faceCount != pointInfo.mFaceCount || pointInfo.mFrameData == null) {
                    pointInfo.mFrameData = new OrangeFilter.OF_FrameData();
                }
                if (faceCount != pointInfo.mFaceCount || pointInfo.mFacePoints == null) {
                    pointInfo.mFacePoints = new float[faceCount][212];
                }
                if (faceCount != pointInfo.mFaceCount || pointInfo.mFrameData.faceFrameDataArr == null) {
                    pointInfo.mFrameData.faceFrameDataArr = new OrangeFilter.OF_FaceFrameData[faceCount];
                    for (int i = 0; i < faceCount; ++i) {
                        pointInfo.mFrameData.faceFrameDataArr[i] = new OrangeFilter.OF_FaceFrameData();
                    }
                }
                pointInfo.mFaceCount = faceCount;
                float[][] mTempFacePoints = pointInfo.mFacePoints;
                for (int i = 0; i < faceCount; ++i) {
                    this.mapMTLabFace2Sense(this.mFaceFeatures.get((int)i).facePoints, mTempFacePoints[i]);
                    pointInfo.mFrameData.faceFrameDataArr[i].facePoints = mTempFacePoints[i];
                }
            } else {
                pointInfo.mFaceCount = 0;
                if (pointInfo.mFrameData != null) {
                    pointInfo.mFrameData.faceFrameDataArr = null;
                }
            }
            this.updateFacePoint(pointInfo);
            FacePointInfo origPoint = null;
            Object object = this.mLastUpdateLock;
            synchronized (object) {
                origPoint = this.mLastUpdateFacePointInfo;
                this.mLastUpdateFacePointInfo = pointInfo;
            }
            if (origPoint != null) {
                this.mFacePointInfoQueue.add(origPoint);
            }
        }
        catch (Exception e) {
            YMFLog.error((Object)TAG, (String)("[face] exception:" + e.toString()));
        }
    }

    private void updateFacePoint(FacePointInfo pointInfo) {
        if (this.mFacePoints != null) {
            if (pointInfo.mFaceCount > 0) {
                float faceScore = 0.0f;
                if (this.mFaceFeatures != null && this.mFaceFeatures.get(0) != null) {
                    faceScore = this.mFaceFeatures.get((int)0).score;
                }
                this.mFacePoints.updateFacePoints(pointInfo.mFaceCount, faceScore, new float[1][212]);
                System.arraycopy(pointInfo.mFacePoints[0], 0, this.mFacePoints.mFacePoints[0], 0, 212);
            } else {
                this.mFacePoints.updateFacePoints(0, 0.0f, (float[][])null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviewCallbackWithBuffer(int previewWidth, int previewHeight) {
        YMFLog.info((String)TAG, (String)("[Preprocess][sjc]setPreviewCallbackWithBuffer,previewWidth: " + previewWidth + " ,previewHeight: " + previewHeight));
        if (previewWidth < previewHeight) {
            this.mImageWidth = previewHeight;
            this.mImageHeight = previewWidth;
        } else {
            this.mImageWidth = previewWidth;
            this.mImageHeight = previewHeight;
        }
        this.mScaleWidth = this.mImageWidth / this.scaleFactor;
        this.mScaleHeight = this.mImageHeight / this.scaleFactor;
        Object object = this.mMTFaceHandleLock;
        synchronized (object) {
            this.mImageData = new byte[this.mImageWidth * this.mImageHeight * 3 / 2];
            this.mTmpBuffer = new byte[this.mImageWidth * this.mImageHeight * 3 / 2];
            this.mScaleBuffer = new byte[this.mScaleWidth * this.mScaleHeight * 3 / 2];
        }
        CameraInterface.getInstance().setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
    }

    public FacePoints getFacePoint() {
        return this.mFacePoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacePointInfo getCurrentFacePointInfo() {
        if (!this.mInited.get() && this.mLastUpdateFacePointInfo != null) {
            this.mLastUpdateFacePointInfo.mFaceCount = 0;
            this.mLastUpdateFacePointInfo.mFacePoints = null;
        }
        FacePointInfo pointInfo = null;
        Object object = this.mLastUpdateLock;
        synchronized (object) {
            pointInfo = this.mLastUpdateFacePointInfo;
            this.mLastUpdateFacePointInfo = null;
        }
        return pointInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFacePointInfo(FacePointInfo facePoint) {
        FacePointInfo tmpPointInfo = null;
        Object object = this.mLastUpdateLock;
        synchronized (object) {
            if (this.mLastUpdateFacePointInfo == null) {
                this.mLastUpdateFacePointInfo = facePoint;
            } else {
                tmpPointInfo = facePoint;
            }
        }
        if (tmpPointInfo != null) {
            this.mFacePointInfoQueue.add(tmpPointInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFacePointInfo() {
        Object object = this.mLastUpdateLock;
        synchronized (object) {
            this.mImageData = null;
            FacePointInfo tmpPointInfo = this.mLastUpdateFacePointInfo = null;
            if (tmpPointInfo != null) {
                this.mFacePointInfoQueue.add(tmpPointInfo);
            }
            this.mProcessImageHandler.removeMessages(100);
            this.mIsCreateFaceDetectionHandleSucceeded = this.mProcessImageHandler != null;
        }
    }

    public boolean isFaceDetectionInitiated() {
        return this.mInited.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFaceDetectData(float[][] facePoints) {
        FacePointInfo pointInfo = this.mFacePointInfoQueue.poll();
        if (pointInfo == null) {
            YMFLog.warn((Object)((Object)this), (String)"[Preprocess][sjc] not point info in queue!!!");
            return;
        }
        if (facePoints != null) {
            int faceCount = facePoints.length;
            if (faceCount > 0) {
                int i;
                if (faceCount != pointInfo.mFaceCount) {
                    pointInfo.mFacePoints = new float[faceCount][212];
                    pointInfo.mFrameData.faceFrameDataArr = new OrangeFilter.OF_FaceFrameData[faceCount];
                    for (i = 0; i < faceCount; ++i) {
                        pointInfo.mFrameData.faceFrameDataArr[i] = new OrangeFilter.OF_FaceFrameData();
                        pointInfo.mFrameData.faceFrameDataArr[i].facePoints = new float[212];
                    }
                }
                pointInfo.mFaceCount = faceCount;
                for (i = 0; i < faceCount; ++i) {
                    System.arraycopy(facePoints[i], 0, pointInfo.mFrameData.faceFrameDataArr[i].facePoints, 0, facePoints[i].length);
                }
            }
        } else {
            pointInfo.mFaceCount = 0;
        }
        FacePointInfo origPoint = null;
        Object object = this.mLastUpdateLock;
        synchronized (object) {
            origPoint = this.mLastUpdateFacePointInfo;
            this.mLastUpdateFacePointInfo = pointInfo;
        }
        if (origPoint != null) {
            this.mFacePointInfoQueue.add(origPoint);
        }
    }

    public void resetFaceLimit() {
    }

    public void setFaceLimit(int num) {
    }
}

