/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.dialog.Adapter;

import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.personalcard.MeipaiPersonalCardBuilder;
import com.unionyy.mobile.meipai.pk.core.IMeiPaiPkCore;
import com.unionyy.mobile.meipai.pk.core.MeiPaiPkProtocols;
import com.unionyy.mobile.meipai.pk.ui.dialog.Adapter.Model.MeiPaiPKInviteOrientRecyclerAdapterInfo;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.CircleCompatImageView;
import com.yy.mobile.memoryrecycle.drawablerecycle.DrawableUtil;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;

public class MeiPaiPKInviteOrientRecyclerAdapter
extends RecyclerView.Adapter<MyViewHolder>
implements View.OnClickListener {
    private static final String TAG = "MeiPaiPKInviteOrientRecyclerAdapter";
    private FragmentActivity mContext;
    private ArrayList<MeiPaiPKInviteOrientRecyclerAdapterInfo> adapterItem = new ArrayList();
    public boolean isActionStateStart = false;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();
    Handler mHandler = new SafeDispatchHandler(Looper.getMainLooper());

    public MeiPaiPKInviteOrientRecyclerAdapter(RecyclerView recyclerView, FragmentActivity activity) {
        this.mContext = activity;
    }

    public void setData(ArrayList<MeiPaiPKInviteOrientRecyclerAdapterInfo> data) {
        if (data != null) {
            this.adapterItem.clear();
            this.adapterItem.addAll(data);
        }
    }

    public void cleanData() {
        this.adapterItem.clear();
    }

    public ArrayList<MeiPaiPKInviteOrientRecyclerAdapterInfo> getData() {
        if (this.adapterItem != null) {
            return this.adapterItem;
        }
        return null;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.meipai_pk_invate_oriented_action_button) {
            final int position = (Integer)view.getTag();
            if (position >= this.adapterItem.size()) {
                return;
            }
            this.isActionStateStart = true;
            final MeiPaiPKInviteOrientRecyclerAdapterInfo item = this.adapterItem.get(position);
            item.userState = UserState.PK_COUNTDOEN;
            item.countDown = -10;
            final Button button = (Button)view;
            this.changeActionButton(item, button);
            MLog.info((Object)TAG, (String)("position1:" + position), (Object[])new Object[0]);
            Disposable disposable = ((IMeiPaiPkCore)CoreFactory.getCore(IMeiPaiPkCore.class)).reqInviteWithCallBack(item.uid).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MeiPaiPkProtocols.PMeipaiPKNotify>(){

                public void accept(MeiPaiPkProtocols.PMeipaiPKNotify rsp) throws Exception {
                    MLog.info((Object)MeiPaiPKInviteOrientRecyclerAdapter.TAG, (String)("[PK] reqInviteWithCallBack rsp: " + rsp), (Object[])new Object[0]);
                    int result = rsp.result.intValue();
                    if (result == 0) {
                        item.countDown = StringUtils.safeParseInt((String)rsp.extendInfo.get("iv_left_sec"));
                        MeiPaiPKInviteOrientRecyclerAdapter.this.countDownInviteTime(button, position, item);
                    } else {
                        MeiPaiPKInviteOrientRecyclerAdapter.this.isActionStateStart = false;
                        item.userState = result == 1 ? UserState.PK_PLAYING : (result == 6 ? UserState.PK_NO_INVITE : UserState.PK_START);
                        MeiPaiPKInviteOrientRecyclerAdapter.this.changeActionButton(item, button);
                        if (!FP.empty((CharSequence)rsp.errDesc)) {
                            Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)rsp.errDesc, (int)0).show();
                        }
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) throws Exception {
                    MeiPaiPKInviteOrientRecyclerAdapter.this.isActionStateStart = false;
                    Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)"\u7f51\u7edc\u5f02\u5e38,\u8bf7\u7a0d\u540e\u91cd\u8bd5", (int)0).show();
                    item.userState = UserState.PK_START;
                    MeiPaiPKInviteOrientRecyclerAdapter.this.changeActionButton(item, button);
                    MLog.error((Object)MeiPaiPKInviteOrientRecyclerAdapter.TAG, (String)("[PK] reqInviteWithCallBack error: " + throwable), (Object[])new Object[0]);
                }
            });
            this.isActionStateStart = true;
            this.compositeDisposable.add(disposable);
        } else if (view.getId() == R.id.meipai_pk_invate_oriented_portrait_imageView || view.getId() == R.id.meipai_pk_invate_oriented_name_textView) {
            int position = (Integer)view.getTag();
            if (position >= this.adapterItem.size()) {
                return;
            }
            MeiPaiPKInviteOrientRecyclerAdapterInfo item = this.adapterItem.get(position);
            if (item.uid > 0L) {
                MeipaiPersonalCardBuilder cardBuilder = new MeipaiPersonalCardBuilder(item.uid);
                cardBuilder.fromWhereArea(MeipaiPersonalCardBuilder.FromWhereArea.NORMAL_USER);
                cardBuilder.show();
            } else {
                Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)"\u6570\u636e\u9519\u8bef", (int)0).show();
            }
        }
    }

    @NonNull
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.meipai_listlitem_pk_invite_oriented, parent, false);
        MyViewHolder vh = new MyViewHolder(view);
        vh.action.setOnClickListener((View.OnClickListener)this);
        vh.avatar.setOnClickListener((View.OnClickListener)this);
        vh.name.setOnClickListener((View.OnClickListener)this);
        return vh;
    }

    @RequiresApi(api=16)
    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {
        if (position >= this.adapterItem.size()) {
            return;
        }
        MeiPaiPKInviteOrientRecyclerAdapterInfo item = this.adapterItem.get(position);
        holder.avatar.setTag(null);
        Glide.with((FragmentActivity)this.mContext).load(item.imageURL).apply((BaseRequestOptions)RequestOptions.placeholderOf((int)R.drawable.meipai_default_avatar_small)).into((ImageView)holder.avatar);
        holder.name.setText((CharSequence)(item.name + ""));
        if (item.sex == 1) {
            holder.sex.setImageDrawable(DrawableUtil.getDrawable((int)R.drawable.meipai_pk_invite_male_icon));
        } else if (item.sex == 0) {
            holder.sex.setImageDrawable(DrawableUtil.getDrawable((int)R.drawable.meipai_pk_invite_female_icon));
        }
        this.changeActionButton(item, holder.action);
        holder.action.setTag((Object)position);
        holder.avatar.setTag((Object)position);
        holder.name.setTag((Object)position);
    }

    public int getItemCount() {
        return this.adapterItem.size();
    }

    public int getItemViewType(int position) {
        return position;
    }

    public void onDestory() {
        this.mHandler.removeCallbacksAndMessages(null);
        this.compositeDisposable.dispose();
    }

    public void onInVitedStateChange() {
        this.mHandler.removeCallbacksAndMessages(null);
        this.notifyDataSetChanged();
    }

    private void countDownInviteTime(final @NonNull Button action, final int position, final MeiPaiPKInviteOrientRecyclerAdapterInfo item) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)MeiPaiPKInviteOrientRecyclerAdapter.TAG, (String)("item.countDown:" + item.countDown), (Object[])new Object[0]);
                if (item.countDown < -1) {
                    action.setEnabled(true);
                    item.userState = UserState.PK_START;
                    MeiPaiPKInviteOrientRecyclerAdapter.this.notifyItemChanged(position);
                    MeiPaiPKInviteOrientRecyclerAdapter.this.isActionStateStart = false;
                } else {
                    if (item.countDown >= 0) {
                        action.setText((CharSequence)("\u7b49\u5f85\u4e2d" + item.countDown + "S"));
                    }
                    MeiPaiPKInviteOrientRecyclerAdapter.this.mHandler.postDelayed((Runnable)this, 1000L);
                }
                --item.countDown;
            }
        };
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.postDelayed(runnable2, 0L);
    }

    private void changeActionButton(MeiPaiPKInviteOrientRecyclerAdapterInfo item, Button action) {
        switch (item.userState) {
            case PK_START: {
                ViewGroup.LayoutParams params = action.getLayoutParams();
                params.width = ScreenUtil.getInstance().dip2px(60);
                action.setLayoutParams(params);
                action.setEnabled(true);
                action.setText((CharSequence)"\u53d1\u8d77PK");
                action.setTextColor(Color.parseColor((String)"#FFFFFFFF"));
                action.setBackground(DrawableUtil.getDrawable((int)R.drawable.meipai_pk_invite_button_radius));
                break;
            }
            case PK_PLAYING: {
                ViewGroup.LayoutParams params = action.getLayoutParams();
                params.width = ScreenUtil.getInstance().dip2px(80);
                action.setLayoutParams(params);
                action.setEnabled(false);
                action.setText((CharSequence)"\u706b\u70edPK\u4e2d");
                action.setTextColor(Color.parseColor((String)"#59FFFFFF"));
                action.setBackground(DrawableUtil.getDrawable((int)R.drawable.meipai_pk_invite_button_radius_disable));
                break;
            }
            case PK_NO_INVITE: {
                ViewGroup.LayoutParams params = action.getLayoutParams();
                params.width = ScreenUtil.getInstance().dip2px(80);
                action.setLayoutParams(params);
                action.setEnabled(false);
                action.setText((CharSequence)"\u4e0d\u53ef\u9080\u8bf7");
                action.setTextColor(Color.parseColor((String)"#59FFFFFF"));
                action.setBackground(DrawableUtil.getDrawable((int)R.drawable.meipai_pk_invite_button_radius_disable));
                break;
            }
            case PK_COUNTDOEN: {
                ViewGroup.LayoutParams params = action.getLayoutParams();
                params.width = ScreenUtil.getInstance().dip2px(80);
                action.setLayoutParams(params);
                action.setEnabled(false);
                if (item.countDown == -10) {
                    action.setText((CharSequence)"\u7b49\u5f85\u54cd\u5e94\u4e2d");
                } else {
                    int countdown = item.countDown >= 0 ? item.countDown : 0;
                    action.setText((CharSequence)("\u7b49\u5f85\u4e2d" + countdown + "S"));
                }
                action.setTextColor(Color.parseColor((String)"#59FFFFFF"));
                action.setBackground(DrawableUtil.getDrawable((int)R.drawable.meipai_pk_invite_button_radius_disable));
                break;
            }
        }
    }

    public static class MyViewHolder
    extends RecyclerView.ViewHolder {
        public CircleCompatImageView avatar;
        public TextView name;
        public ImageView sex;
        public Button action;

        public MyViewHolder(View v) {
            super(v);
            this.avatar = (CircleCompatImageView)v.findViewById(R.id.meipai_pk_invate_oriented_portrait_imageView);
            this.name = (TextView)v.findViewById(R.id.meipai_pk_invate_oriented_name_textView);
            this.sex = (ImageView)v.findViewById(R.id.meipai_pk_invate_oriented_sex_imageView);
            this.action = (Button)v.findViewById(R.id.meipai_pk_invate_oriented_action_button);
        }
    }

    public static enum UserState {
        PK_START(0),
        PK_PLAYING(1),
        PK_NO_INVITE(2),
        PK_COUNTDOEN(3);

        private int state;

        private UserState(int state) {
            this.state = state;
        }

        public static UserState init(int state) {
            switch (state) {
                case 0: {
                    return PK_START;
                }
                case 1: {
                    return PK_PLAYING;
                }
                case 2: {
                    return PK_NO_INVITE;
                }
                case 3: {
                    return PK_COUNTDOEN;
                }
            }
            return PK_START;
        }

        public int state() {
            return this.state;
        }
    }
}

