/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.callback.VipAnimBannerCallback;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.unionyy.mobile.meipai.gift.animation.view.GuardComingLight;
import com.unionyy.mobile.meipai.gift.animation.view.LevelBadgeTextView;
import com.unionyy.mobile.meipai.gift.animation.view.LiveUserInLightAnimView;
import com.unionyy.mobile.meipai.gift.animation.view.MarqueueInTopPublicChatView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.unionvehicle.UnionVehicleConvertTipView;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class VipUserArrivedDisplay {
    private static final int LEVEL_DIVIDE = 26;
    public static final int LEVEL_MIN = 16;
    private ArrayList<VipUser> mUserList = new ArrayList();
    private ViewStub mVipUserArriveStub;
    private View mVipUserArriveGroup;
    private TextView mTvUserName;
    private LevelBadgeTextView mTvLevel;
    private LiveUserInLightAnimView mLightAnimView;
    private TextView mVipUserAction;
    private TextView mVipUserMountName;
    private View vipUserParentView;
    private AnimatorSet mArrivedAnimatorSet;
    private VipAnimBannerCallback mVipAnimBannerCallback;
    private GuardViewHolder guardViewHolder;
    private MarqueueInTopPublicChatView marqueueInTopPublicChatView;
    private UnionVehicleConvertTipView unionVehicleConvertTipView;
    private ViewGroup mVehicleToastViewRoot;
    AnimatorListenerAdapter mAnimatorEndListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
            VipUserArrivedDisplay.this.onAnimEnd();
        }
    };
    AnimatorListenerAdapter mGuardAnimatorListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
        }

        public void onAnimationStart(Animator animation) {
            super.onAnimationStart(animation);
            if (null != VipUserArrivedDisplay.this.guardViewHolder && VipUserArrivedDisplay.this.guardViewHolder.getLightCard() != null) {
                VipUserArrivedDisplay.this.guardViewHolder.getLightCard().startFlyLight(animation.getDuration(), VipUserArrivedDisplay.this.guardViewHolder.guardViewGroup.getWidth());
                Log.e((String)"VipUserArrivedDisplay", (String)(",groupWidth:" + VipUserArrivedDisplay.this.guardViewHolder.guardViewGroup.getWidth()));
            }
        }
    };
    public static final int GUARD_FOR_LOVE = 1;
    public static final int GUARD_FOR_EXPENSIVE = 2;

    public VipUserArrivedDisplay(ViewStub vipUserArriveStub, ViewGroup mVehicleToastViewRoot) {
        this.mVipUserArriveStub = vipUserArriveStub;
        this.mVehicleToastViewRoot = mVehicleToastViewRoot;
    }

    public void initView() {
        if (this.mVipUserArriveGroup == null) {
            MLog.info((Object)"VipUserArrivedDisplay", (String)"initView()", (Object[])new Object[0]);
            View view = this.mVipUserArriveStub.inflate();
            this.vipUserParentView = view.findViewById(R.id.vip_user_view_group);
            this.mVipUserArriveGroup = view.findViewById(R.id.rl_vip_user_arrived);
            this.mTvUserName = (TextView)this.mVipUserArriveGroup.findViewById(R.id.tv_vip_user_arrived);
            this.mTvLevel = (LevelBadgeTextView)this.mVipUserArriveGroup.findViewById(R.id.tv_level);
            this.mLightAnimView = (LiveUserInLightAnimView)this.mVipUserArriveGroup.findViewById(R.id.image_white_light);
            this.mVipUserAction = (TextView)this.mVipUserArriveGroup.findViewById(R.id.tv_vip_user_action);
            this.mVipUserMountName = (TextView)this.mVipUserArriveGroup.findViewById(R.id.tv_vip_user_mount_name);
            this.guardViewHolder = new GuardViewHolder(view);
            this.marqueueInTopPublicChatView = new MarqueueInTopPublicChatView((ViewGroup)view.findViewById(R.id.gift_egg_bc_parent));
            this.marqueueInTopPublicChatView.setEndCallBack((Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(){

                public Unit invoke(Boolean aBoolean) {
                    if (null != VipUserArrivedDisplay.this.mVipAnimBannerCallback) {
                        VipUserArrivedDisplay.this.mVipAnimBannerCallback.onBannerDismissed();
                        MLog.info((Object)"VipUserArrivedDisplay", (String)"mAnimatorEndListener:onBannerDismissed()", (Object[])new Object[0]);
                    }
                    return null;
                }
            });
            this.unionVehicleConvertTipView = new UnionVehicleConvertTipView(view.getContext());
            this.mVehicleToastViewRoot.addView(this.unionVehicleConvertTipView.getMToastView());
            this.unionVehicleConvertTipView.setEndCallBack((Function1)new Function1<Boolean, Unit>(){

                public Unit invoke(Boolean aBoolean) {
                    if (null != VipUserArrivedDisplay.this.mVipAnimBannerCallback) {
                        VipUserArrivedDisplay.this.mVipAnimBannerCallback.onBannerDismissed();
                        MLog.info((Object)"VipUserArrivedDisplay", (String)"mAnimatorEndListener:onBannerDismissed()", (Object[])new Object[0]);
                    }
                    return null;
                }
            });
        }
    }

    public void addUser(VipUser vipUser) {
        Log.e((String)"VipUserArrivedDisplay", (String)"invoke nextAnimator in addUser\uff1aone");
        this.nextAnimator(vipUser);
    }

    public void setCallback(VipAnimBannerCallback animBannerCallback) {
        this.mVipAnimBannerCallback = animBannerCallback;
    }

    private void nextAnimator(VipUser vipUser) {
        this.initView();
        if (vipUser.isGuard && null != this.guardViewHolder) {
            this.guardViewHolder.updateUserInfo(vipUser);
            this.startGuardAnimation();
        } else if (vipUser.isGiftEggBroadCast) {
            this.marqueueInTopPublicChatView.setInfo(vipUser.userName, vipUser.giftEggTaskName);
            this.marqueueInTopPublicChatView.startAnimation();
        } else if (vipUser.isConvertVehicle) {
            this.unionVehicleConvertTipView.setInfo(vipUser.userName, vipUser.mount_name);
            this.unionVehicleConvertTipView.startAnimation();
        } else {
            this.setUserInfo(vipUser);
            this.startArrivedAnimator(vipUser.level, vipUser.isMount);
        }
    }

    private void setUserInfo(VipUser user) {
        this.mTvUserName.setText((CharSequence)user.userName);
        this.mTvLevel.setLevel(user.level);
        if (user.level < 26) {
            this.mVipUserArriveGroup.setBackgroundResource(R.drawable.meipai_live_bg_vip_user_arrived_16);
        } else {
            this.mVipUserArriveGroup.setBackgroundResource(R.drawable.meipai_live_bg_vip_user_arrived);
        }
        if (user.isMount) {
            this.mVipUserAction.setText((CharSequence)user.action);
            this.mVipUserMountName.setText((CharSequence)user.mount_name);
            this.mVipUserAction.setVisibility(0);
            this.mVipUserMountName.setVisibility(0);
        } else {
            this.mVipUserAction.setVisibility(8);
            this.mVipUserMountName.setVisibility(8);
        }
    }

    private void startArrivedAnimator(int level, boolean isMount) {
        if (this.mArrivedAnimatorSet != null) {
            this.mArrivedAnimatorSet.cancel();
            this.mArrivedAnimatorSet = null;
        }
        this.mArrivedAnimatorSet = new AnimatorSet();
        int transX = DeviceUtils.getScreenWidth();
        if (this.mVipUserArriveGroup.getVisibility() != 0) {
            this.mVipUserArriveGroup.setVisibility(0);
        }
        if (this.vipUserParentView.getVisibility() != 0) {
            this.vipUserParentView.setVisibility(0);
        }
        Log.e((String)"VipUserArrivedDisplay", (String)("transX:" + transX));
        this.mLightAnimView.resetLightParams();
        this.mVipUserArriveGroup.setTranslationX((float)transX);
        if (level < 26) {
            ObjectAnimator transInAnimator = ObjectAnimator.ofFloat((Object)this.mVipUserArriveGroup, (String)"translationX", (float[])new float[]{transX, 0.0f});
            transInAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            transInAnimator.setDuration(1000L);
            ObjectAnimator dismissAnimator = ObjectAnimator.ofFloat((Object)this.mVipUserArriveGroup, (String)"alpha", (float[])new float[]{1.0f, 1.0f});
            dismissAnimator.setDuration(300L);
            dismissAnimator.setStartDelay(2700L);
            dismissAnimator.addListener((Animator.AnimatorListener)this.mAnimatorEndListener);
            this.mArrivedAnimatorSet.play((Animator)transInAnimator).before((Animator)dismissAnimator);
            this.mArrivedAnimatorSet.start();
        } else {
            ObjectAnimator transInAnimator = ObjectAnimator.ofFloat((Object)this.mVipUserArriveGroup, (String)"translationX", (float[])new float[]{transX, 0.0f});
            transInAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            transInAnimator.setDuration(1000L);
            transInAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                }

                public void onAnimationEnd(Animator animator) {
                    if (VipUserArrivedDisplay.this.mLightAnimView != null) {
                        VipUserArrivedDisplay.this.mLightAnimView.startLightAnimation();
                    }
                }

                public void onAnimationCancel(Animator animator) {
                }

                public void onAnimationRepeat(Animator animator) {
                }
            });
            ObjectAnimator dismissAnimator = ObjectAnimator.ofFloat((Object)this.mVipUserArriveGroup, (String)"alpha", (float[])new float[]{1.0f, 1.0f});
            dismissAnimator.setDuration(300L);
            dismissAnimator.setStartDelay(2700L);
            dismissAnimator.addListener((Animator.AnimatorListener)this.mAnimatorEndListener);
            this.mArrivedAnimatorSet.play((Animator)transInAnimator).before((Animator)dismissAnimator);
            this.mArrivedAnimatorSet.start();
        }
    }

    private void resetGuardAnim() {
        if (null != this.guardViewHolder) {
            this.guardViewHolder.getLightCard().setTranslationX(0.0f);
            this.guardViewHolder.getLightCard().setAlpha(1.0f);
            this.guardViewHolder.getLineLight().setScaleX(0.0f);
            this.guardViewHolder.getLineLight().setTranslationX(0.0f);
            this.guardViewHolder.getlStarImage().setScaleX(0.0f);
            this.guardViewHolder.getlStarImage().setScaleY(0.0f);
            this.guardViewHolder.getrStarImage().setScaleX(0.0f);
            this.guardViewHolder.getrStarImage().setScaleY(0.0f);
        }
    }

    private void startGuardAnimation() {
        ViewGroup guardViewGroup;
        if (this.mArrivedAnimatorSet != null) {
            this.mArrivedAnimatorSet.cancel();
            this.mArrivedAnimatorSet = null;
        }
        ViewGroup viewGroup = guardViewGroup = null != this.guardViewHolder ? this.guardViewHolder.getGuardViewGroup() : null;
        if (null == guardViewGroup) {
            return;
        }
        this.mArrivedAnimatorSet = new AnimatorSet();
        int transX = DeviceUtils.getScreenWidth();
        if (guardViewGroup.getVisibility() != 0) {
            guardViewGroup.setVisibility(0);
        }
        if (this.vipUserParentView.getVisibility() != 0) {
            this.vipUserParentView.setVisibility(0);
        }
        this.resetGuardAnim();
        guardViewGroup.setTranslationX((float)transX);
        ObjectAnimator transInAnimator = ObjectAnimator.ofFloat((Object)guardViewGroup, (String)"translationX", (float[])new float[]{transX, 0.0f});
        transInAnimator.setInterpolator((TimeInterpolator)new AnticipateOvershootInterpolator(0.8f));
        transInAnimator.setDuration(360L);
        GuardComingLight lightView = this.guardViewHolder.getLightCard();
        ImageView starl = this.guardViewHolder.getlStarImage();
        ImageView starr = this.guardViewHolder.getrStarImage();
        ImageView lightLine = this.guardViewHolder.getLineLight();
        int moveS = DeviceUtils.dip2px(20.0f);
        int moveE = this.guardViewHolder.getGroupWidth() - DeviceUtils.dip2px(100.0f);
        ObjectAnimator scaleStarl = ObjectAnimator.ofFloat((Object)starl, (String)"scaleX", (float[])new float[]{1.1f, 0.9f, 1.1f});
        scaleStarl.setDuration(1000L);
        scaleStarl.setRepeatCount(23);
        scaleStarl.setRepeatMode(1);
        ObjectAnimator scaleStarly = ObjectAnimator.ofFloat((Object)starl, (String)"scaleY", (float[])new float[]{1.1f, 0.9f, 1.1f});
        scaleStarly.setDuration(1000L);
        scaleStarly.setRepeatCount(23);
        scaleStarly.setRepeatMode(1);
        ObjectAnimator scaleStarr = ObjectAnimator.ofFloat((Object)starr, (String)"scaleX", (float[])new float[]{1.1f, 0.9f, 1.1f});
        scaleStarr.setDuration(1000L);
        scaleStarr.setRepeatCount(23);
        scaleStarr.setRepeatMode(1);
        ObjectAnimator scaleStarrY = ObjectAnimator.ofFloat((Object)starr, (String)"scaleY", (float[])new float[]{1.1f, 0.9f, 1.1f});
        scaleStarrY.setDuration(1000L);
        scaleStarrY.setRepeatCount(23);
        scaleStarrY.setRepeatMode(1);
        Log.e((String)"VipUserArrivedDisplay", (String)("moveE:" + moveE + ",groupWidth:" + guardViewGroup.getWidth() + ",getWidth\uff1a" + this.guardViewHolder.getGroupWidth()));
        lightLine.setTranslationX((float)moveS);
        ObjectAnimator light = ObjectAnimator.ofFloat((Object)lightLine, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
        light.setStartDelay(120L);
        light.setDuration(520L);
        ObjectAnimator lighty = ObjectAnimator.ofFloat((Object)lightLine, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
        lighty.setStartDelay(120L);
        lighty.setDuration(520L);
        ObjectAnimator light_move1 = ObjectAnimator.ofFloat((Object)lightLine, (String)"translationX", (float[])new float[]{moveS, moveE});
        light_move1.setDuration(520L);
        light_move1.addListener((Animator.AnimatorListener)this.mGuardAnimatorListener);
        ObjectAnimator light_move2 = ObjectAnimator.ofFloat((Object)lightLine, (String)"translationX", (float[])new float[]{moveE, moveS});
        light_move2.setDuration(480L);
        light_move2.setStartDelay(480L);
        ObjectAnimator light_sx = ObjectAnimator.ofFloat((Object)lightLine, (String)"scaleX", (float[])new float[]{1.0f, 0.0f});
        light.setDuration(520L);
        ObjectAnimator light_sy = ObjectAnimator.ofFloat((Object)lightLine, (String)"scaleY", (float[])new float[]{1.0f, 0.0f});
        lighty.setDuration(520L);
        ObjectAnimator transLightAnimator = ObjectAnimator.ofFloat((Object)((Object)lightView), (String)"alpha", (float[])new float[]{1.0f, 0.5f});
        transLightAnimator.setDuration(560L);
        transLightAnimator.setStartDelay(760L);
        transLightAnimator.addListener((Animator.AnimatorListener)this.mGuardAnimatorListener);
        ObjectAnimator transLightAnimator2 = ObjectAnimator.ofFloat((Object)((Object)lightView), (String)"alpha", (float[])new float[]{1.0f, 0.5f});
        transLightAnimator2.setDuration(380L);
        transLightAnimator2.setStartDelay(640L);
        transLightAnimator2.addListener((Animator.AnimatorListener)this.mGuardAnimatorListener);
        ObjectAnimator dismissAnimator = ObjectAnimator.ofFloat((Object)guardViewGroup, (String)"alpha", (float[])new float[]{1.0f, 1.0f});
        dismissAnimator.setDuration(300L);
        dismissAnimator.setStartDelay(3340L);
        dismissAnimator.addListener((Animator.AnimatorListener)this.mAnimatorEndListener);
        this.mArrivedAnimatorSet.play((Animator)transInAnimator).before((Animator)scaleStarl);
        this.mArrivedAnimatorSet.play((Animator)scaleStarl).with((Animator)scaleStarly).with((Animator)scaleStarr).with((Animator)scaleStarrY).with((Animator)light).with((Animator)lighty);
        this.mArrivedAnimatorSet.play((Animator)scaleStarr).with((Animator)dismissAnimator).with((Animator)transLightAnimator);
        this.mArrivedAnimatorSet.play((Animator)transLightAnimator2).after((Animator)transLightAnimator);
        this.mArrivedAnimatorSet.play((Animator)light_move1).after((Animator)light);
        this.mArrivedAnimatorSet.play((Animator)light_move2).after((Animator)light_move1);
        this.mArrivedAnimatorSet.play((Animator)light_sx).with((Animator)light_sy).after((Animator)light_move2);
        this.mArrivedAnimatorSet.start();
    }

    private void onAnimEnd() {
        Log.e((String)"VipUserArrivedDisplay", (String)"onAnimationEnd.");
        this.mArrivedAnimatorSet.cancel();
        this.mArrivedAnimatorSet = null;
        this.mVipUserArriveGroup.setAlpha(1.0f);
        this.mVipUserArriveGroup.setTranslationX(0.0f);
        this.mVipUserArriveGroup.setVisibility(8);
        if (null != this.guardViewHolder && null != this.guardViewHolder.getGuardViewGroup()) {
            this.guardViewHolder.getGuardViewGroup().setVisibility(8);
            this.guardViewHolder.getGuardViewGroup().setTranslationX(0.0f);
        }
        if (null != this.mVipAnimBannerCallback) {
            this.mVipAnimBannerCallback.onBannerDismissed();
            Log.e((String)"VipUserArrivedDisplay", (String)"mAnimatorEndListener:onBannerDismissed()");
        }
    }

    public void clear() {
        this.mUserList.clear();
        if (this.mArrivedAnimatorSet != null) {
            this.mArrivedAnimatorSet.cancel();
            this.mArrivedAnimatorSet = null;
        }
        this.visibleChange(false);
        if (null != this.mVipUserArriveGroup) {
            this.mVipUserArriveGroup.setTranslationX(0.0f);
        }
        if (this.marqueueInTopPublicChatView != null) {
            this.marqueueInTopPublicChatView.clear();
        }
        if (this.unionVehicleConvertTipView != null) {
            this.unionVehicleConvertTipView.clear();
        }
        if (null != this.guardViewHolder) {
            this.guardViewHolder.getGuardViewGroup().setTranslationX(0.0f);
        }
    }

    public void visibleChange(boolean isShow) {
        if (null != this.vipUserParentView) {
            this.vipUserParentView.setVisibility(isShow ? 0 : 8);
        }
        if (this.mArrivedAnimatorSet != null) {
            this.mArrivedAnimatorSet.cancel();
            this.mArrivedAnimatorSet = null;
        }
    }

    public static class GuardViewHolder {
        private RelativeLayout guardViewGroup;
        private ImageView guardIcon;
        private ImageView lineLight;
        private ImageView lStarImage;
        private ImageView rStarImage;
        private TextView nickTv;
        private TextView mountAcTv;
        private TextView mountNameTv;
        private GuardComingLight lightCard;
        private String text = "";

        public GuardViewHolder(View rootView) {
            if (null == rootView) {
                return;
            }
            this.guardViewGroup = (RelativeLayout)rootView.findViewById(R.id.live_guard_user_arrive);
            this.guardIcon = (ImageView)rootView.findViewById(R.id.guard_icon);
            this.lineLight = (ImageView)rootView.findViewById(R.id.live_line_light);
            this.lStarImage = (ImageView)rootView.findViewById(R.id.l_star);
            this.rStarImage = (ImageView)rootView.findViewById(R.id.r_star);
            this.nickTv = (TextView)rootView.findViewById(R.id.tv_vip_user_arrived_g);
            this.mountAcTv = (TextView)rootView.findViewById(R.id.tv_vip_user_action_g);
            this.mountNameTv = (TextView)rootView.findViewById(R.id.tv_vip_user_mount_name_g);
            this.lightCard = (GuardComingLight)rootView.findViewById(R.id.guard_light_card);
            int hight = DeviceUtils.getScreenHeight(BasicConfig.getInstance().getAppContext());
            if (hight < 1000) {
                this.nickTv.setMaxWidth(DeviceUtils.dip2px(115.0f));
            } else {
                this.nickTv.setMaxWidth(DeviceUtils.dip2px(150.0f));
            }
        }

        public void updateUserInfo(VipUser user) {
            if (null == user) {
                return;
            }
            switch (user.guardId) {
                case 1: {
                    this.guardIcon.setImageResource(R.drawable.meipai_live_guard1);
                    break;
                }
                case 2: {
                    this.guardIcon.setImageResource(R.drawable.meipai_live_guard2);
                    break;
                }
                default: {
                    this.guardIcon.setVisibility(8);
                }
            }
            this.nickTv.setText((CharSequence)user.userName);
            if (user.isMount) {
                this.mountAcTv.setText((CharSequence)user.action);
                this.mountNameTv.setText((CharSequence)user.mount_name);
                this.mountAcTv.setVisibility(0);
                this.mountNameTv.setVisibility(0);
                this.text = user.userName + user.action + user.mount_name;
            } else {
                this.mountAcTv.setVisibility(8);
                this.mountNameTv.setVisibility(8);
                this.text = user.userName;
            }
            this.text = this.text + this.guardIcon.getResources().getString(R.string.meipai_live_user_enter);
        }

        public ViewGroup getGuardViewGroup() {
            return this.guardViewGroup;
        }

        public ImageView getLineLight() {
            return this.lineLight;
        }

        public ImageView getlStarImage() {
            return this.lStarImage;
        }

        public ImageView getrStarImage() {
            return this.rStarImage;
        }

        public GuardComingLight getLightCard() {
            return this.lightCard;
        }

        public int getGroupWidth() {
            if (!TextUtils.isEmpty((CharSequence)this.text)) {
                float tv_width = StaticLayout.getDesiredWidth((CharSequence)this.text, (TextPaint)this.nickTv.getPaint());
                Log.e((String)"VipUserArrivedDisplay", (String)("text:" + this.text + ",tvwidth:" + tv_width));
                int w = (int)tv_width + DeviceUtils.dip2px(65.0f);
                return w > 460 ? w : 460;
            }
            return DeviceUtils.dip2px(100.0f);
        }
    }

    public static class VipUser {
        int level;
        boolean isMount;
        String userName;
        String action;
        String mount_name;
        int guardId;
        boolean isGuard;
        public boolean isGiftEggBroadCast = false;
        public String giftEggTaskName = "";
        public boolean isConvertVehicle = false;

        public VipUser(int level, String userName, String action, String mount_name, boolean isMount, int guardId, boolean isGuard) {
            this.level = level;
            this.userName = userName;
            this.action = action;
            this.mount_name = mount_name;
            this.isMount = isMount;
            this.guardId = guardId;
            this.isGuard = isGuard;
        }
    }
}

