/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.unionyy.mobile.meipai.gift.animation.decoder.sub.LiveCarAnimateDecoder;
import com.unionyy.mobile.meipai.gift.controller.GiftAnimateController;

public class GiftAnimationLayout
extends FrameLayout {
    private int mWidth;
    private int mHeight;
    private GiftAnimateController mGiftAnimateController;
    private LiveCarAnimateDecoder mMountCarDecoder;
    private Point displaySize;
    private int width = 0;
    private int height = 0;
    private int mWidthMeasureSpec;
    private Rect rect = new Rect();
    private Context context;

    public void setGiftAnimateController(GiftAnimateController controller) {
        this.mGiftAnimateController = controller;
        if (this.mWidth > 0 && this.mHeight > 0) {
            this.mGiftAnimateController.onDisplaySizeChanged(this.mWidth, this.mHeight);
        }
    }

    public void setMountCarDecoder(LiveCarAnimateDecoder mountCarDecoder) {
        this.mMountCarDecoder = mountCarDecoder;
        if (this.mWidth > 0 && this.mHeight > 0) {
            this.mMountCarDecoder.onDisplaySizeChanged(this.mWidth, this.mHeight);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        if (this.mGiftAnimateController != null) {
            this.mGiftAnimateController.onDisplaySizeChanged(w, h);
        }
        if (this.mMountCarDecoder != null) {
            this.mMountCarDecoder.onDisplaySizeChanged(w, h);
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        if (this.mGiftAnimateController != null) {
            this.mGiftAnimateController.onConfigurationChanged(newConfig.orientation);
        }
        this.width = 0;
        this.height = 0;
        this.displaySize = this.getDisplaySize(this.context);
        if (this.mMountCarDecoder != null) {
            this.mMountCarDecoder.onConfigurationChanged(newConfig.orientation);
        }
        super.onConfigurationChanged(newConfig);
    }

    public GiftAnimationLayout(Context context) {
        super(context);
        this.context = context;
        this.displaySize = this.getDisplaySize(context);
    }

    private Point getDisplaySize(Context context) {
        Point var1 = new Point();
        WindowManager var2 = (WindowManager)context.getSystemService("window");
        Display var3 = var2.getDefaultDisplay();
        var3.getSize(var1);
        return var1;
    }

    public GiftAnimationLayout(Context context, AttributeSet attr) {
        super(context, attr);
        this.context = context;
        this.displaySize = this.getDisplaySize(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int var5;
        int var14;
        this.getWindowVisibleDisplayFrame(this.rect);
        if (this.width == 0 && this.height == 0) {
            this.width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            this.height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        }
        if ((var14 = this.displaySize.x > this.displaySize.y ? (this.width > this.height ? this.height : this.width) : (this.width < this.height ? this.height : this.width)) - (var5 = this.rect.bottom - this.rect.top) > var14 / 4) {
            super.onMeasure(this.mWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)var14, (int)0x40000000));
        } else {
            this.mWidthMeasureSpec = widthMeasureSpec;
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

