/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.utils.plist;

import com.unionyy.mobile.meipai.gift.animation.utils.plist.Array;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.PListInteger;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.PListObject;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.PListObjectType;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.PListString;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class Dict
extends PListObject {
    private static final long serialVersionUID = -556589348083152733L;
    public static final String DOT = ".";
    protected Map<String, PListObject> configMap = new TreeMap<String, PListObject>();

    public Dict() {
        this.setType(PListObjectType.DICT);
    }

    public void putConfig(String key, PListObject value) {
        this.configMap.put(key, value);
    }

    public Map<String, PListObject> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<String, PListObject> configMap) {
        this.configMap = configMap;
    }

    public <E extends PListObject> E getConfigurationObject(String key) {
        StringTokenizer st = new StringTokenizer(key, DOT);
        if (st.hasMoreTokens()) {
            Map<String, PListObject> dict = this.configMap;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                PListObject obj = dict.get(token);
                if (obj instanceof Dict) {
                    dict = ((Dict)obj).getConfigMap();
                    continue;
                }
                return (E)obj;
            }
        }
        return (E)this.configMap.get(key);
    }

    public PListString getConfiguration(String key) {
        return (PListString)this.getConfigurationObject(key);
    }

    public PListString getConfigurationWithDefault(String key, PListString defaultValue) {
        PListString value = this.getConfiguration(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public PListInteger getConfigurationInteger(String key) {
        return (PListInteger)this.getConfigurationObject(key);
    }

    public PListInteger getConfigurationIntegerWithDefault(String key, PListInteger defaultValue) {
        PListInteger value = this.getConfigurationInteger(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Array getConfigurationArray(String key) {
        return (Array)this.getConfigurationObject(key);
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        Set<String> keys = this.configMap.keySet();
        for (String key : keys) {
            retVal.append("key=").append(key).append(this.configMap.get(key).toString());
        }
        return retVal.toString();
    }
}

