/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.utils;

import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;

public class FileUtils {
    public static boolean isFileExist(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        if (FileUtils.isExternalStorageReadable()) {
            return new File(filePath).exists();
        }
        return false;
    }

    public static boolean judgeFileIsNull(String folderPath) {
        try {
            File folder = new File(folderPath);
            if (folder.isDirectory()) {
                File[] files2 = folder.listFiles();
                return files2.length == 0;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        return state.equals("mounted") || state.equals("mounted_ro");
    }

    public static File createNewFile(String path) {
        if (!FileUtils.isExternalStorageWritable(0)) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)path)) {
            File file = new File(path);
            if (file.exists()) {
                return file;
            }
            if (file.isDirectory()) {
                file.mkdirs();
                return file;
            }
            String parentPath = FileUtils.getParentPath(path);
            File parentFolder = new File(parentPath);
            if (parentFolder.exists()) {
                try {
                    file.createNewFile();
                    return file;
                }
                catch (IOException iOException) {}
            } else if (new File(parentPath).mkdirs()) {
                try {
                    file.createNewFile();
                    return file;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static boolean isExternalStorageWritable(int availableSpace) {
        if (availableSpace > 0 && FileUtils.getAvailableSpace() < (long)availableSpace) {
            return false;
        }
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static long getAvailableSpace() {
        long spaceSize = -1L;
        String state = Environment.getExternalStorageState();
        if ("checking".equals(state)) {
            return spaceSize;
        }
        if (!"mounted".equals(state)) {
            return spaceSize;
        }
        try {
            File sdcardDirFile = Environment.getExternalStorageDirectory();
            StatFs sf = new StatFs(sdcardDirFile.getPath());
            long blockSize = sf.getBlockSize();
            long blockCount = sf.getBlockCount();
            long availCount = sf.getAvailableBlocks();
            spaceSize = availCount * blockSize / 1024L;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return spaceSize;
    }

    public static String getParentPath(String path) {
        String rootPath = Environment.getExternalStorageDirectory().getPath() + "/";
        if (TextUtils.isEmpty((CharSequence)path)) {
            return rootPath;
        }
        File file = new File(path);
        String tempPath = file.getParent();
        if (TextUtils.isEmpty((CharSequence)tempPath)) {
            return rootPath;
        }
        String parentPath = tempPath + "/";
        if (!FileUtils.isFileExist(parentPath)) {
            FileUtils.createDir(parentPath);
        }
        file = new File(parentPath);
        try {
            if (file == null || !file.exists() || file.getPath().equals("") || file.getPath().equals("/")) {
                return rootPath;
            }
            return parentPath;
        }
        catch (Exception e) {
            return rootPath;
        }
    }

    public static File createDir(String filePath) {
        if (!FileUtils.isExternalStorageWritable(0)) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static boolean isImageFile(String filePath) {
        if (filePath == null || filePath.equalsIgnoreCase("") || filePath.lastIndexOf("/") < 0 || filePath.length() < 4) {
            return false;
        }
        if (!filePath.equals("")) {
            int index = filePath.lastIndexOf(".");
            if (index == -1) {
                return false;
            }
            String extName = filePath.substring(index + 1, filePath.length()).toLowerCase();
            if (extName.equals("bmp") || extName.equals("jpg") || extName.equals("jpeg") || extName.equals("peg") || extName.equals("png") || extName.equals("gif") || extName.equals("wbmp") || extName.equals("webp")) {
                File file = new File(filePath);
                return file.exists();
            }
            return false;
        }
        return false;
    }
}

