/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.decoder;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.ViewGroup;
import com.google.gson.Gson;
import com.unionyy.mobile.meipai.gift.animation.decoder.AnimationDecoder;
import com.unionyy.mobile.meipai.gift.animation.decoder.INGiftAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftImageGLTarget;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftImageTarget;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftLedGLTarget;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftLedTarget;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import com.unionyy.mobile.meipai.gift.animation.model.GiftMessage;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import com.unionyy.mobile.meipai.gift.animation.utils.AnimateResourceLoader;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.unionyy.mobile.meipai.gift.animation.utils.GiftTargetRecyclePool;
import com.unionyy.mobile.meipai.gift.animation.utils.SerializeUtils;
import com.unionyy.mobile.meipai.gift.animation.view.GlAnimationView;
import com.unionyy.mobile.meipai.gift.core.config.CallBackMessage;
import com.unionyy.mobile.meipai.gift.core.config.Middleware2MPGiftMgr;
import com.unionyy.mobile.meipai.gift.dispatcher.GiftMessageDispatcher;
import com.unionyy.mobile.meipai.gift.event.EventShowGiftAnmi;
import com.yy.mobile.RxBus;
import com.yy.mobile.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public abstract class AbstractAnimateDecoder
extends AnimationDecoder<GlAnimationView>
implements INGiftAnimateDecoder {
    public static final int GIFT_TYPE_VIDEO = -10;
    public static final int GIFT_TYPE_EGG = -11;
    public static final int GIFT_TYPE_SMALL = 0;
    public static final int GIFT_TYPE_LARGE = 1;
    public static final int GIFT_TYPE_AR = 2;
    public static final String GIFT_RULE = "rule.json";
    public static final String GIFT_RULE_PRE = "rule_pre.json";
    protected static final int BASE_WIDTH = 750;
    private static final String TAG = "AbstractAnimateDecoder";
    protected Context mContext;
    protected ViewGroup mGiftViewGroup;
    protected boolean mIsSupportEGL = false;
    protected float mScreenScale;
    protected int mWidth;
    protected int mHeight;
    protected float marginTop;
    protected float marginBottom;
    protected GiftTarget.OnUserInfoClickListener mOnUserInfoClickListener;
    protected boolean mIsPause = false;
    protected int mOrientation = 1;

    public AbstractAnimateDecoder() {
    }

    public AbstractAnimateDecoder(Context context, ViewGroup viewGroup) {
        this.mContext = context;
        this.mGiftViewGroup = viewGroup;
    }

    public AbstractAnimateDecoder(Context context, ViewGroup viewGroup, boolean isSupportEGL) {
        this.mContext = context;
        this.mIsSupportEGL = isSupportEGL;
        this.mGiftViewGroup = viewGroup;
    }

    @Override
    public boolean checkGiftMessageFitDecoder(GiftMessage giftMessage) {
        return giftMessage != null && giftMessage.getGift_type() == this.desireGiftMessageType();
    }

    @Override
    public boolean checkGiftMessageFitDecoder(ArrayList<GiftMessage> giftMessageList) {
        return giftMessageList != null && !giftMessageList.isEmpty() && giftMessageList.get(0).getGift_type() == this.desireGiftMessageType();
    }

    @Override
    public boolean dispatchGiftMessage(GiftMessage giftMessage) {
        if (this.checkGiftMessageFitDecoder(giftMessage)) {
            return this.dealWithGiftMessage(giftMessage);
        }
        return false;
    }

    @Override
    public boolean dispatchGiftMessage(ArrayList<GiftMessage> giftMessageList) {
        if (this.checkGiftMessageFitDecoder(giftMessageList)) {
            return this.dealWithGiftMessage(giftMessageList);
        }
        return false;
    }

    @Override
    public boolean dealWithGiftMessage(ArrayList<GiftMessage> giftMessages) {
        return false;
    }

    @Override
    public GiftTarget loadGiftImageTarget(GiftMessage giftMessage) {
        String giftId = giftMessage.getGiftId();
        String path = giftMessage.getGiftLocalPath();
        GiftRule rule = this.loadGiftRule(giftId, path, GIFT_RULE, giftMessage);
        return this.loadGiftImageTarget(giftMessage, rule);
    }

    @Override
    public GiftTarget loadGiftImageTarget(GiftMessage giftMessage, GiftRule rule) {
        if (rule == null) {
            return null;
        }
        String path = giftMessage.getGiftLocalPath();
        String imagePath = path + "/" + rule.image;
        if (!this.isImageExits(rule, imagePath, giftMessage)) {
            return null;
        }
        return this.getGiftTarget(rule, giftMessage, imagePath);
    }

    @Override
    public GiftRule loadGiftRule(String giftId, String path, String ruleFileName, GiftMessage giftMessage) {
        return AbstractAnimateDecoder.commonLoadGiftRule(giftId, path, ruleFileName, giftMessage);
    }

    @Override
    public void addGiftTargetToGroup(GiftTarget target) {
    }

    @Override
    public void addGiftTargetToGroup(ArrayList<GiftTarget> target) {
    }

    @Override
    public void setPause(boolean isPause) {
        this.mIsPause = isPause;
    }

    @Override
    public void setBottomMargin(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    @Override
    public void onDisplaySizeChanged(int w, int h) {
        this.mWidth = w;
        this.mHeight = h;
        if (this.mOrientation == 1) {
            this.mScreenScale = (float)this.mWidth / 750.0f;
        } else {
            float newReferWidth = (float)this.mHeight * 0.56f;
            this.mScreenScale = newReferWidth / 750.0f;
        }
    }

    @Override
    public void onConfigurationChanged(int orientation) {
        this.mOrientation = orientation;
    }

    @Override
    public void release() {
        this.clear();
        this.mGiftViewGroup = null;
        this.mContext = null;
    }

    @Override
    public GiftMessageDispatcher.GiftDispatchMessage checkGiftNeedWatitForDispatch(GiftMessage giftMessage) {
        return null;
    }

    @Override
    public void doSomeWithGiftTargetByDispatcher(GiftTarget target, GiftMessageDispatcher.DispatcherAttachMessage message) {
    }

    protected abstract float getGiftViewHeight();

    protected void recycleGiftTarget(GiftTarget target) {
        if (target != null) {
            int type2 = target.getType();
            target.setGiftImageDismissListener(null);
            target.remove();
            if (type2 >= 0) {
                GiftTargetRecyclePool.getInstance().putRecycledView(target, type2);
            }
        }
    }

    protected boolean isImageExits(GiftRule rule, String imagePath, GiftMessage gift) {
        if (rule.type == 3) {
            imagePath = String.format(GiftTarget.getMultiImagePathFormat(rule, gift.getGiftLocalPath()), 1);
        }
        if (!new File(imagePath).exists()) {
            if (gift.getGiftId().contains("cg_")) {
                Middleware2MPGiftMgr.Companion.getInstances().downloadColorEggResZip(gift.getGiftName(), gift.getLevel(), gift, (Function1<? super CallBackMessage, Unit>)new Function1<CallBackMessage, Unit>(){

                    public Unit invoke(CallBackMessage callBackMessage) {
                        if (callBackMessage.getBoolean()) {
                            EventShowGiftAnmi event = new EventShowGiftAnmi(callBackMessage.getMessage());
                            RxBus.getDefault().post((Object)event);
                        }
                        return null;
                    }
                });
            } else {
                Middleware2MPGiftMgr.Companion.getInstances().loadMaterialFailed(StringUtils.safeParseInt((String)gift.getGiftId()), gift);
            }
            return false;
        }
        return true;
    }

    protected GiftTarget getGiftTarget(GiftRule rule, GiftMessage message, String imagePath) {
        GiftTarget target = GiftTargetRecyclePool.getInstance().getRecycledView(rule.type);
        int[] size = null;
        if (rule.type == 3 || rule.type == 4) {
            if (rule.image_size != null) {
                size = new int[]{(int)rule.image_size[0], (int)rule.image_size[1]};
            }
        } else {
            size = this.getImageBitmapSize(imagePath);
        }
        if (size == null) {
            if (message.getGiftId().contains("cg_")) {
                Middleware2MPGiftMgr.Companion.getInstances().downloadColorEggResZip(message.getGiftName(), message.getLevel(), message, (Function1<? super CallBackMessage, Unit>)new Function1<CallBackMessage, Unit>(){

                    public Unit invoke(CallBackMessage callBackMessage) {
                        if (callBackMessage.getBoolean()) {
                            EventShowGiftAnmi event = new EventShowGiftAnmi(callBackMessage.getMessage());
                            RxBus.getDefault().post((Object)event);
                        }
                        return null;
                    }
                });
            } else {
                Middleware2MPGiftMgr.Companion.getInstances().loadMaterialFailed(StringUtils.safeParseInt((String)message.getGiftId()), message);
            }
            return null;
        }
        int messageUsageFactor = 1;
        int imageWidth = size[0];
        int imageHeight = size[1];
        if (rule.type == 2) {
            if (target == null) {
                target = this.mIsSupportEGL ? new GiftImageGLTarget() : new GiftImageTarget();
            }
            if (rule.h_frames != 0 && rule.v_frames != 0) {
                imageWidth = size[0] / rule.h_frames;
                imageHeight = size[1] / rule.v_frames;
            }
        } else if (rule.type == 0) {
            if (target == null) {
                target = this.mIsSupportEGL ? new GiftImageGLTarget() : new GiftImageTarget();
            }
        } else if (rule.type == 1) {
            target = this.getLedTarget(target, message, rule, size);
        } else if (rule.type == 3 || rule.type == 4) {
            if (target == null) {
                target = new GiftImageTarget();
            }
            messageUsageFactor = 6;
        }
        if (target != null) {
            target.initResetParams();
            target.setGiftMessage(message);
            target.setGiftRule(rule);
            target.init(this.mWidth, this.getGiftViewHeight(), imageWidth, imageHeight, this.mScreenScale);
            target.setMemoryUsage((long)size[0] * (long)size[1] * (long)messageUsageFactor);
            target.setOnUserInfoClickListener(this.mOnUserInfoClickListener);
        }
        return target;
    }

    private GiftTarget getLedTarget(GiftTarget target, GiftMessage message, GiftRule rule, int[] size) {
        String ledSuffixPath;
        if (target == null) {
            target = this.mIsSupportEGL ? new GiftLedGLTarget() : new GiftLedTarget();
        }
        if (!new File(ledSuffixPath = Middleware2MPGiftMgr.Companion.getInstances().getPreEffectPath(StringUtils.safeParseLong((String)message.getGiftId())) + "/" + rule.inside_image).exists()) {
            if (message.getGiftId().contains("cg_")) {
                Middleware2MPGiftMgr.Companion.getInstances().downloadColorEggResZip(message.getGiftName(), message.getLevel(), message, (Function1<? super CallBackMessage, Unit>)new Function1<CallBackMessage, Unit>(){

                    public Unit invoke(CallBackMessage callBackMessage) {
                        if (callBackMessage.getBoolean()) {
                            EventShowGiftAnmi event = new EventShowGiftAnmi(callBackMessage.getMessage());
                            RxBus.getDefault().post((Object)event);
                        }
                        return null;
                    }
                });
            } else {
                Middleware2MPGiftMgr.Companion.getInstances().loadMaterialFailed(StringUtils.safeParseInt((String)message.getGiftId()), message);
            }
            return null;
        }
        Bitmap ledSuffix = AnimateResourceLoader.getInstance().synLoadSdCardImage(ledSuffixPath);
        if (ledSuffix == null || ledSuffix.isRecycled()) {
            if (message.getGiftId().contains("cg_")) {
                Middleware2MPGiftMgr.Companion.getInstances().downloadColorEggResZip(message.getGiftName(), message.getLevel(), message, (Function1<? super CallBackMessage, Unit>)new Function1<CallBackMessage, Unit>(){

                    public Unit invoke(CallBackMessage callBackMessage) {
                        if (callBackMessage.getBoolean()) {
                            EventShowGiftAnmi event = new EventShowGiftAnmi(callBackMessage.getMessage());
                            RxBus.getDefault().post((Object)event);
                        }
                        return null;
                    }
                });
            } else {
                Middleware2MPGiftMgr.Companion.getInstances().loadMaterialFailed(StringUtils.safeParseInt((String)message.getGiftId()), message);
            }
            return null;
        }
        if (target instanceof GiftLedTarget) {
            ((GiftLedTarget)target).loadLedTextBitmap(size[0], size[1], this.mScreenScale, message, rule, ledSuffix);
        } else {
            ((GiftLedGLTarget)target).loadLedTextBitmap(size[0], size[1], this.mScreenScale, message, rule, ledSuffix);
        }
        return target;
    }

    private int[] getImageBitmapSize(String path) {
        int[] size;
        if (this.mIsSupportEGL) {
            size = AnimateResourceLoader.getInstance().decodeBitmapSize(path);
        } else {
            Bitmap bitmap = AnimateResourceLoader.getInstance().synLoadSdCardImage(path);
            if (bitmap == null) {
                return null;
            }
            size = new int[]{bitmap.getWidth(), bitmap.getHeight()};
        }
        return size;
    }

    public void setOnUserInfoClickListener(GiftTarget.OnUserInfoClickListener onUserInfoClickListener) {
        this.mOnUserInfoClickListener = onUserInfoClickListener;
    }

    public static GiftRule baseLoadGiftRule(String giftId, String path, String ruleFileName, GiftMessage message) {
        File jsonFile = new File(path + "/" + ruleFileName);
        if (!jsonFile.exists()) {
            if (message != null && message.getGiftId() != null && message.getGiftId().contains("cg_")) {
                Middleware2MPGiftMgr.Companion.getInstances().downloadColorEggResZip(message.getGiftName(), message.getLevel(), message, (Function1<? super CallBackMessage, Unit>)new Function1<CallBackMessage, Unit>(){

                    public Unit invoke(CallBackMessage callBackMessage) {
                        if (callBackMessage.getBoolean()) {
                            EventShowGiftAnmi event = new EventShowGiftAnmi(callBackMessage.getMessage());
                            RxBus.getDefault().post((Object)event);
                        }
                        return null;
                    }
                });
            } else {
                Middleware2MPGiftMgr.Companion.getInstances().loadMaterialFailed(StringUtils.safeParseInt((String)giftId), message);
            }
            return null;
        }
        GiftRule rule = (GiftRule)SerializeUtils.getClassFromFile(GiftRule.class, jsonFile.getAbsolutePath(), new Gson());
        return rule;
    }

    public static GiftRule commonLoadGiftRule(String giftId, String path, String ruleFileName, GiftMessage message) {
        GiftRule rule = AbstractAnimateDecoder.baseLoadGiftRule(giftId, path, ruleFileName, message);
        return rule;
    }

    protected int getGiftShowReginHeight(int orientation) {
        if (orientation == 1) {
            return DeviceUtils.getScreenHeight();
        }
        return DeviceUtils.getScreenWidth();
    }
}

