/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation;

import android.animation.Animator;
import android.animation.PropertyValuesHolder;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.view.animation.AnimationUtils;
import java.util.ArrayList;

public class FrameAnimator
extends ValueAnimator {
    private long mStartTime = -1L;
    private long mCurrentPlayTime;
    private boolean isAnimationEnd = false;
    private int mCurrentIteration;

    public static FrameAnimator ofInt(int ... values) {
        FrameAnimator anim = new FrameAnimator();
        anim.setIntValues(values);
        return anim;
    }

    public static FrameAnimator ofFloat(float ... values) {
        FrameAnimator anim = new FrameAnimator();
        anim.setFloatValues(values);
        return anim;
    }

    public static FrameAnimator ofPropertyValuesHolder(PropertyValuesHolder ... values) {
        FrameAnimator anim = new FrameAnimator();
        anim.setValues(values);
        return anim;
    }

    public static FrameAnimator ofObject(TypeEvaluator evaluator, Object ... values) {
        FrameAnimator anim = new FrameAnimator();
        anim.setObjectValues(values);
        anim.setEvaluator(evaluator);
        return anim;
    }

    public void requestUpdate() {
        if (this.isAnimationEnd) {
            return;
        }
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        if (this.mStartTime < 0L) {
            this.mCurrentIteration = 0;
            this.mStartTime = currentTime;
        }
        this.mCurrentPlayTime = currentTime - this.mStartTime;
        this.setCurrentPlayTime(this.mCurrentPlayTime);
        if (this.mCurrentPlayTime >= this.getDuration()) {
            if (this.mCurrentIteration >= this.getRepeatCount() && this.getRepeatCount() != -1) {
                this.endAnimation();
            } else {
                this.mStartTime = currentTime;
                ++this.mCurrentIteration;
            }
        }
    }

    private void endAnimation() {
        if (!this.isAnimationEnd && this.getListeners() != null) {
            ArrayList tmpListeners = (ArrayList)this.getListeners().clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd((Animator)this);
            }
        }
        this.isAnimationEnd = true;
    }

    public boolean isAnimatorEnd() {
        return this.isAnimationEnd;
    }
}

