/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.view.ViewGroup;
import com.bumptech.glide.Glide;
import com.duowan.mobile.basemedia.watchlive.activity.ViewingRoomProcessor;
import com.duowan.mobile.jsannotation.PluginInit;
import com.duowan.mobile.main.kinds.Kinds;
import com.example.configcenter.Publess;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.abtest.IPv6BigCustomerABTest;
import com.unionyy.mobile.meipai.abtest.IPv6GslbABTest;
import com.unionyy.mobile.meipai.abtest.IPv6MediaABTest;
import com.unionyy.mobile.meipai.api.YY2MPAppSafeModelAction;
import com.unionyy.mobile.meipai.api.YY2MPInfoAction;
import com.unionyy.mobile.meipai.api.YY2MPLoginAction;
import com.unionyy.mobile.meipai.api.YY2MPStartLivePermissionAction;
import com.unionyy.mobile.meipai.gift.core.IMPGiftCore;
import com.unionyy.mobile.meipai.gslb.MPNetConfigData;
import com.unionyy.mobile.meipai.mpapi.impl.ActionRegister;
import com.unionyy.mobile.meipai.mpapi.impl.TestYY2MPAppSafeModelActionImpl;
import com.unionyy.mobile.meipai.mpapi.impl.TestYY2MPInfoActionImpl;
import com.unionyy.mobile.meipai.mpapi.impl.TestYY2MPLoginActionImpl;
import com.unionyy.mobile.meipai.mpapi.impl.TestYY2MPStartLivePermissionActionImpl;
import com.unionyy.mobile.meipai.program.core.PopularityAndTimesReceiver;
import com.unionyy.mobile.meipai.template.anchor.MeiPaiAnchorViewingRoom;
import com.unionyy.mobile.meipai.template.audience.MeiPaiAudienceEndViewingRoom;
import com.unionyy.mobile.meipai.template.audience.MeiPaiAudienceViewingRoom;
import com.unionyy.mobile.meipai.turntable.core.IMPTurntableCore;
import com.yy.android.small.pluginbase.IPluginEntryPoint;
import com.yy.android.small.pluginbase.IPluginManager;
import com.yy.android.sniper.annotation.sneak.DartsInitialize;
import com.yy.android.sniper.api.darts.DartsApi;
import com.yy.android.sniper.api.darts.DartsFactory;
import com.yy.android.sniper.apt.darts.meipai$$$DartsFactory$$$proxy;
import com.yy.mobile.android.arouter.facade.annotation.PluginInitalizer;
import com.yy.mobile.android.arouter.facade.template.IPluginInitalizer;
import com.yy.mobile.android.arouter.launcher.ARouter;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.entrypoint.annotation.LibEntryPoint;
import com.yy.mobile.http.GlideIPv6Interceptors;
import com.yy.mobile.http.OkHttpDns;
import com.yy.mobile.http.dns.CommonUtilsKt;
import com.yy.mobile.http.dns.GslbDns;
import com.yy.mobile.http.dns.NetStackCheck;
import com.yy.mobile.js.JsBinders;
import com.yy.mobile.pluginstartlive.template.AnchorRoomProcessor;
import com.yy.mobile.replugin.ApiBridge;
import com.yy.mobile.smartrefresh.layout.SmartRefreshLayout;
import com.yy.mobile.smartrefresh.layout.api.DefaultRefreshHeaderCreater;
import com.yy.mobile.smartrefresh.layout.api.RefreshHeader;
import com.yy.mobile.smartrefresh.layout.api.RefreshLayout;
import com.yy.mobile.smartrefresh.layout.header.ClassicsHeader;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.abtest.YLKAbTest;
import com.yy.yylivekit.ipv6.IPv6Manager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.domain.DomainManager;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.functions.Function0;
import mobile.yy.com.kinds.rxjava.KindsObservable;

@PluginInit
@LibEntryPoint(priority=5)
public enum PluginEntryPoint implements IPluginEntryPoint
{
    INSTANCE;

    private static final String TAG = "PluginMeiPaiEntryPoint";
    @PluginInitalizer
    public IPluginInitalizer mPluginInitalizer;
    private Disposable netDisposable = null;
    private Disposable testDispos;

    public void initialize(IPluginManager manager) {
        this.dartsInitialize();
        ARouter.getInstance().inject((Object)this);
        ARouter.getInstance().addPluginRouteMap(this.mPluginInitalizer);
        ActionRegister.register();
        JsBinders.INSTANCE.initPlugin((Object)this);
        this.initAction();
        this.setUpRefreshLayout();
        this.initNetConfig();
    }

    public void mainEntry(Intent intent, Activity activity, ViewGroup parentView) {
        String action = intent.getAction();
        MLog.info((Object)TAG, (String)"mainEntry: action = %s", (Object[])new Object[]{action});
        if (action == null) {
            return;
        }
        if ("START_ACTION_MEIPAI_MAIN".equals(action)) {
            ViewingRoomProcessor.getInstance().upgradeRoomClz(MeiPaiAudienceViewingRoom.class);
        } else if ("START_ACTION_MEIPAI_DESTROY".equals(action)) {
            ViewingRoomProcessor.getInstance().downgradeRoomClz(MeiPaiAudienceViewingRoom.class);
        } else if ("START_MEIPAI_ANCHOR_ACTION".equals(action)) {
            AnchorRoomProcessor.getInstance().upgradeRoomClz(MeiPaiAnchorViewingRoom.class);
        } else if ("DESTROY_MEIPAI_ANCHOR_ACTION".equals(action)) {
            AnchorRoomProcessor.getInstance().downgradeRoomClz(MeiPaiAnchorViewingRoom.class);
        } else if ("START_ACTION_MEIPAI_END_MAIN".equals(action)) {
            ViewingRoomProcessor.getInstance().upgradeRoomClz(MeiPaiAudienceEndViewingRoom.class);
        } else if ("DESTROY_ACTION_MEIPAI_END_MAIN".equals(action)) {
            ViewingRoomProcessor.getInstance().downgradeRoomClz(MeiPaiAudienceEndViewingRoom.class);
        }
    }

    public void terminate(IPluginManager manager) {
    }

    @DartsInitialize(automatic=false)
    public void dartsInitialize() {
        DartsApi.init((DartsFactory[])new DartsFactory[]{new meipai$$$DartsFactory$$$proxy()});
        ICoreManagerBase.getCore(IMPGiftCore.class);
        ICoreManagerBase.getCore(IMPTurntableCore.class);
        PopularityAndTimesReceiver.INSTANCE.init();
    }

    private void initAction() {
        if (ApiBridge.INSTANCE.getApi(YY2MPLoginAction.class) == null) {
            ApiBridge.INSTANCE.register(YY2MPLoginAction.class, (Function0)new Function0<YY2MPLoginAction>(){

                public YY2MPLoginAction invoke() {
                    return new TestYY2MPLoginActionImpl();
                }
            });
        }
        if (ApiBridge.INSTANCE.getApi(YY2MPAppSafeModelAction.class) == null) {
            ApiBridge.INSTANCE.register(YY2MPAppSafeModelAction.class, (Function0)new Function0<YY2MPAppSafeModelAction>(){

                public YY2MPAppSafeModelAction invoke() {
                    return new TestYY2MPAppSafeModelActionImpl();
                }
            });
        }
        if (ApiBridge.INSTANCE.getApi(YY2MPStartLivePermissionAction.class) == null) {
            ApiBridge.INSTANCE.register(YY2MPStartLivePermissionAction.class, (Function0)new Function0<YY2MPStartLivePermissionAction>(){

                public YY2MPStartLivePermissionAction invoke() {
                    return new TestYY2MPStartLivePermissionActionImpl();
                }
            });
        }
        if (ApiBridge.INSTANCE.getApi(YY2MPInfoAction.class) == null) {
            ApiBridge.INSTANCE.register(YY2MPInfoAction.class, (Function0)new Function0<YY2MPInfoAction>(){

                public YY2MPInfoAction invoke() {
                    return new TestYY2MPInfoActionImpl();
                }
            });
        }
    }

    private void preloadResources() {
        String[] preloadUrls;
        Context context = BasicConfig.getInstance().getAppContext();
        for (String url : preloadUrls = context.getResources().getStringArray(R.array.meipai_preload_resources)) {
            Glide.with((Context)context).load(url).preload();
        }
    }

    private void setUpRefreshLayout() {
        SmartRefreshLayout.setDefaultRefreshHeaderCreater((DefaultRefreshHeaderCreater)new DefaultRefreshHeaderCreater(){

            @NonNull
            public RefreshHeader createRefreshHeader(Context context, RefreshLayout layout2) {
                return new ClassicsHeader(context);
            }
        });
    }

    @SuppressLint(value={"CheckResult"})
    private void initNetConfig() {
        Publess.of(MPNetConfigData.class).pull().subscribe((Consumer)new Consumer<MPNetConfigData>(){

            public void accept(MPNetConfigData mpNetConfigData) throws Exception {
                boolean bl = OkHttpDns.useGslb = mpNetConfigData.getGslbSwitch() == 1;
                if (mpNetConfigData.getDomainSetting().size() > 0) {
                    DomainManager.updateSetting(mpNetConfigData.getDomainSetting());
                }
                MLog.info((Object)PluginEntryPoint.TAG, (String)("MPNetConfigData = " + mpNetConfigData.toString()), (Object[])new Object[0]);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.info((Object)PluginEntryPoint.TAG, (String)("error = " + throwable), (Object[])new Object[0]);
            }
        });
        KindsObservable.INSTANCE.ofFlow(IPv6BigCustomerABTest.class, 3000L).subscribe((Consumer)new Consumer<IPv6BigCustomerABTest>(){

            public void accept(IPv6BigCustomerABTest iPv6BigCustomerABTest) throws Exception {
                IPv6Manager.getInstance().liveSetUserIpStack(CommonUtilsKt.INSTANCE.currrentIPStack());
                MLog.info((Object)PluginEntryPoint.TAG, (String)("  iPv6BigCustomerABTest = " + iPv6BigCustomerABTest.isBigCustomer()), (Object[])new Object[0]);
                if (iPv6BigCustomerABTest.isBigCustomer()) {
                    GslbDns.inst().setEnableIpv6(false);
                    YLKAbTest.INSTANCE.setAbTest(YLKAbTest.IPV6, 0);
                    HashMap<Integer, String> map = new HashMap<Integer, String>();
                    map.put(5001, "0");
                    YLKAbTest.INSTANCE.setTransStrAbTest(map);
                }
            }
        }, RxUtils.errorConsumer((String)TAG));
        KindsObservable.INSTANCE.ofFlow(IPv6GslbABTest.class, 3000L).subscribe((Consumer)new Consumer<IPv6GslbABTest>(){

            public void accept(IPv6GslbABTest iPv6GslbABTest) throws Exception {
                MLog.info((Object)PluginEntryPoint.TAG, (String)("  IPv6GslbABTest = " + iPv6GslbABTest.getEnableIPv6()), (Object[])new Object[0]);
                GslbDns.inst().setEnableIpv6(GslbDns.canEnableGslbIpv6((boolean)iPv6GslbABTest.getEnableIPv6()));
                GlideIPv6Interceptors.Companion.setAbFlag(iPv6GslbABTest.getEnableIPv6());
                PluginEntryPoint.this.asynCheck(iPv6GslbABTest.getEnableIPv6());
            }
        }, RxUtils.errorConsumer((String)TAG));
        KindsObservable.INSTANCE.ofFlow(IPv6MediaABTest.class, 3000L).subscribe((Consumer)new Consumer<IPv6MediaABTest>(){

            public void accept(IPv6MediaABTest iPv6MediaABTest) throws Exception {
                IPv6Manager.getInstance().liveSetUserIpStack(CommonUtilsKt.INSTANCE.currrentIPStack());
                int value = iPv6MediaABTest.getEnableIPv6() ? 1 : 0;
                MLog.info((Object)PluginEntryPoint.TAG, (String)("IPv6MediaABTest = " + value), (Object[])new Object[0]);
                YLKAbTest.INSTANCE.setAbTest(YLKAbTest.IPV6, value);
                HashMap<Integer, String> map = new HashMap<Integer, String>();
                map.put(5001, String.valueOf(value));
                YLKAbTest.INSTANCE.setTransStrAbTest(map);
            }
        }, RxUtils.errorConsumer((String)TAG));
        NetworkUtils.addListenerList((NetworkUtils.NetworkUpdateListener)new NetworkUtils.NetworkUpdateListener(){

            public void networkUpdate() {
                if (PluginEntryPoint.this.netDisposable != null) {
                    PluginEntryPoint.this.netDisposable.dispose();
                }
                PluginEntryPoint.this.netDisposable = Observable.just((Object)1).subscribeOn(Schedulers.io()).delay(3L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Integer>(){

                    public void accept(Integer integer) throws Exception {
                        MLog.info((Object)PluginEntryPoint.TAG, (String)"----\u7f51\u7edc\u53d8\u5316----", (Object[])new Object[0]);
                        GslbDns.inst().setEnableIpv6(GslbDns.canEnableGslbIpv6((boolean)((IPv6GslbABTest)Kinds.of(IPv6GslbABTest.class)).getEnableIPv6()));
                        IPv6Manager.getInstance().liveSetUserIpStack(CommonUtilsKt.INSTANCE.currrentIPStack());
                        PluginEntryPoint.this.asynCheck(((IPv6GslbABTest)Kinds.of(IPv6GslbABTest.class)).getEnableIPv6());
                    }
                }, RxUtils.errorConsumer((String)PluginEntryPoint.TAG));
            }
        });
    }

    public void asynCheck(final boolean gslbConfig) {
        if (this.testDispos != null) {
            this.testDispos.dispose();
        }
        this.testDispos = NetStackCheck.INSTANCE.asyncCheckCurrentStack().subscribe((Consumer)new Consumer<CommonUtilsKt.IP>(){

            public void accept(CommonUtilsKt.IP ip) throws Exception {
                MLog.info((Object)PluginEntryPoint.TAG, (String)("asynCheck -> ip = " + ip), (Object[])new Object[0]);
                GslbDns.inst().updateIpv6ConfigAsync(gslbConfig, ip);
                IPv6Manager.getInstance().liveSetUserIpStack(CommonUtilsKt.INSTANCE.stackTransformToLivekitLong(ip));
                GlideIPv6Interceptors.Companion.updateParseV6Host(ip);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)PluginEntryPoint.TAG, (String)"asynCheck: throwable = ", (Throwable)throwable, (Object[])new Object[0]);
            }
        });
    }
}

