/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.popularity.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.utils.GlideUtil;
import com.unionyy.mobile.meipai.gift.animation.view.StrokeTextView;
import com.unionyy.mobile.meipai.gift.core.config.Middleware2MPGiftMgr;
import com.unionyy.mobile.meipai.popularity.view.CallProgressView;
import com.yy.mobile.util.log.MLog;

public class CallView
extends FrameLayout {
    private static final long ANIMATION_DURATION_PERIOD = 1500L;
    private static final int REPEAT_COUNT = 2;
    public static final int POPULARITY_NUM_INVALIDATE = -1;
    private CallProgressView mCallProgressView;
    private StrokeTextView mTvNum;
    private ImageView mIvIcon;
    private RelativeLayout mRlCombArea;
    private FrameLayout mRlProgressIconWrap;

    public CallView(Context context) {
        this(context, null);
    }

    public CallView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CallView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        layoutInflater.inflate(R.layout.meipai_live_layout_popularity_gift_icon_view, (ViewGroup)this, true);
        this.mCallProgressView = (CallProgressView)this.findViewById(R.id.mpyy_view_popularity_progress);
        this.mTvNum = (StrokeTextView)this.findViewById(R.id.tv_num_tip);
        this.mIvIcon = (ImageView)this.findViewById(R.id.iv_popularity_icon);
        this.mRlCombArea = (RelativeLayout)this.findViewById(R.id.popularity_gift_selector_combos_are);
        this.mRlProgressIconWrap = (FrameLayout)this.findViewById(R.id.rl_progress);
    }

    public void setProgress(int progress) {
        this.mCallProgressView.setProgress(progress);
    }

    public int getMaxProgress() {
        return this.mCallProgressView.getMaxProgress();
    }

    public void setNum(int num) {
        if (num > -1) {
            this.mTvNum.setVisibility(0);
            this.mTvNum.setText("" + num);
        } else {
            this.mTvNum.setVisibility(8);
        }
    }

    public boolean setIConUrl(int giftId) {
        Middleware2MPGiftMgr.Companion.getInstances().setPopularityGiftId(giftId);
        String url = Middleware2MPGiftMgr.Companion.getInstances().findGiftThumbResUrlByType(giftId);
        MLog.debug((Object)"CallView", (String)("setIConUrl " + url), (Object[])new Object[0]);
        if (url.isEmpty()) {
            return false;
        }
        GlideUtil.loadImage(this, url, this.mIvIcon, RequestOptions.errorOf((int)R.drawable.live_ic_popularity_view_center_call).placeholder(R.drawable.live_ic_popularity_view_center_call).diskCacheStrategy(DiskCacheStrategy.NONE));
        return true;
    }

    public void startAnimation(Animator.AnimatorListener animatorListener) {
        AnimatorSet scaleAnimatorSet = new AnimatorSet();
        ValueAnimator alpha = ValueAnimator.ofFloat((float[])new float[]{0.0f, 45.0f});
        alpha.setInterpolator((TimeInterpolator)new LinearInterpolator());
        alpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float currentFrame = ((Float)animation.getAnimatedValue()).floatValue();
                if (currentFrame <= 15.0f) {
                    CallView.this.mCallProgressView.setAlpha(currentFrame / 15.0f * 1.0f);
                } else {
                    float alpha = 1.0f - (currentFrame - 15.0f) / 30.0f * 1.0f;
                    CallView.this.mCallProgressView.setAlpha(alpha);
                }
            }
        });
        alpha.setRepeatCount(2);
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)((Object)this.mCallProgressView), (String)"scaleX", (float[])new float[]{0.34f, 1.0f, 0.85f, 1.0f});
        scaleX.setRepeatCount(2);
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)((Object)this.mCallProgressView), (String)"scaleY", (float[])new float[]{0.34f, 1.0f, 0.85f, 1.0f});
        scaleY.setRepeatCount(2);
        scaleAnimatorSet.play((Animator)scaleX).with((Animator)scaleY).with((Animator)alpha);
        scaleAnimatorSet.setDuration(1500L);
        scaleAnimatorSet.start();
        scaleAnimatorSet.addListener(animatorListener);
        scaleAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CallView.this.mCallProgressView.setAlpha(1.0f);
            }
        });
    }

    public RelativeLayout getRlCombArea() {
        return this.mRlCombArea;
    }

    public FrameLayout getRlProgressIconWrap() {
        return this.mRlProgressIconWrap;
    }

    public void setProgressVisibility(boolean visibility) {
        if (visibility) {
            this.mRlProgressIconWrap.setVisibility(0);
        } else {
            this.mRlProgressIconWrap.setVisibility(8);
        }
    }
}

