/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.viewdelegate;

import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.event.EventCountDownFinished;
import com.unionyy.mobile.meipai.pk.ui.model.PkStatusInfo;
import com.unionyy.mobile.meipai.pk.ui.view.CountDownTimerView;
import com.unionyy.mobile.meipai.pk.ui.viewdelegate.BaseViewUpdateDelegate;
import com.yy.mobile.RxBus;

public class CountDownViewUpdateDelegate
extends BaseViewUpdateDelegate {
    private static final String TAG = "CountDownViewUpdateDelegate";
    private CountDownTimerView mCountDownTimer;
    private boolean isPlayed;

    public CountDownViewUpdateDelegate(View rootView, FragmentActivity activity, int videoMarginTop) {
        super(rootView, activity, videoMarginTop);
        this.mCountDownTimer = (CountDownTimerView)rootView.findViewById(R.id.live_pk_start_count_down_view);
    }

    @Override
    public void onInit() {
        super.onInit();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        PkStatusInfo info = this.core.getPkStatusInfo();
        if (!this.isPlayed && info.type == 4) {
            this.isPlayed = true;
            this.playAnimanation(info.leftTime * 1000);
        } else if (info.type != 4 && this.isPlayed) {
            this.endAnimanation();
            this.isPlayed = false;
        }
    }

    @Override
    public void onStateChanged(int lastState, int curState) {
        super.onStateChanged(lastState, curState);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.onClosePk();
    }

    @Override
    public void onClosePk() {
        super.onClosePk();
        this.endAnimanation();
    }

    private void playAnimanation(int length) {
        this.mCountDownTimer.setVisibility(0);
        this.mCountDownTimer.start(length, 1000L);
        this.mCountDownTimer.setCountDownTimerListener(new CountDownTimerView.CountDownTimerListener(){

            @Override
            public void onFinish() {
            }

            @Override
            public void onAnimEnd() {
                RxBus.getDefault().post((Object)new EventCountDownFinished());
            }
        });
    }

    private void endAnimanation() {
        this.mCountDownTimer.stop();
        this.mCountDownTimer.clearAnimation();
        this.mCountDownTimer.setVisibility(8);
    }
}

