/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.utils.CountDownTimer;

public class PKCountDownOverTimerView
extends RelativeLayout {
    private ProgressBar mPKProgressBar;
    private TextView mPKOverCountDown;
    private TextView mPKOverCountDownTip;
    private LivePkCountDownTimer mLivePkDownTimer;
    private LivePkCountDownTimer mLivePkCountDownTimer;
    private CountDownTimerListener mCountDownTimerListener;
    public static int TYPE_PROGRESS = 0;
    public static int TYPE_TEXTVIEW = 1;

    public PKCountDownOverTimerView(Context context) {
        super(context);
        this.initView(context);
    }

    public PKCountDownOverTimerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public void initView(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.meipai_pk_over_count_down_time, (ViewGroup)this);
        this.mPKProgressBar = (ProgressBar)view.findViewById(R.id.progressbar_pk);
        this.mPKOverCountDown = (TextView)view.findViewById(R.id.textView_pk_over_count_down);
        this.mPKOverCountDownTip = (TextView)view.findViewById(R.id.textView_pk_over_count_down_tip);
    }

    public void start(long millisInFuture, long countDownInterval) {
        if (this.mLivePkCountDownTimer != null) {
            this.mLivePkCountDownTimer.cancel();
            this.mLivePkCountDownTimer = null;
        }
        if (this.mLivePkDownTimer != null) {
            this.mLivePkDownTimer.cancel();
            this.mLivePkDownTimer = null;
        }
        this.mLivePkCountDownTimer = new LivePkCountDownTimer(millisInFuture, countDownInterval, TYPE_PROGRESS);
        this.mLivePkCountDownTimer.start();
        this.mLivePkDownTimer = new LivePkCountDownTimer(millisInFuture, 1000L, TYPE_TEXTVIEW);
        this.mLivePkDownTimer.start();
    }

    public void stop() {
        if (this.mLivePkCountDownTimer != null) {
            this.mLivePkCountDownTimer.cancel();
            this.mLivePkCountDownTimer = null;
        }
        if (this.mLivePkDownTimer != null) {
            this.mLivePkDownTimer.cancel();
            this.mLivePkDownTimer = null;
        }
    }

    private void executeAnimation(long millisUntilFinished) {
        this.mPKOverCountDown.setText((CharSequence)String.valueOf(millisUntilFinished / 1000L + 1L));
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.5f, 1.0f);
        alphaAnimation.setDuration(700L);
        this.mPKOverCountDown.startAnimation((Animation)alphaAnimation);
        if (this.mPKOverCountDownTip.getVisibility() == 8) {
            this.mPKOverCountDownTip.setVisibility(0);
            AlphaAnimation alphaAnimation2 = new AlphaAnimation(0.0f, 1.0f);
            alphaAnimation2.setDuration(700L);
            this.mPKOverCountDownTip.startAnimation((Animation)alphaAnimation2);
        }
        alphaAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
                alphaAnimation.setDuration(300L);
                PKCountDownOverTimerView.this.mPKOverCountDown.startAnimation((Animation)alphaAnimation);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mLivePkCountDownTimer != null) {
            this.mLivePkCountDownTimer.cancel();
            this.mLivePkCountDownTimer = null;
        }
        if (this.mLivePkDownTimer != null) {
            this.mLivePkDownTimer.cancel();
            this.mLivePkDownTimer = null;
        }
    }

    public void setCountDownTimerListener(CountDownTimerListener mCountDownTimerListener) {
        this.mCountDownTimerListener = mCountDownTimerListener;
    }

    public static interface CountDownTimerListener {
        public void onFinish();
    }

    class LivePkCountDownTimer
    extends CountDownTimer {
        int type;

        public LivePkCountDownTimer(long millisInFuture, long countDownInterval, int type2) {
            super(millisInFuture, countDownInterval);
            this.type = type2;
        }

        @Override
        public void onTick(long millisUntilFinished) {
            if (this.type == TYPE_PROGRESS) {
                if (PKCountDownOverTimerView.this.mPKProgressBar != null) {
                    PKCountDownOverTimerView.this.mPKProgressBar.setProgress(1000 - (int)millisUntilFinished / 10);
                }
            } else if (PKCountDownOverTimerView.this.mPKOverCountDown != null) {
                PKCountDownOverTimerView.this.executeAnimation(millisUntilFinished);
            }
        }

        @Override
        public void onFinish() {
            if (this.type == TYPE_PROGRESS && PKCountDownOverTimerView.this.mCountDownTimerListener != null) {
                PKCountDownOverTimerView.this.mCountDownTimerListener.onFinish();
                PKCountDownOverTimerView.this.setVisibility(8);
            }
        }
    }
}

