/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.ui;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.unionyy.mobile.meipai.gift.ui.GiftCombosProgressView;
import com.yy.mobile.config.BasicConfig;

public class GiftCombosView {
    public static final String TAG = GiftCombosView.class.getSimpleName();
    private boolean mIsSmallStyle;
    private View mView;
    private GiftCombosProgressView mGiftCombosProgressView;
    private TextView tvName;
    private ImageView imgFinger;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private boolean isShow;
    private long duration;
    private static int mSlice = 60;
    private float progress;
    private Runnable mCombosProgressRunnable = new Runnable(){

        @Override
        public void run() {
            if (null == GiftCombosView.this.getCallback()) {
                GiftCombosView.this.mHandler.removeCallbacks((Runnable)this);
                return;
            }
            GiftCombosView.this.progress = GiftCombosView.this.mGiftCombosProgressView.getPercent();
            if (GiftCombosView.this.isShow && GiftCombosView.this.progress < 100.0f) {
                GiftCombosView.this.mGiftCombosProgressView.invalidate();
                GiftCombosView.this.mHandler.postDelayed((Runnable)this, (long)mSlice);
            } else if (GiftCombosView.this.progress >= 100.0f && null != GiftCombosView.this.getCallback()) {
                GiftCombosView.this.getCallback().OnCombosStop();
                GiftCombosView.this.mHandler.removeCallbacks((Runnable)this);
            }
        }
    };
    private OnCombosCallback callback;

    public View getView() {
        return this.mView;
    }

    public GiftCombosView(Context context, boolean isSmall) {
        this.mIsSmallStyle = isSmall;
        this.mView = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(R.layout.meipai_live_layout_gift_combos_live, null);
        this.mGiftCombosProgressView = (GiftCombosProgressView)this.mView.findViewById(R.id.gift_combos_progress);
        this.tvName = (TextView)this.mView.findViewById(R.id.gift_combos_tv);
        this.imgFinger = (ImageView)this.mView.findViewById(R.id.gift_combos_img);
        if (isSmall) {
            RelativeLayout relativeLayout = (RelativeLayout)this.mView.findViewById(R.id.rl_finger_text_wrap);
            RelativeLayout.LayoutParams rlParams = (RelativeLayout.LayoutParams)relativeLayout.getLayoutParams();
            rlParams.addRule(13, 1);
            rlParams.width = -2;
            rlParams.height = -2;
            this.tvName.setTextSize(10.0f);
            Context commontContext = BasicConfig.getInstance().getAppContext();
            RelativeLayout.LayoutParams layoutParamsFinger = (RelativeLayout.LayoutParams)this.imgFinger.getLayoutParams();
            layoutParamsFinger.width = DeviceUtils.dip2px(commontContext, 17.0f);
            layoutParamsFinger.height = DeviceUtils.dip2px(commontContext, 18.0f);
            layoutParamsFinger.topMargin = DeviceUtils.dip2px(commontContext, 0.0f);
            layoutParamsFinger.addRule(13, 0);
            layoutParamsFinger.addRule(14, 1);
            layoutParamsFinger.addRule(10, 0);
            RelativeLayout.LayoutParams layoutParamsTvName = (RelativeLayout.LayoutParams)this.tvName.getLayoutParams();
            layoutParamsTvName.topMargin = DeviceUtils.dip2px(commontContext, 3.0f);
            layoutParamsTvName.bottomMargin = DeviceUtils.dip2px(commontContext, 0.0f);
            layoutParamsTvName.addRule(13, 0);
            layoutParamsTvName.addRule(12, 0);
            layoutParamsTvName.addRule(3, R.id.gift_combos_img);
        }
        this.mView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GiftCombosView.this.isShow) {
                    GiftCombosView.this.progress = 0.0f;
                    if (null != GiftCombosView.this.getCallback()) {
                        GiftCombosView.this.getCallback().OnCombosClick();
                    }
                }
            }
        });
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setVisibility(boolean isShow) {
        int visible = isShow ? 0 : 8;
        this.isShow = isShow;
        this.mView.setVisibility(visible);
        if (isShow) {
            this.startAnimation();
        } else {
            this.stopAnimation();
        }
    }

    public void startAnimation() {
        this.stopAnimation();
        ((AnimationDrawable)this.imgFinger.getDrawable()).start();
        this.mGiftCombosProgressView.start(this.duration * 1000L);
        this.mHandler.post(this.mCombosProgressRunnable);
    }

    public void stopAnimation() {
        this.progress = 0.0f;
        ((AnimationDrawable)this.imgFinger.getDrawable()).stop();
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public boolean isShow() {
        return this.isShow;
    }

    public OnCombosCallback getCallback() {
        return this.callback;
    }

    public void setCallback(OnCombosCallback callback2) {
        this.callback = callback2;
    }

    public static interface OnCombosCallback {
        public void OnCombosStop();

        public void OnCombosClick();
    }
}

