/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.utils;

import android.graphics.Bitmap;
import android.os.Handler;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import com.unionyy.mobile.meipai.gift.animation.utils.IImagePlayer;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.internal.NamedRunnable;

public class WebPImagePlayer
implements IImagePlayer {
    private static final String TAG = WebPImagePlayer.class.getSimpleName();
    private int mFrameNumber;
    private int mLoopFrom;
    private int mLoopTo;
    private int mCurrentFrame;
    private int mLoopMode;
    private int mFrameRate;
    private long mStartTime = -1L;
    private boolean isStartLoop;
    private boolean isPlayingBackWards;
    private boolean isDisplaying;
    private Handler mHandler = new Handler();
    private IImagePlayer.IDisplayCallBack mDisplayCallBack;
    private boolean isAbortRequest = false;
    private String mImagePath;
    private Bitmap[] mBitmap = new Bitmap[2];
    private int mIndex = 0;
    private NamedRunnable mDisplayThread = new NamedRunnable(TAG, new Object[0]){

        public void execute() {
            while (!WebPImagePlayer.this.isAbortRequest) {
                if (WebPImagePlayer.this.init()) continue;
                return;
            }
        }
    };

    public WebPImagePlayer(IImagePlayer.IDisplayCallBack callBack) {
        this.mDisplayCallBack = callBack;
    }

    public void setDataSource(String imagePath, int loopMode, int loopFrom, int loopTo) {
        this.mImagePath = imagePath;
        this.mLoopMode = loopMode;
        this.mLoopFrom = loopFrom;
        this.mLoopTo = loopTo;
        this.mCurrentFrame = 1;
    }

    @Override
    public void setDataSource(String imagePath, GiftRule rule) {
        this.setDataSource(imagePath, rule.loop_mode, rule.loop_from, rule.loop_to);
    }

    @Override
    public void start() {
        YYTaskExecutor.execute((Runnable)this.mDisplayThread);
    }

    @Override
    public void stop() {
        this.isAbortRequest = true;
        this.mDisplayCallBack = null;
        this.notifyDisplay(this.mDisplayThread);
        if (this.mBitmap != null) {
            for (int i = 0; i < this.mBitmap.length; ++i) {
                if (this.mBitmap[i] == null) continue;
                this.mBitmap[i].recycle();
                this.mBitmap[i] = null;
            }
            this.mBitmap = null;
        }
    }

    private void nextFrame() {
        this.mCurrentFrame += this.isPlayingBackWards ? -1 : 1;
        if (this.isStartLoop && (!this.isPlayingBackWards && this.mCurrentFrame > this.mLoopTo || this.isPlayingBackWards && this.mCurrentFrame < this.mLoopFrom) || this.mCurrentFrame > this.mFrameNumber) {
            if (this.mLoopFrom > 0) {
                if (this.mLoopMode > 0) {
                    this.mCurrentFrame = this.isStartLoop || this.mLoopTo == this.mFrameNumber ? (this.isPlayingBackWards ? this.mLoopFrom + 1 : this.mLoopTo - 1) : this.mLoopTo;
                    this.isPlayingBackWards = !this.isPlayingBackWards;
                } else {
                    this.mCurrentFrame = this.mLoopFrom;
                }
                this.isStartLoop = true;
            } else {
                this.mCurrentFrame = this.mFrameNumber;
            }
        }
    }

    private boolean init() {
        return true;
    }

    private byte[] loadImageSource() {
        try {
            FileInputStream inputStream = new FileInputStream(this.mImagePath);
            int size = ((InputStream)inputStream).available();
            byte[] bytes = new byte[size];
            ((InputStream)inputStream).read(bytes);
            ((InputStream)inputStream).close();
            return bytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDisplay(Object obj) {
        try {
            Object object = obj;
            synchronized (object) {
                while (this.isDisplaying) {
                    obj.wait();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDisplay(Object obj) {
        this.isDisplaying = false;
        Object object = obj;
        synchronized (object) {
            obj.notify();
        }
    }
}

