/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.utils;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.widget.ImageView;
import com.yy.mobile.config.BasicConfig;
import java.io.IOException;
import java.io.InputStream;

public class BitmapUtil {
    private static final String TAG = BitmapUtil.class.getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmapFromAssets(String fileName) {
        Bitmap bitmap = null;
        InputStream is = null;
        AssetManager am = BasicConfig.getInstance().getAppContext().getResources().getAssets();
        try {
            is = am.open(fileName);
            bitmap = BitmapFactory.decodeStream((InputStream)is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return bitmap;
    }

    public static Bitmap changeOpaquePixColor(Bitmap sourceBitmap, int targetColor, boolean toRecycleSource) {
        Bitmap bitmap;
        if (sourceBitmap == null) {
            Log.w((String)TAG, (String)"sourceBitmap is null");
            return null;
        }
        if (sourceBitmap.isRecycled()) {
            Log.w((String)TAG, (String)"try to using a recycled bitmap:sourceBitmap");
            return null;
        }
        if (sourceBitmap.isMutable()) {
            bitmap = sourceBitmap;
        } else {
            bitmap = sourceBitmap.copy(Bitmap.Config.ARGB_8888, true);
            if (toRecycleSource) {
                sourceBitmap.recycle();
            }
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(targetColor, PorterDuff.Mode.SRC_IN);
        return bitmap;
    }

    public static int[] parseRGB(int color) {
        int red = (color & 0xFF0000) >> 16;
        int green = (color & 0xFF00) >> 8;
        int blue = color & 0xFF;
        return new int[]{red, green, blue};
    }

    public static int[] parseARGB(int color) {
        return new int[]{Color.alpha((int)color), Color.red((int)color), Color.green((int)color), Color.blue((int)color)};
    }

    public static void changeBrightness(ImageView imageView, float brightness) {
        ColorMatrix mCm = new ColorMatrix();
        mCm.set(new float[]{1.0f, 0.0f, 0.0f, 0.0f, brightness, 0.0f, 1.0f, 0.0f, 0.0f, brightness, 0.0f, 0.0f, 1.0f, 0.0f, brightness, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        imageView.setColorFilter((ColorFilter)new ColorMatrixColorFilter(mCm));
    }

    public static Bitmap zoomBitmap(Bitmap bitmap, float w, float h) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = w / (float)width;
        matrix.postScale(scaleWidth, scaleWidth);
        Bitmap newBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return newBmp;
    }

    public static int scaleFromDensity(int size, int sdensity, int tdensity) {
        if (sdensity == 0 || tdensity == 0 || sdensity == tdensity) {
            return size;
        }
        return (size * tdensity + (sdensity >> 1)) / sdensity;
    }

    public static Bitmap drawable2Bitmap(Drawable drawable2) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static void release(Bitmap bmp) {
        if (BitmapUtil.isAvailableBitmap(bmp)) {
            bmp.recycle();
            bmp = null;
        }
    }

    public static boolean isAvailableBitmap(Bitmap bmp) {
        return bmp != null && !bmp.isRecycled();
    }
}

