/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.gifttarget;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import com.unionyy.mobile.meipai.gift.animation.utils.AnimateResourceLoader;
import com.unionyy.mobile.meipai.gift.animation.utils.IImagePlayer;
import com.unionyy.mobile.meipai.gift.animation.utils.ImageSeqPlayer;
import com.unionyy.mobile.meipai.gift.animation.utils.WebPImagePlayer;
import com.unionyy.mobile.meipai.gift.animation.view.GiftImageView;
import com.unionyy.mobile.meipai.gift.animation.view.GlAnimationView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.util.log.MLog;

public class GiftImageTarget
extends GiftTarget {
    private ViewGroup.LayoutParams mImageParams;
    private GiftImageView mGiftImageView;
    private IImagePlayer mImageSeqPlayer;
    private IImagePlayer.IDisplayCallBack mDisplayCallBack = new IImagePlayer.IDisplayCallBack(){

        @Override
        public void imageRefresh(Bitmap bitmap) {
            if (GiftImageTarget.this.mGiftImageView != null) {
                GiftImageTarget.this.mGiftImageView.setImageBitmap(bitmap);
            }
        }
    };

    public GiftImageTarget() {
        super(false);
    }

    @Override
    protected void addGiftImage(Context context, ViewGroup group, float x, float y, int z) {
        String imagePath = this.getGiftImagePath();
        if (this.mGiftImageView == null) {
            this.mGiftImageView = new GiftImageView(context);
            this.mImageParams = new ViewGroup.LayoutParams(this.getGiftImageWidth(), this.getGiftImageHeight());
        } else {
            this.mGiftImageView.setRotation(0.0f);
            this.mGiftImageView.setAlpha(1.0f);
            this.mGiftImageView.setScaleX(1.0f);
            this.mGiftImageView.setScaleY(1.0f);
            this.mImageParams.width = this.getGiftImageWidth();
            this.mImageParams.height = this.getGiftImageHeight();
            if (this.mGiftImageView.getParent() != null) {
                this.mGiftImageView.release();
                ((ViewGroup)this.mGiftImageView.getParent()).removeView((View)this.mGiftImageView);
            }
        }
        this.mGiftImageView.setVisibility(8);
        this.mGiftImageView.setTranslationX(x);
        this.mGiftImageView.setTranslationY(y);
        if (z > group.getChildCount()) {
            z = group.getChildCount();
        }
        group.addView((View)this.mGiftImageView, z, this.mImageParams);
        if (null != this.mGiftRule) {
            final GiftRule rule = this.mGiftRule;
            if (rule.type == 0) {
                AnimateResourceLoader.getInstance().loadBitmap(imagePath, new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        GiftImageTarget.this.mGiftImageView.setImageBitmap(bitmap);
                    }
                });
            } else if (rule.type == 2) {
                final String tempImagePath = imagePath;
                AnimateResourceLoader.getInstance().loadBitmap(imagePath, new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                        MLog.info((Object)"GiftImageTarget", (String)e.toString(), (Object[])new Object[0]);
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        MLog.info((Object)"GiftImageTarget", (String)"imagepath = %s, bitmap=%s", (Object[])new Object[]{tempImagePath, bitmap.toString()});
                        GiftImageTarget.this.mGiftImageView.setImageBitmap(bitmap);
                        GiftImageTarget.this.mGiftImageView.setGifParams(rule, GiftImageTarget.this.mImageScale);
                        if (GiftImageTarget.this.mGiftImageView.isPlayErrorByFrameRate()) {
                            GiftImageTarget.this.mGiftImageView.setPlayErrorByFrameRate(false);
                            GiftImageTarget.this.startGifAnimation();
                        }
                    }
                });
            } else if (rule.type == 3) {
                this.mImageSeqPlayer = new ImageSeqPlayer(this.mDisplayCallBack);
                this.mImageSeqPlayer.setDataSource(imagePath, rule);
            } else if (rule.type == 4) {
                this.mImageSeqPlayer = new WebPImagePlayer(this.mDisplayCallBack);
                this.mImageSeqPlayer.setDataSource(imagePath, rule);
            }
            if (rule.play_at_start) {
                MLog.info((Object)"GiftImageTarget", (String)"startGifAnimation", (Object[])new Object[0]);
                this.startGifAnimation();
            }
        }
    }

    @Override
    protected Object getGiftImage() {
        return this.mGiftImageView;
    }

    @Override
    public void startGiftAnimation(GiftRule rule) {
        MLog.info((Object)"GiftImageTarget", (String)"startGiftAnimation", (Object[])new Object[0]);
        if (rule == null) {
            return;
        }
        super.startGiftAnimation(rule);
        this.mGiftImageView.setVisibility(0);
    }

    @Override
    protected boolean afterBeginningAnimation() {
        if (super.afterBeginningAnimation()) {
            if (this.mGiftRule != null && this.mGiftRule.type != 0 && !this.mGiftRule.play_at_start) {
                this.startGifAnimation();
            }
            return true;
        }
        return false;
    }

    private void startGifAnimation() {
        if (this.mGiftRule == null) {
            return;
        }
        if (this.mGiftRule.type == 2) {
            this.mGiftImageView.startGifAnimation();
        } else if (this.mGiftRule.type == 3 || this.mGiftRule.type == 4) {
            this.mImageSeqPlayer.start();
        }
    }

    @Override
    protected void onGiftAnimationEnd() {
        if (this.mCurrentState == 4) {
            return;
        }
        if (this.mGiftImageView != null) {
            int type2 = this.mGiftRule.type;
            this.mGiftImageView.setImageBitmap(null);
            if (type2 == 2) {
                this.mGiftImageView.release();
            } else if (type2 == 3 || type2 == 4) {
                this.mImageSeqPlayer.stop();
            }
            if (this.mGiftImageView.getParent() != null) {
                ((ViewGroup)this.mGiftImageView.getParent()).removeView((View)this.mGiftImageView);
            }
            this.mGiftImageView.setVisibility(8);
        }
        super.onGiftAnimationEnd();
    }

    @Override
    public int onChildTextureDraw(GlAnimationView gl, int z) {
        return z;
    }
}

