/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.gifttarget;

import android.content.Context;
import android.view.ViewGroup;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.ComboPointTarget;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GlImageTarget;
import com.unionyy.mobile.meipai.gift.animation.utils.AnimateResourceLoader;
import com.unionyy.mobile.meipai.gift.animation.view.GlAnimationView;

public class ComboPointGLTarget
extends ComboPointTarget {
    private static final float[] SCALE_FACTOR_TWO = new float[]{0.91f, 1.0f, 1.1f};
    private static final float[] SCALE_FACTOR_FOUR = new float[]{0.68f, 0.75f, 0.83f, 0.91f, 1.0f};
    private int width;
    private int height;
    private int[] mNumberSize = new int[22];
    private GlImageTarget[] mNumberImage;
    private float transX;
    private float transY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float alpha = 1.0f;
    private boolean isVisible;

    @Override
    public void addTo(Context context, ViewGroup group, int z) {
        this.isVisible = false;
    }

    @Override
    public void remove(ViewGroup group) {
        this.isVisible = false;
    }

    @Override
    public void setVisibility(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public void setCombopoint(int point) {
        this.width = 0;
        this.height = 0;
        int bits = this.getPointBits(point);
        if (bits <= 0) {
            return;
        }
        this.mNumberImage = new GlImageTarget[bits + 1];
        if (point < 100) {
            this.createNumberArray(point, SCALE_FACTOR_TWO);
        } else {
            this.createNumberArray(point, SCALE_FACTOR_FOUR);
        }
    }

    private void createNumberArray(int point, float[] scaleFactors) {
        this.width = 0;
        this.height = 0;
        this.calculateViewSize(0, -1, scaleFactors[0]);
        for (int len = this.mNumberImage.length - 1; point > 0 && len > 0; --len) {
            int num = point % 10;
            point /= 10;
            int index = len;
            if (index >= scaleFactors.length) {
                index = scaleFactors.length - 1;
            }
            this.calculateViewSize(index, num, scaleFactors[index]);
        }
        this.createNumberPosition();
    }

    private void createNumberPosition() {
        float left = 0.0f;
        int i = 0;
        while (i < this.mNumberImage.length) {
            int num = i++;
            GlImageTarget target = this.mNumberImage[num];
            int bitmapWidth = target.getWidth();
            int bitmapHeight = target.getHeight();
            target.setX(left + (float)(bitmapWidth / 2));
            target.setY(this.height - bitmapHeight / 2);
            left += (float)bitmapWidth;
        }
    }

    private void calculateViewSize(int index, int digit, float scaleFactor) {
        int num = digit + 1;
        if (this.mNumberImage[index] == null) {
            this.mNumberImage[index] = new GlImageTarget();
            int[] size = AnimateResourceLoader.getInstance().getNumberBitmapSize(digit);
            this.mNumberSize[num * 2] = size[0];
            this.mNumberSize[num * 2 + 1] = size[1];
            this.mNumberImage[index].addDrawable((Object)AnimateResourceLoader.getInstance().getNumberResourceId(digit));
        }
        int scaleWidth = (int)((float)this.mNumberSize[num * 2] * scaleFactor);
        int scaleHeight = (int)((float)this.mNumberSize[num * 2 + 1] * scaleFactor);
        this.mNumberImage[index].setLayoutParams(scaleWidth, scaleHeight);
        this.width += scaleWidth;
        if (scaleHeight > this.height) {
            this.height = scaleHeight;
        }
    }

    private int getPointBits(int point) {
        int count = 0;
        while (point > 0) {
            ++count;
            point /= 10;
        }
        return count;
    }

    @Override
    public int getComboWidth() {
        return this.width;
    }

    @Override
    public int getComboHeight() {
        return this.height;
    }

    @Override
    public void setTranslationX(float x) {
        this.transX = x;
    }

    @Override
    public void setTranslationY(float y) {
        this.transY = y;
    }

    @Override
    public float getTranslationX() {
        return this.transX;
    }

    @Override
    public float getTranslationY() {
        return this.transY;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    @Override
    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    @Override
    public float getScaleX() {
        return this.scaleX;
    }

    @Override
    public float getScaleY() {
        return this.scaleY;
    }

    @Override
    public void setRotation(float rotation) {
    }

    @Override
    public float getRotation() {
        return 0.0f;
    }

    public void onTextureDraw(GlAnimationView gl, int z) {
        if (!this.isVisible || this.mNumberImage == null) {
            return;
        }
        float left = 0.0f;
        float scaleLeft = (float)this.width * (1.0f - this.scaleX) / 2.0f;
        for (int i = 0; i < this.mNumberImage.length; ++i) {
            GlImageTarget target = this.mNumberImage[i];
            if (target == null) continue;
            target.setScaleX(this.scaleX);
            float mid = left + (float)(target.getWidth() / 2);
            float scaleMid = scaleLeft + (float)target.getWidth() * this.scaleX / 2.0f;
            target.setTranslationX(this.transX + (scaleMid - mid));
            target.setTranslationY(this.transY);
            target.setScaleY(this.scaleY);
            target.setAlpha(this.alpha);
            target.onTextureDraw(gl, z);
            left += (float)target.getWidth();
            scaleLeft += (float)target.getWidth() * this.scaleX;
        }
    }
}

