/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation;

import android.animation.ValueAnimator;
import android.graphics.PointF;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.ImageTarget;

public class SinPathUpdateListener
implements ValueAnimator.AnimatorUpdateListener {
    private ImageTarget target;
    private float alphaValue;
    private PointF mLastPointF;
    private float scaleValue;
    private float scaleRadio;
    private float currScale;

    public SinPathUpdateListener(ImageTarget target, float initAlphaValue, float lScaleRadio) {
        this.target = target;
        this.alphaValue = initAlphaValue;
        this.scaleValue = target.getScaleX();
        this.scaleRadio = lScaleRadio;
    }

    public void onAnimationUpdate(ValueAnimator valueAnimator) {
        float animatedFraction = valueAnimator.getAnimatedFraction();
        PointF pointF = (PointF)valueAnimator.getAnimatedValue();
        float x = pointF.x;
        float y = pointF.y;
        this.target.setX(x);
        this.target.setY(y);
        float curAnimTimeRadio = 1.0f - animatedFraction;
        float alpha = (double)curAnimTimeRadio < 0.5 ? this.alphaValue * 2.0f * curAnimTimeRadio : this.alphaValue;
        this.target.setAlpha(alpha);
        if (this.currScale < 1.0f) {
            this.currScale = this.scaleValue + this.scaleRadio * animatedFraction;
            this.target.setScaleX(this.currScale);
            this.target.setScaleY(this.currScale);
        }
        if (this.mLastPointF != null) {
            float xDiff = pointF.x - this.mLastPointF.x;
            float yDiff = Math.abs(pointF.y - this.mLastPointF.y);
            if (Math.abs(yDiff) > 2.0f) {
                double rotation = Math.atan(yDiff / xDiff) * 180.0 / Math.PI;
                rotation = rotation < 0.0 ? -(rotation + 90.0) : 90.0 - rotation;
                this.target.setRotation((float)rotation);
                this.mLastPointF = pointF;
            }
        } else {
            this.mLastPointF = pointF;
        }
    }
}

