/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.danmaku;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.danmaku.BarrageTypeEntity;
import com.yy.mobile.util.StringUtils;
import java.util.ArrayList;

public class BarrageTypeAdapter
extends RecyclerView.Adapter<MyHolder> {
    private ArrayList<BarrageTypeEntity> mData;
    private int currentSelectPosition = 0;
    private OnItemClickListener onItemClickListener = null;

    public BarrageTypeAdapter(ArrayList<BarrageTypeEntity> mData) {
        this.mData = mData;
    }

    @NonNull
    public MyHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new MyHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.meipai_layout_barrage_type, parent, false));
    }

    public void onBindViewHolder(@NonNull MyHolder holder, int position) {
        final int currentPosition = position;
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BarrageTypeAdapter.this.onItemClickListener != null) {
                    BarrageTypeAdapter.this.onItemClickListener.onItemClick(v, currentPosition);
                }
            }
        });
        BarrageTypeEntity entity = this.mData.get(position);
        String text = StringUtils.safeParseInt((String)entity.getRemain_num()) > 0 ? entity.getBs_label() + "x" + entity.getRemain_num() : entity.getBs_label();
        holder.textView.setText((CharSequence)text);
        if (entity.isColorfulStyle()) {
            holder.textView.setBackgroundResource(R.drawable.meipai_selector_bg_barrage_type_special);
        } else {
            holder.textView.setBackgroundResource(R.drawable.meipai_selector_bg_barrage_type);
        }
        if (this.currentSelectPosition == position) {
            holder.textView.setSelected(true);
            holder.textView.setTextColor(entity.isColorfulStyle() ? -1 : -243098);
        } else {
            holder.textView.setSelected(false);
            holder.textView.setTextColor(-4473925);
        }
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public void setCurrentSelectPosition(int currentSelectPosition) {
        this.currentSelectPosition = currentSelectPosition;
    }

    public int getCurrentSelectPosition() {
        return this.currentSelectPosition;
    }

    public BarrageTypeEntity getCurrentEntity() {
        return this.mData.get(this.currentSelectPosition);
    }

    public void checkCurrentPosition() {
        if (this.currentSelectPosition >= this.mData.size()) {
            this.currentSelectPosition = 0;
            this.notifyDataSetChanged();
        }
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }

    class MyHolder
    extends RecyclerView.ViewHolder {
        TextView textView;

        public MyHolder(View view) {
            super(view);
            this.textView = (TextView)view.findViewById(R.id.tv_barrage_type_name);
        }
    }
}

