/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.popularity;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import com.unionyy.mobile.meipai.api.YY2MPBindingPhoneAction;
import com.unionyy.mobile.meipai.config.data.MPExtensibleComponentConfig;
import com.unionyy.mobile.meipai.gift.core.IMPGiftCore;
import com.unionyy.mobile.meipai.gift.core.event.PopularityGiftNumberChangeEvent;
import com.unionyy.mobile.meipai.pk.utils.TimeUtil;
import com.unionyy.mobile.meipai.popularity.api.IMeiPaiCallApi;
import com.unionyy.mobile.meipai.popularity.api.MeiPaiCallApiProtocols;
import com.unionyy.mobile.meipai.popularity.control.CallGiveController;
import com.unionyy.mobile.meipai.popularity.control.CallTimer;
import com.unionyy.mobile.meipai.popularity.control.CallTipsController;
import com.unionyy.mobile.meipai.popularity.control.ICallProgressCallBack;
import com.unionyy.mobile.meipai.popularity.control.ICallSendCallBack;
import com.unionyy.mobile.meipai.popularity.dialog.CommonDialog;
import com.unionyy.mobile.meipai.popularity.model.PopularityGiftModel;
import com.unionyy.mobile.meipai.popularity.view.CallView;
import com.unionyy.mobile.spdt.annotation.MEIPAI;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.replugin.ApiBridge;
import com.yy.mobile.ui.gift.GiftHelper;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.statistic.IHiidoStatisticNewCore;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class CallManager {
    private static final String TAG = "CallManager";
    private CallView mCallView;
    private volatile PopularityGiftModel mPopularityGiftModel = new PopularityGiftModel();
    private CallGiveController mCallGiveController;
    private boolean isDestroy;
    private CallTipsController mCallTipsController;
    private CallTimer mCallTimer;
    private FragmentActivity baseActivity;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();
    private boolean isFirstCome = true;
    private Toast toast;
    private boolean respRetry = false;
    public static final ArrayList<String> tipList = new ArrayList<String>(Arrays.asList("\u767b\u5f55\u540e\u53ef\u514d\u8d39\u9886\u793c\u7269\uff5e\uff5e", "\u89c2\u770b2\u5206\u949f\u53ef\u9886\u793c\u7269\uff0c\u5e2e\u4e3b\u64ad\u52a0\u4eba\u6c14\u4e0a\u70ed\u95e8\uff080\u70b9\u6e05\u7a7a\uff09", "\u606d\u559c\u83b7\u5f97\u4eba\u6c14\u793c\u7269\uff0c\u5feb\u9001\u51fa\u5e2e\u4e3b\u64ad\u52a0\u4eba\u6c14\u4e0a\u70ed\u95e8\u5427\uff01", "\u4eca\u65e5\u4eba\u6c14\u793c\u7269\u5df2\u9886\u5b8c\uff0c\u660e\u5929\u518d\u6765\u54e6~"));
    public static final MPExtensibleComponentConfig extensibleConfig = new MPExtensibleComponentConfig(1003, "\u6253call", null, 3, 4, 5, 500, null, null, 99);
    private long combos_live_time_line = -1L;
    private int mComboNumber = 0;

    public void initView(final FragmentActivity baseActivity, FrameLayout callLayout) {
        this.baseActivity = baseActivity;
        this.mCallView = new CallView((Context)baseActivity);
        callLayout.addView((View)this.mCallView);
        this.mCallView.setVisibility(8);
        this.mCallView.getRlProgressIconWrap().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MLog.info((Object)CallManager.TAG, (String)("callView onClick() called with: v = [" + v + "]"), (Object[])new Object[0]);
                if (!LoginUtil.isLogined()) {
                    CallManager.this.dismissTips();
                    if (TimeUtil.isFastClick()) {
                        LoginUtil.showLoginDialog((Context)baseActivity);
                    }
                } else {
                    if (CallManager.this.mPopularityGiftModel.getGiftId() <= 0) {
                        if (CallManager.this.toast != null) {
                            CallManager.this.toast.cancel();
                        }
                        CallManager.this.toast = Toast.makeText((Context)baseActivity, (CharSequence)"\u6682\u672a\u83b7\u5f97\u6570\u636e\uff0c\u8bf7\u7a0d\u7b49\uff01", (int)0);
                        CallManager.this.toast.show();
                        return;
                    }
                    if (((CallManager)CallManager.this).mPopularityGiftModel.userGiftNum > 0) {
                        CallManager.this.dismissTips();
                        CallManager.this.giveToAnchor(false);
                    } else if (CallManager.this.mPopularityGiftModel.isRequestIsCallBack()) {
                        if (CallManager.this.mPopularityGiftModel.getAllowGetCount() == 0) {
                            CallManager.this.mCallTipsController.showPopularityGiftUseUp();
                        } else {
                            CallManager.this.mCallTipsController.showHaveNoPopularityTips();
                        }
                    } else {
                        if (CallManager.this.toast != null) {
                            CallManager.this.toast.cancel();
                        }
                        CallManager.this.toast = Toast.makeText((Context)baseActivity, (CharSequence)"\u6682\u672a\u83b7\u5f97\u6570\u636e\uff0c\u8bf7\u7a0d\u7b49\uff01", (int)0);
                        CallManager.this.toast.show();
                    }
                }
                ((IHiidoStatisticNewCore)ICoreManagerBase.getCore(IHiidoStatisticNewCore.class)).sendEventStatistic(MEIPAI.class, "10101", "0004", null);
            }
        });
        this.initTipAndSendControl();
        this.getCallInfo();
        if (!LoginUtil.isLogined()) {
            this.mCallView.setVisibility(0);
            this.mCallTipsController.showUnLoginTips();
        }
    }

    public void getCallInfo() {
        MLog.info((Object)TAG, (String)("callView getCallInfo() called loginStatus:" + LoginUtil.isLogined()), (Object[])new Object[0]);
        if (!LoginUtil.isLogined()) {
            this.mCallView.setNum(-1);
            return;
        }
        this.compositeDisposable.add(((IMeiPaiCallApi)ICoreManagerBase.getCore(IMeiPaiCallApi.class)).getCallInfo(0).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MeiPaiCallApiProtocols.MeiPaiCallInfoRsp>(){

            public void accept(MeiPaiCallApiProtocols.MeiPaiCallInfoRsp resp) {
                MLog.info((Object)CallManager.TAG, (String)("getCallInfo accept = " + resp), (Object[])new Object[0]);
                CallManager.this.mPopularityGiftModel.update(resp);
                if (CallManager.this.isDestroy()) {
                    return;
                }
                CallManager.this.fillCallInfo();
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)CallManager.TAG, (String)("getCallInfo throwable = " + throwable), (Object[])new Object[0]);
                if (CallManager.this.isDestroy()) {
                    return;
                }
            }
        }));
    }

    public void increaseCallInfo() {
        if (!LoginUtil.isLogined()) {
            return;
        }
        this.compositeDisposable.add(((IMeiPaiCallApi)ICoreManagerBase.getCore(IMeiPaiCallApi.class)).getCallInfo(this.mPopularityGiftModel.giftId).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MeiPaiCallApiProtocols.MeiPaiCallInfoRsp>(){

            public void accept(MeiPaiCallApiProtocols.MeiPaiCallInfoRsp resp) {
                MLog.info((Object)CallManager.TAG, (String)("increaseCallInfo accept = " + resp), (Object[])new Object[0]);
                CallManager.this.mPopularityGiftModel.update(resp);
                if (CallManager.this.isDestroy()) {
                    return;
                }
                CallManager.this.startScaleAnim();
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)CallManager.TAG, (String)("getCallInfo throwable = " + throwable), (Object[])new Object[0]);
                if (CallManager.this.isDestroy()) {
                    return;
                }
                CallManager.this.fillCallInfo();
            }
        }));
    }

    public void retryCallInfo() {
        this.fillCallInfo();
    }

    private void giveToAnchor(boolean isCombos) {
        if (!((YY2MPBindingPhoneAction)ApiBridge.INSTANCE.getApi(YY2MPBindingPhoneAction.class)).isUserBindingPhone()) {
            CommonDialog pkAnchorDialog = new CommonDialog((Context)this.baseActivity);
            pkAnchorDialog.setDialogCallBack(new CommonDialog.DialogCallBack(){

                @Override
                public void onCancle() {
                }

                @Override
                public void onSure() {
                    ((YY2MPBindingPhoneAction)ApiBridge.INSTANCE.getApi(YY2MPBindingPhoneAction.class)).onUIBindingPhone((Context)CallManager.this.baseActivity);
                }
            });
            pkAnchorDialog.show();
        } else {
            MLog.info((Object)TAG, (String)("callView giveToAnchor() called with: isCombos = [" + isCombos + "]"), (Object[])new Object[0]);
            long t = System.currentTimeMillis();
            if (!isCombos) {
                this.combos_live_time_line = t;
            }
            Long toUid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
            HashMap<String, String> extendInfo = new HashMap<String, String>();
            ((IMPGiftCore)ICoreManagerBase.getCore(IMPGiftCore.class)).sendPackageGift(this.mPopularityGiftModel.giftId, toUid, 1, extendInfo);
            if (this.mCallGiveController != null) {
                this.mCallGiveController.changeToCombo(true);
            }
        }
    }

    public void login() {
        MLog.info((Object)TAG, (String)"callView login() called", (Object[])new Object[0]);
        this.mCallTipsController.clearUnloinTipsMessage();
        this.isFirstCome = true;
        this.getCallInfo();
    }

    public void switchLiveRoom(boolean pre) {
        if (this.mCallGiveController != null) {
            this.mCallGiveController.changeToCombo(false);
        }
        this.dismissTips();
    }

    public void destroy() {
        MLog.info((Object)TAG, (String)"destroy", (Object[])new Object[0]);
        if (this.toast != null) {
            this.toast.cancel();
        }
        this.isDestroy = true;
        this.baseActivity = null;
        this.mCallView = null;
        if (this.mCallTimer != null) {
            this.mCallTimer.destroy();
        }
        this.compositeDisposable.clear();
        this.mCallTipsController.clearHandleMessage();
    }

    private void dismissTips() {
        this.mCallTipsController.dismiss();
    }

    private boolean isDestroy() {
        return this.isDestroy;
    }

    private void initTipAndSendControl() {
        this.mCallTipsController = new CallTipsController(this.baseActivity, this.mCallView, tipList);
        this.mCallGiveController = new CallGiveController(this.baseActivity, this.mCallView, new ICallSendCallBack(){

            @Override
            public void doSend() {
                CallManager.this.giveToAnchor(true);
            }
        });
    }

    private void startScaleAnim() {
        this.mCallView.startAnimation((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (CallManager.this.isDestroy()) {
                    return;
                }
                CallManager.this.fillCallInfo();
                CallManager.this.mCallTipsController.showFirstGetTips();
            }
        });
    }

    private void fillCallInfo() {
        boolean isLoad = this.mCallView.setIConUrl(this.mPopularityGiftModel.giftId);
        if (!isLoad) {
            this.respRetry = true;
            return;
        }
        this.respRetry = false;
        this.mCallView.setNum(this.mPopularityGiftModel.userGiftNum);
        this.mCallView.setProgress(0);
        if (this.mPopularityGiftModel.getAllowGetCount() > 0) {
            this.startCallTimer();
        }
        if (this.mPopularityGiftModel.getAllowGetCount() > 0 || this.mPopularityGiftModel.getUserGiftNum() > 0) {
            this.mCallView.setVisibility(0);
            MLog.debug((Object)TAG, (String)"fillCallInfo VISIBLE ", (Object[])new Object[0]);
        } else {
            MLog.debug((Object)TAG, (String)"fillCallInfo finish ", (Object[])new Object[0]);
            if (this.mPopularityGiftModel.getUserGiftNum() == 0 && this.mCallTipsController != null && !this.isFirstCome) {
                this.mCallTipsController.showPopularityGiftUseUp();
            } else {
                MLog.debug((Object)TAG, (String)"fillCallInfo gone ", (Object[])new Object[0]);
                this.mCallView.setVisibility(8);
            }
        }
        this.isFirstCome = false;
    }

    private void startCallTimer() {
        if (this.mCallTimer == null) {
            this.mCallTimer = new CallTimer(new ICallProgressCallBack(){

                @Override
                public void progress(float progress) {
                    if (CallManager.this.mCallView != null) {
                        CallManager.this.mCallView.setProgress((int)((float)CallManager.this.mCallView.getMaxProgress() * progress));
                    }
                }

                @Override
                public void end() {
                    CallManager.this.increaseCallInfo();
                }
            });
        }
        this.mCallTimer.start();
    }

    public void onCallGiveResponse(PopularityGiftNumberChangeEvent event) {
        Log.d((String)TAG, (String)("callView onCallGiveResponse() called with: event = [" + event + "]"));
        if (this.isDestroy() || event == null) {
            return;
        }
        int resultCode = event.getResultCode();
        if (resultCode == 0) {
            this.mPopularityGiftModel.setUserGiftNum(event.getResultNumber());
        } else if (resultCode == GiftHelper.FREE_GIFT_PROPS_NOT_ENOUGH.intValue()) {
            if (this.mCallGiveController != null) {
                this.mCallGiveController.OnCombosStop();
            }
            this.mPopularityGiftModel.setUserGiftNum(0);
        }
        this.fillCallInfo();
    }

    public void setClearSceenState(boolean isState) {
        if (this.mCallTipsController != null) {
            this.mCallTipsController.isClearScreenState = isState;
            if (isState && this.mCallTipsController.isShowing()) {
                this.mCallTipsController.clearHandleMessage();
            }
        }
    }
}

