/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.core.IMeiPaiPkCore;
import com.unionyy.mobile.meipai.pk.core.MeiPaiPkProtocols;
import com.unionyy.mobile.meipai.pk.ui.dialog.Adapter.MeiPaiPKInviteOrientRecyclerAdapter;
import com.unionyy.mobile.meipai.pk.ui.dialog.Adapter.Model.MeiPaiPKInviteOrientRecyclerAdapterInfo;
import com.unionyy.mobile.meipai.pk.ui.dialog.DialogManager;
import com.unionyy.mobile.meipai.pk.ui.dialog.MeiPaiBottomComponentDialog;
import com.unionyy.mobile.meipai.pk.ui.dialog.MeiPaiPKInviteOriented;
import com.unionyy.mobile.meipai.pk.ui.model.PkStatusInfo;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Map;

public class MeiPaiPKInviteSearchDialog
extends MeiPaiBottomComponentDialog {
    private static final String TAG = "MeiPaiPKInviteSearchFragment";
    private View searchBaseView;
    private EditText searchView;
    private TextView loadingTextView;
    private View rootView;
    private boolean isLoading = false;
    private MeiPaiPKInviteOrientRecyclerAdapter recyclerAdapter;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();

    @Override
    public int getLayoutId() {
        return R.layout.meipai_fragment_pk_invite_search;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog2 = super.onCreateDialog(savedInstanceState);
        Window dialogWindow = dialog2.getWindow();
        dialogWindow.setLayout(-1, -1);
        return dialog2;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.rootView = view.findViewById(R.id.meipai_pk_invate_oriented_search_linearlayout);
        this.initListener();
        this.searchBaseView = view;
        this.searchView = (EditText)view.findViewById(R.id.meipai_pk_invate_oriented_searchView);
        this.loadingTextView = (TextView)view.findViewById(R.id.meipai_pk_invate_search_loading_textView);
        final ImageView searchClose = (ImageView)view.findViewById(R.id.meipai_pk_invate_oriented_searchclose);
        TextView searchCancel = (TextView)view.findViewById(R.id.meipai_pk_invate_oriented_searchcancel);
        Button searchBack = (Button)view.findViewById(R.id.meipai_pk_invate_oriented_search_back_button);
        searchBack.setVisibility(8);
        this.initRecyclerView();
        searchCancel.setVisibility(0);
        searchCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (((MeiPaiPKInviteSearchDialog)MeiPaiPKInviteSearchDialog.this).recyclerAdapter.isActionStateStart) {
                    Toast.makeText((Context)MeiPaiPKInviteSearchDialog.this.getContext(), (CharSequence)"\u6b63\u5728\u53d1\u8d77PK\u4e2d\uff0c\u8bf7\u7a0d\u5019", (int)0).show();
                } else {
                    InputMethodManager imm = (InputMethodManager)MeiPaiPKInviteSearchDialog.this.getContext().getSystemService("input_method");
                    if (imm != null) {
                        imm.hideSoftInputFromWindow(MeiPaiPKInviteSearchDialog.this.searchView.getWindowToken(), 0);
                    }
                    DialogManager.getInstence().dismissAllPopupComponents(MeiPaiPKInviteSearchDialog.this.getActivity());
                    DialogManager.getInstence().showPopupComponent(new MeiPaiPKInviteOriented(), MeiPaiPKInviteSearchDialog.this.getActivity());
                }
            }
        });
        this.searchView.setFocusable(true);
        this.searchView.setFocusableInTouchMode(true);
        this.searchView.requestFocus();
        this.searchView.findFocus();
        this.searchView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start2, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start2, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s != null && s.length() != 0) {
                    searchClose.setVisibility(0);
                } else {
                    searchClose.setVisibility(8);
                }
            }
        });
        this.searchView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 3) {
                    if (v.getText() != null && v.getText().length() != 0) {
                        MeiPaiPKInviteSearchDialog.this.initData();
                        InputMethodManager imm = (InputMethodManager)MeiPaiPKInviteSearchDialog.this.getContext().getSystemService("input_method");
                        if (imm != null) {
                            imm.hideSoftInputFromWindow(MeiPaiPKInviteSearchDialog.this.searchView.getWindowToken(), 0);
                        }
                        MeiPaiPKInviteSearchDialog.this.searchView.clearFocus();
                    } else {
                        MeiPaiPKInviteSearchDialog.this.showTips("\u8f93\u5165\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    return true;
                }
                return false;
            }
        });
        searchClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MeiPaiPKInviteSearchDialog.this.searchView.setText((CharSequence)"");
                MeiPaiPKInviteSearchDialog.this.recyclerAdapter.cleanData();
                MeiPaiPKInviteSearchDialog.this.recyclerAdapter.notifyDataSetChanged();
                MeiPaiPKInviteSearchDialog.this.loadingTextView.setVisibility(8);
            }
        });
    }

    @Override
    protected void onPkStatusEvent(PkStatusInfo info) {
        super.onPkStatusEvent(info);
        if (info.type == 2) {
            if (info.result == 2 || info.result == 3) {
                if (!FP.empty((CharSequence)info.errDesc)) {
                    Toast.makeText((Context)this.getContext(), (CharSequence)info.errDesc, (int)0).show();
                }
                this.recyclerAdapter.isActionStateStart = false;
                ArrayList<MeiPaiPKInviteOrientRecyclerAdapterInfo> recommendArray = this.recyclerAdapter.getData();
                for (MeiPaiPKInviteOrientRecyclerAdapterInfo recommendInfo : recommendArray) {
                    if (recommendInfo.uid != info.ivOpponentUid) continue;
                    recommendInfo.userState = MeiPaiPKInviteOrientRecyclerAdapter.UserState.PK_START;
                    break;
                }
                this.recyclerAdapter.onInVitedStateChange();
            }
        } else if (info.type == 4 || info.type == 5) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"\u5bf9\u65b9\u540c\u610f\u4e86\u4f60\u7684PK\u9080\u8bf7", (int)0).show();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.compositeDisposable.dispose();
        this.recyclerAdapter.onDestory();
    }

    private void initListener() {
        this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog2, int keyCode, KeyEvent event) {
                if (keyCode == 4 && ((MeiPaiPKInviteSearchDialog)MeiPaiPKInviteSearchDialog.this).recyclerAdapter.isActionStateStart) {
                    Toast.makeText((Context)MeiPaiPKInviteSearchDialog.this.getContext(), (CharSequence)"\u6b63\u5728\u53d1\u8d77PK\u4e2d\uff0c\u8bf7\u7a0d\u5019", (int)0).show();
                    return true;
                }
                return false;
            }
        });
        this.rootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                InputMethodManager imm = (InputMethodManager)MeiPaiPKInviteSearchDialog.this.getContext().getSystemService("input_method");
                if (imm != null) {
                    imm.hideSoftInputFromWindow(MeiPaiPKInviteSearchDialog.this.searchView.getWindowToken(), 0);
                }
                if (((MeiPaiPKInviteSearchDialog)MeiPaiPKInviteSearchDialog.this).recyclerAdapter.isActionStateStart) {
                    Toast.makeText((Context)MeiPaiPKInviteSearchDialog.this.getContext(), (CharSequence)"\u6b63\u5728\u53d1\u8d77PK\u4e2d\uff0c\u8bf7\u7a0d\u5019", (int)0).show();
                } else {
                    MeiPaiPKInviteSearchDialog.this.hide();
                }
            }
        });
    }

    private void initRecyclerView() {
        MeiPaiPKInviteOrientRecyclerAdapter adapter;
        RecyclerView recyclerView = (RecyclerView)this.searchBaseView.findViewById(R.id.meipai_pk_invate_search_recyclerView);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerAdapter = adapter = new MeiPaiPKInviteOrientRecyclerAdapter(recyclerView, this.getActivity());
        recyclerView.setAdapter((RecyclerView.Adapter)adapter);
    }

    private void initData() {
        this.recyclerAdapter.cleanData();
        this.recyclerAdapter.notifyDataSetChanged();
        if (this.isLoading) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"\u6b63\u5728\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e", (int)0).show();
            return;
        }
        this.isLoading = true;
        this.loadingTextView.setText((CharSequence)"\u52aa\u529b\u641c\u7d22\u4e2d...");
        this.loadingTextView.setVisibility(0);
        final ArrayList arrayList = new ArrayList();
        Disposable disposable = ((IMeiPaiPkCore)CoreFactory.getCore(IMeiPaiPkCore.class)).reqPkSearchFriend(this.searchView.getText().toString()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MeiPaiPkProtocols.PMeipaiPKSearchFriendRsp>(){

            public void accept(MeiPaiPkProtocols.PMeipaiPKSearchFriendRsp rsp) throws Exception {
                MeiPaiPKInviteSearchDialog.this.isLoading = false;
                if (rsp.result.intValue() == 0) {
                    if (rsp.dataset.size() == 0) {
                        MeiPaiPKInviteSearchDialog.this.loadingTextView.setText((CharSequence)"\u672a\u641c\u7d22\u5230\u8be5\u7528\u6237");
                    } else {
                        MeiPaiPKInviteSearchDialog.this.loadingTextView.setVisibility(8);
                        for (Map<String, String> tmp : rsp.dataset) {
                            MeiPaiPKInviteOrientRecyclerAdapterInfo info = new MeiPaiPKInviteOrientRecyclerAdapterInfo();
                            info.uid = StringUtils.safeParseLong((String)tmp.get("uid"));
                            info.imageURL = tmp.get("head_url");
                            info.name = tmp.get("name");
                            info.sex = StringUtils.safeParseInt((String)tmp.get("gender"));
                            info.userState = MeiPaiPKInviteOrientRecyclerAdapter.UserState.init(StringUtils.safeParseInt((String)tmp.get("status")));
                            arrayList.add(info);
                        }
                        MeiPaiPKInviteSearchDialog.this.recyclerAdapter.setData(arrayList);
                        MeiPaiPKInviteSearchDialog.this.recyclerAdapter.notifyDataSetChanged();
                    }
                } else {
                    MeiPaiPKInviteSearchDialog.this.loadingTextView.setText((CharSequence)"\u52a0\u8f7d\u5931\u8d25");
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)MeiPaiPKInviteSearchDialog.TAG, (String)("[PK] PMeipaiPKFriendRsp throwable = " + throwable), (Object[])new Object[0]);
                MeiPaiPKInviteSearchDialog.this.isLoading = false;
                MeiPaiPKInviteSearchDialog.this.loadingTextView.setText((CharSequence)"\u7f51\u7edc\u5f02\u5e38,\u8bf7\u91cd\u8bd5");
            }
        });
        this.compositeDisposable.add(disposable);
    }
}

