/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view.guard;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.unionyy.mobile.meipai.gift.animation.view.guard.HeartBezierEvaluator;
import java.util.Random;

@SuppressLint(value={"MissingBraces"})
public class GuardLoveHeartView
extends RelativeLayout {
    private final int ENTER_DURATION = 200;
    private final int BUBBLE_DURATION = 2000;
    private Interpolator linearInterpolator = new LinearInterpolator();
    private Interpolator accelerateInterpolator = new AccelerateInterpolator();
    private Interpolator decelerateInterpolator = new DecelerateInterpolator();
    private Interpolator accelerateDecelerateInterpolator = new AccelerateDecelerateInterpolator();
    private Interpolator[] interpolatorArray;
    private final float controlPointScale = 0.15f;
    private final float deviationScale = 0.05f;
    private int deviation;
    private int mHeight;
    private int mWidth;
    private RelativeLayout.LayoutParams layoutParams;
    private Drawable drawableBubble;
    private Random random = new Random();
    private int heartHeight;
    private int heartWidth;
    private Runnable addHeartRunnable = new Runnable(){

        @Override
        public void run() {
            GuardLoveHeartView.this.addHeart();
        }
    };

    public GuardLoveHeartView(Context context) {
        super(context);
        this.init();
    }

    public GuardLoveHeartView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GuardLoveHeartView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.drawableBubble = this.getResources().getDrawable(R.drawable.live_guard_love_bubble);
        this.heartHeight = DeviceUtils.dip2px(24.7f);
        this.heartWidth = DeviceUtils.dip2px(29.0f);
        this.layoutParams = new RelativeLayout.LayoutParams(this.heartWidth, this.heartHeight);
        this.layoutParams.addRule(12, -1);
        this.interpolatorArray = new Interpolator[4];
        this.interpolatorArray[0] = this.linearInterpolator;
        this.interpolatorArray[1] = this.accelerateInterpolator;
        this.interpolatorArray[2] = this.decelerateInterpolator;
        this.interpolatorArray[3] = this.accelerateDecelerateInterpolator;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
        this.deviation = (int)((float)this.mWidth * 0.05f);
        this.layoutParams.leftMargin = (this.mWidth - this.heartWidth) / 2 - this.deviation;
    }

    public void startHeartAnimation() {
        if (this.getHandler() == null) {
            return;
        }
        this.removeAllViews();
        this.addHeart();
        this.getHandler().removeCallbacks(this.addHeartRunnable);
        this.getHandler().postDelayed(this.addHeartRunnable, 100L);
        this.getHandler().postDelayed(this.addHeartRunnable, 200L);
        this.getHandler().postDelayed(this.addHeartRunnable, 400L);
        this.getHandler().postDelayed(this.addHeartRunnable, 550L);
        this.getHandler().postDelayed(this.addHeartRunnable, 750L);
        this.getHandler().postDelayed(this.addHeartRunnable, 850L);
        this.getHandler().postDelayed(this.addHeartRunnable, 1000L);
        this.getHandler().postDelayed(this.addHeartRunnable, 1200L);
        this.getHandler().postDelayed(this.addHeartRunnable, 1400L);
    }

    private void addHeart() {
        ImageView imageView = new ImageView(this.getContext());
        imageView.setImageDrawable(this.drawableBubble);
        imageView.setLayoutParams((ViewGroup.LayoutParams)this.layoutParams);
        this.addView((View)imageView);
        Animator set = this.getAnimator((View)imageView);
        set.addListener((Animator.AnimatorListener)new AnimEndListener((View)imageView));
        set.start();
    }

    private Animator getAnimator(View target) {
        AnimatorSet set = this.getEnterAnimator(target);
        ValueAnimator bezierValueAnimator = this.getBezierValueAnimator(target);
        AnimatorSet finalSet = new AnimatorSet();
        finalSet.playSequentially(new Animator[]{set});
        finalSet.playTogether(new Animator[]{set, bezierValueAnimator});
        finalSet.setInterpolator((TimeInterpolator)this.interpolatorArray[this.random.nextInt(4)]);
        finalSet.setTarget((Object)target);
        return finalSet;
    }

    private AnimatorSet getEnterAnimator(View target) {
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (Property)View.ALPHA, (float[])new float[]{(float)(2 + this.random.nextInt(8)) / 10.0f, 1.0f});
        float scale = (float)(7 + this.random.nextInt(4)) / 10.0f;
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)target, (Property)View.SCALE_X, (float[])new float[]{0.2f, scale});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)target, (Property)View.SCALE_Y, (float[])new float[]{0.2f, scale});
        AnimatorSet enter = new AnimatorSet();
        enter.setDuration(200L);
        enter.setInterpolator((TimeInterpolator)new LinearInterpolator());
        enter.playTogether(new Animator[]{alpha, scaleX, scaleY});
        enter.setTarget((Object)target);
        return enter;
    }

    private ValueAnimator getBezierValueAnimator(View target) {
        HeartBezierEvaluator evaluator = new HeartBezierEvaluator(this.getPointF(2), this.getPointF(1));
        PointF startPoint = new PointF((float)this.layoutParams.leftMargin, (float)(this.mHeight - this.heartHeight));
        PointF endPoint = new PointF((float)(this.getWidth() / 2 - this.deviation - this.heartWidth + this.random.nextInt(this.heartHeight * 2)), 0.0f);
        ValueAnimator animator = ValueAnimator.ofObject((TypeEvaluator)evaluator, (Object[])new Object[]{startPoint, endPoint});
        animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new BezierListener(target));
        animator.setTarget((Object)target);
        animator.setDuration(2000L);
        return animator;
    }

    private PointF getPointF(int scale) {
        PointF pointF = new PointF();
        if (this.mWidth == 0 || this.mHeight == 0) {
            return pointF;
        }
        pointF.x = (float)(this.mWidth / 2) - (float)this.mWidth * 0.15f - (float)this.deviation + (float)this.random.nextInt((int)((float)this.mWidth * 0.15f * 2.0f));
        pointF.y = this.random.nextInt(this.mHeight - 100) / scale;
        return pointF;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacks(this.addHeartRunnable);
        }
    }

    private class AnimEndListener
    extends AnimatorListenerAdapter {
        private View target;

        AnimEndListener(View target) {
            this.target = target;
        }

        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
            GuardLoveHeartView.this.removeView(this.target);
        }
    }

    private class BezierListener
    implements ValueAnimator.AnimatorUpdateListener {
        private View target;

        BezierListener(View target) {
            this.target = target;
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            PointF pointF = (PointF)animation.getAnimatedValue();
            this.target.setX(pointF.x);
            this.target.setY(pointF.y);
            this.target.setAlpha(1.0f - animation.getAnimatedFraction());
        }
    }
}

