/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view.guard;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;

@SuppressLint(value={"MissingBraces"})
public class GuardLightView
extends View {
    private final int alphaTime = 500;
    private final int DELAY_DURATION = 25;
    private Paint paint;
    private Rect srcRect = new Rect();
    private Rect targetRect = new Rect();
    private Bitmap bitmap;
    private float rotate = 0.0f;
    private float currentAlpha = 0.0f;
    private Runnable drawRunnable = new Runnable(){

        @Override
        public void run() {
            GuardLightView.this.invalidate();
        }
    };

    public GuardLightView(Context context) {
        super(context);
        this.init();
    }

    public GuardLightView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GuardLightView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.bitmap == null) {
            return;
        }
        if (this.currentAlpha < 255.0f) {
            this.currentAlpha += 12.75f;
            this.paint.setAlpha((int)this.currentAlpha);
        }
        canvas.rotate(this.rotate, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        this.rotate += 1.0f;
        if (this.rotate > 360.0f) {
            this.rotate = 1.0f;
        }
        this.targetRect.set(0, 0, this.getWidth(), this.getHeight());
        this.srcRect.set(0, 0, this.bitmap.getWidth(), this.bitmap.getHeight());
        canvas.drawBitmap(this.bitmap, this.srcRect, this.targetRect, this.paint);
        this.removeOrPostMessage(true);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.removeOrPostMessage(visibility == 0);
        if (visibility == 0) {
            this.currentAlpha = 0.0f;
        }
    }

    private void removeOrPostMessage(boolean isPost) {
        if (this.getHandler() == null) {
            return;
        }
        this.getHandler().removeCallbacks(this.drawRunnable);
        if (isPost) {
            this.getHandler().postDelayed(this.drawRunnable, 25L);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Glide.with((View)this).asBitmap().load("http://mpstatic.bs2cdn.yy.com/live_guard_love_light.png?id=4620").into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                GuardLightView.this.bitmap = resource;
                GuardLightView.this.invalidate();
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeOrPostMessage(false);
        this.getHandler().removeCallbacksAndMessages(null);
    }
}

