/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.utils.BitmapUtil;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;

public class LiveUserInLightAnimView
extends View {
    private static final String TAG = "LiveUserInLightAnimView";
    private static final int INVALIDATE_FRAME_RATE = 30;
    private float mRectRadicus = 5.0f;
    private int mDefaultStartPos = -24;
    private int mLiveVipEnterLightHeight;
    private long mLastAnimationStartTime;
    private Bitmap mLightBitmap;
    private boolean mDoLightAnim = false;
    private int mLightPos = this.mDefaultStartPos;
    private float mLightSpeed = 0.0f;
    private Paint mLightPaint;
    private Path mPath = new Path();
    private RectF mViewBound;

    public LiveUserInLightAnimView(Context context) {
        super(context);
        this.init();
    }

    public LiveUserInLightAnimView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mLiveVipEnterLightHeight = (int)this.getResources().getDimension(R.dimen.meipai_live_event_vip_enter_item_height);
        this.mRectRadicus = TypedValue.applyDimension((int)1, (float)this.mRectRadicus, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mDefaultStartPos = (int)TypedValue.applyDimension((int)1, (float)this.mDefaultStartPos, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mLightBitmap = BitmapUtil.drawable2Bitmap(this.getResources().getDrawable(R.drawable.meipai_live_ic_white_light));
        this.mLightSpeed = (float)DeviceUtils.getScreenWidth() / 1000.0f;
        this.mLightPaint = new Paint(1);
        this.setLayerType(1, null);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDoLightAnim) {
            if (this.mLastAnimationStartTime <= 0L) {
                this.mLastAnimationStartTime = System.currentTimeMillis();
                this.mLightPos = this.mDefaultStartPos;
            } else {
                long tempAnimTime = System.currentTimeMillis();
                this.mLightPos = (int)((float)this.mLightPos + (float)(tempAnimTime - this.mLastAnimationStartTime) * this.mLightSpeed);
                this.mLastAnimationStartTime = tempAnimTime;
            }
            if (this.mViewBound == null) {
                this.mViewBound = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            } else {
                this.mViewBound.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            }
            this.mPath.reset();
            this.mPath.addRoundRect(this.mViewBound, this.mRectRadicus, this.mRectRadicus, Path.Direction.CW);
            canvas.clipPath(this.mPath);
            canvas.drawBitmap(this.getLightBitmap(), (float)this.mLightPos, 0.0f, this.mLightPaint);
            if (this.mLightPos < this.getWidth() + this.mLiveVipEnterLightHeight * 2) {
                this.postInvalidateDelayed(30L);
            } else {
                this.resetLightParams();
            }
        }
    }

    public void startLightAnimation() {
        this.mDoLightAnim = true;
        this.invalidate();
    }

    public Bitmap getLightBitmap() {
        if (!BitmapUtil.isAvailableBitmap(this.mLightBitmap)) {
            this.mLightBitmap = BitmapUtil.drawable2Bitmap(this.getResources().getDrawable(R.drawable.meipai_live_ic_white_light));
        }
        return this.mLightBitmap;
    }

    public void resetLightParams() {
        this.mDoLightAnim = false;
        this.mLightPos = this.mDefaultStartPos;
        this.mLastAnimationStartTime = 0L;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        BitmapUtil.release(this.mLightBitmap);
    }
}

