/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.yy.mobile.config.BasicConfig;

public class DeviceUtils {
    private static final String TAG = "DeviceUtils";
    static final String REGEX_FLOAT_NUMBER = "[-+]?([0-9]*\\.[0-9]+|[0-9]+)";

    public static float dip2fpx(Context context, float pDipValue) {
        DisplayMetrics dm = context.getApplicationContext().getResources().getDisplayMetrics();
        return pDipValue * dm.density;
    }

    public static float dip2fpx(float pDipValue) {
        return DeviceUtils.dip2fpx(BasicConfig.getInstance().getAppContext(), pDipValue);
    }

    public static int dip2px(Context context, float dipValue) {
        DisplayMetrics dm = context.getApplicationContext().getResources().getDisplayMetrics();
        return (int)(dipValue * dm.density + 0.5f);
    }

    public static int dip2px(float dipValue) {
        return DeviceUtils.dip2px(BasicConfig.getInstance().getAppContext(), dipValue);
    }

    public static int getScreenHeight() {
        return DeviceUtils.getScreenHeight(BasicConfig.getInstance().getAppContext());
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics dm = context.getApplicationContext().getResources().getDisplayMetrics();
        if (dm.widthPixels > dm.heightPixels) {
            return dm.widthPixels;
        }
        return dm.heightPixels;
    }

    public static int getScreenWidth() {
        return DeviceUtils.getScreenWidth(BasicConfig.getInstance().getAppContext());
    }

    public static int getScreenWidth(Context context) {
        DisplayMetrics dm = context.getApplicationContext().getResources().getDisplayMetrics();
        if (dm.widthPixels > dm.heightPixels) {
            return dm.heightPixels;
        }
        return dm.widthPixels;
    }

    public static int getPixels(Context context, String value, int targetSize) {
        int pixel = 0;
        if (!TextUtils.isEmpty((CharSequence)value)) {
            int indexOfPercentFlag = value.indexOf("%");
            if (indexOfPercentFlag > -1) {
                String percents = value.substring(0, indexOfPercentFlag);
                if (percents.matches(REGEX_FLOAT_NUMBER)) {
                    pixel = (int)((float)targetSize * (Float.parseFloat(percents) / 100.0f) + 0.5f);
                }
                if (indexOfPercentFlag < value.length() - 1) {
                    String offsetPixelString = value.substring(indexOfPercentFlag + 1);
                    if (offsetPixelString.endsWith("dip") || offsetPixelString.endsWith("dp")) {
                        offsetPixelString = offsetPixelString.replace("dip", "").replace("dp", "");
                    }
                    if (offsetPixelString.matches(REGEX_FLOAT_NUMBER)) {
                        pixel += DeviceUtils.dip2px(context, Float.parseFloat(offsetPixelString));
                    }
                }
            } else if (value.endsWith("dip") || value.endsWith("dp")) {
                String end = "dip";
                if (value.endsWith("dp")) {
                    end = "dp";
                }
                pixel = DeviceUtils.dip2px(context, Float.parseFloat(value.substring(0, value.indexOf(end))));
            }
        }
        return pixel;
    }

    public static boolean canUseLiveARMode() {
        return Build.VERSION.SDK_INT >= 21;
    }
}

