/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view.percent;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.MarginLayoutParamsCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.unionyy.mobile.meipai.R;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PercentLayoutHelper {
    private static final String TAG = "PercentLayout";
    private final ViewGroup mHost;
    private static final String REGEX_PERCENT = "^(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)%([wh]?)$";

    public PercentLayoutHelper(ViewGroup host) {
        this.mHost = host;
    }

    @SuppressLint(value={"NewApi"})
    public static void fetchWidthAndHeight(ViewGroup.LayoutParams params, TypedArray array2, int widthAttr, int heightAttr) {
        params.width = array2.getLayoutDimension(widthAttr, 0);
        params.height = array2.getLayoutDimension(heightAttr, 0);
    }

    public void adjustChildren(int widthMeasureSpec, int heightMeasureSpec) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            // empty if block
        }
        int widthHint = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightHint = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int N = this.mHost.getChildCount();
        for (int i = 0; i < N; ++i) {
            PercentLayoutInfo.PercentVal textSizePercent;
            View view = this.mHost.getChildAt(i);
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (Log.isLoggable((String)TAG, (int)3)) {
                // empty if block
            }
            if (!(params instanceof PercentLayoutParams)) continue;
            PercentLayoutInfo info = ((PercentLayoutParams)params).getPercentLayoutInfo();
            if (Log.isLoggable((String)TAG, (int)3)) {
                // empty if block
            }
            if (info == null) continue;
            if (view instanceof TextView && (textSizePercent = info.textSizePercent) != null) {
                int base = textSizePercent.isBaseWidth ? widthHint : heightHint;
                float textSize = (int)((float)base * textSizePercent.percent);
                ((TextView)view).setTextSize(0, textSize);
            }
            if (params instanceof ViewGroup.MarginLayoutParams) {
                info.fillMarginLayoutParams((ViewGroup.MarginLayoutParams)params, widthHint, heightHint);
                continue;
            }
            info.fillLayoutParams(params, widthHint, heightHint);
        }
    }

    public static PercentLayoutInfo getPercentLayoutInfo(Context context, AttributeSet attrs) {
        PercentLayoutInfo info = null;
        TypedArray array2 = context.obtainStyledAttributes(attrs, R.styleable.live_PercentLayout_Layout);
        String sizeStr = array2.getString(R.styleable.live_PercentLayout_Layout_layout_widthPercent);
        PercentLayoutInfo.PercentVal percentVal = PercentLayoutHelper.getPercentVal(sizeStr, true);
        if (percentVal != null) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                // empty if block
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.widthPercent = percentVal;
        }
        sizeStr = array2.getString(R.styleable.live_PercentLayout_Layout_layout_heightPercent);
        percentVal = PercentLayoutHelper.getPercentVal(sizeStr, false);
        if (sizeStr != null) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                // empty if block
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.heightPercent = percentVal;
        }
        if ((percentVal = PercentLayoutHelper.getPercentVal(sizeStr = array2.getString(R.styleable.live_PercentLayout_Layout_layout_marginPercent), false)) != null) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                // empty if block
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.leftMarginPercent = PercentLayoutHelper.getPercentVal(sizeStr, true);
            info.topMarginPercent = PercentLayoutHelper.getPercentVal(sizeStr, false);
            info.rightMarginPercent = PercentLayoutHelper.getPercentVal(sizeStr, true);
            info.bottomMarginPercent = PercentLayoutHelper.getPercentVal(sizeStr, false);
        }
        if ((percentVal = PercentLayoutHelper.getPercentVal(sizeStr = array2.getString(R.styleable.live_PercentLayout_Layout_layout_marginLeftPercent), true)) != null) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                // empty if block
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.leftMarginPercent = percentVal;
        }
        if ((percentVal = PercentLayoutHelper.getPercentVal(sizeStr = array2.getString(R.styleable.live_PercentLayout_Layout_layout_marginTopPercent), false)) != null) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                // empty if block
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.topMarginPercent = percentVal;
        }
        if ((percentVal = PercentLayoutHelper.getPercentVal(sizeStr = array2.getString(R.styleable.live_PercentLayout_Layout_layout_marginRightPercent), true)) != null) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                // empty if block
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.rightMarginPercent = percentVal;
        }
        if ((percentVal = PercentLayoutHelper.getPercentVal(sizeStr = array2.getString(R.styleable.live_PercentLayout_Layout_layout_marginBottomPercent), false)) != null) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                // empty if block
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.bottomMarginPercent = percentVal;
        }
        if ((percentVal = PercentLayoutHelper.getPercentVal(sizeStr = array2.getString(R.styleable.live_PercentLayout_Layout_layout_marginStartPercent), true)) != null) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                // empty if block
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.startMarginPercent = percentVal;
        }
        if ((percentVal = PercentLayoutHelper.getPercentVal(sizeStr = array2.getString(R.styleable.live_PercentLayout_Layout_layout_marginEndPercent), true)) != null) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                // empty if block
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.endMarginPercent = percentVal;
        }
        if ((percentVal = PercentLayoutHelper.getPercentVal(sizeStr = array2.getString(R.styleable.live_PercentLayout_Layout_layout_textSizePercent), false)) != null) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                // empty if block
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.textSizePercent = percentVal;
        }
        array2.recycle();
        if (Log.isLoggable((String)TAG, (int)3)) {
            // empty if block
        }
        return info;
    }

    private static PercentLayoutInfo.PercentVal getPercentVal(String percentStr, boolean isOnWidth) {
        if (percentStr == null) {
            return null;
        }
        Pattern p = Pattern.compile(REGEX_PERCENT);
        Matcher matcher = p.matcher(percentStr);
        if (!matcher.matches()) {
            throw new RuntimeException("the value of layout_xxxPercent invalid! ==>" + percentStr);
        }
        int len = percentStr.length();
        String floatVal = matcher.group(1);
        String lastAlpha = percentStr.substring(len - 1);
        float percent = Float.parseFloat(floatVal) / 100.0f;
        boolean isBasedWidth = isOnWidth && !lastAlpha.equals("h") || lastAlpha.equals("w");
        return new PercentLayoutInfo.PercentVal(percent, isBasedWidth);
    }

    public void restoreOriginalParams() {
        int N = this.mHost.getChildCount();
        for (int i = 0; i < N; ++i) {
            View view = this.mHost.getChildAt(i);
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("should restore " + view + " " + params));
            }
            if (!(params instanceof PercentLayoutParams)) continue;
            PercentLayoutInfo info = ((PercentLayoutParams)params).getPercentLayoutInfo();
            if (Log.isLoggable((String)TAG, (int)3)) {
                // empty if block
            }
            if (info == null) continue;
            if (params instanceof ViewGroup.MarginLayoutParams) {
                info.restoreMarginLayoutParams((ViewGroup.MarginLayoutParams)params);
                continue;
            }
            info.restoreLayoutParams(params);
        }
    }

    public boolean handleMeasuredStateTooSmall() {
        boolean needsSecondMeasure = false;
        int N = this.mHost.getChildCount();
        for (int i = 0; i < N; ++i) {
            PercentLayoutInfo info;
            View view = this.mHost.getChildAt(i);
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (Log.isLoggable((String)TAG, (int)3)) {
                // empty if block
            }
            if (!(params instanceof PercentLayoutParams) || (info = ((PercentLayoutParams)params).getPercentLayoutInfo()) == null) continue;
            if (PercentLayoutHelper.shouldHandleMeasuredWidthTooSmall(view, info)) {
                needsSecondMeasure = true;
                params.width = -2;
            }
            if (!PercentLayoutHelper.shouldHandleMeasuredHeightTooSmall(view, info)) continue;
            needsSecondMeasure = true;
            params.height = -2;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            // empty if block
        }
        return needsSecondMeasure;
    }

    private static boolean shouldHandleMeasuredWidthTooSmall(View view, PercentLayoutInfo info) {
        int state = view.getMeasuredWidth() & 0xFF000000;
        return state == 0x1000000 && info.widthPercent.percent >= 0.0f && info.mPreservedParams.width == -2;
    }

    private static boolean shouldHandleMeasuredHeightTooSmall(View view, PercentLayoutInfo info) {
        int state = view.getMeasuredHeight() & 0xFF000000;
        return state == 0x1000000 && info.heightPercent.percent >= 0.0f && info.mPreservedParams.height == -2;
    }

    public static interface PercentLayoutParams {
        public PercentLayoutInfo getPercentLayoutInfo();
    }

    public static class PercentLayoutInfo {
        public PercentVal widthPercent;
        public PercentVal heightPercent;
        public PercentVal leftMarginPercent;
        public PercentVal topMarginPercent;
        public PercentVal rightMarginPercent;
        public PercentVal bottomMarginPercent;
        public PercentVal startMarginPercent;
        public PercentVal endMarginPercent;
        public PercentVal textSizePercent;
        final ViewGroup.MarginLayoutParams mPreservedParams = new ViewGroup.MarginLayoutParams(0, 0);

        public void fillLayoutParams(ViewGroup.LayoutParams params, int widthHint, int heightHint) {
            int base;
            this.mPreservedParams.width = params.width;
            this.mPreservedParams.height = params.height;
            if (this.widthPercent != null) {
                base = this.widthPercent.isBaseWidth ? widthHint : heightHint;
                params.width = (int)((float)base * this.widthPercent.percent);
            }
            if (this.heightPercent != null) {
                base = this.heightPercent.isBaseWidth ? widthHint : heightHint;
                params.height = (int)((float)base * this.heightPercent.percent);
            }
            if (Log.isLoggable((String)PercentLayoutHelper.TAG, (int)3)) {
                // empty if block
            }
        }

        public void fillMarginLayoutParams(ViewGroup.MarginLayoutParams params, int widthHint, int heightHint) {
            int base;
            this.fillLayoutParams((ViewGroup.LayoutParams)params, widthHint, heightHint);
            this.mPreservedParams.leftMargin = params.leftMargin;
            this.mPreservedParams.topMargin = params.topMargin;
            this.mPreservedParams.rightMargin = params.rightMargin;
            this.mPreservedParams.bottomMargin = params.bottomMargin;
            MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)this.mPreservedParams, (int)MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)params));
            MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)this.mPreservedParams, (int)MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)params));
            if (this.leftMarginPercent != null) {
                base = this.leftMarginPercent.isBaseWidth ? widthHint : heightHint;
                params.leftMargin = (int)((float)base * this.leftMarginPercent.percent);
            }
            if (this.topMarginPercent != null) {
                base = this.topMarginPercent.isBaseWidth ? widthHint : heightHint;
                params.topMargin = (int)((float)base * this.topMarginPercent.percent);
            }
            if (this.rightMarginPercent != null) {
                base = this.rightMarginPercent.isBaseWidth ? widthHint : heightHint;
                params.rightMargin = (int)((float)base * this.rightMarginPercent.percent);
            }
            if (this.bottomMarginPercent != null) {
                base = this.bottomMarginPercent.isBaseWidth ? widthHint : heightHint;
                params.bottomMargin = (int)((float)base * this.bottomMarginPercent.percent);
            }
            if (this.startMarginPercent != null) {
                base = this.startMarginPercent.isBaseWidth ? widthHint : heightHint;
                MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)params, (int)((int)((float)base * this.startMarginPercent.percent)));
            }
            if (this.endMarginPercent != null) {
                base = this.endMarginPercent.isBaseWidth ? widthHint : heightHint;
                MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)params, (int)((int)((float)base * this.endMarginPercent.percent)));
            }
            if (Log.isLoggable((String)PercentLayoutHelper.TAG, (int)3)) {
                // empty if block
            }
        }

        public String toString() {
            return String.format("PercentLayoutInformation width: %f height %f, margins (%f, %f,  %f, %f, %f, %f)", this.widthPercent, this.heightPercent, this.leftMarginPercent, this.topMarginPercent, this.rightMarginPercent, this.bottomMarginPercent, this.startMarginPercent, this.endMarginPercent);
        }

        public void restoreMarginLayoutParams(ViewGroup.MarginLayoutParams params) {
            this.restoreLayoutParams((ViewGroup.LayoutParams)params);
            params.leftMargin = this.mPreservedParams.leftMargin;
            params.topMargin = this.mPreservedParams.topMargin;
            params.rightMargin = this.mPreservedParams.rightMargin;
            params.bottomMargin = this.mPreservedParams.bottomMargin;
            MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)params, (int)MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)this.mPreservedParams));
            MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)params, (int)MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)this.mPreservedParams));
        }

        public void restoreLayoutParams(ViewGroup.LayoutParams params) {
            params.width = this.mPreservedParams.width;
            params.height = this.mPreservedParams.height;
        }

        public static class PercentVal {
            public float percent = -1.0f;
            public boolean isBaseWidth;

            public PercentVal() {
            }

            public PercentVal(float percent, boolean isBaseWidth) {
                this.percent = percent;
                this.isBaseWidth = isBaseWidth;
            }
        }
    }
}

