/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.vehicle;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.unionyy.mobile.meipai.chat.message.passthrough.MPEnterBroadcastMgr;
import com.unionyy.mobile.meipai.chat.message.passthrough.MPEnterBroadcastRspData;
import com.unionyy.mobile.meipai.chat.message.passthrough.protocol.MPCMBroadcastData;
import com.unionyy.mobile.meipai.gift.data.bean.Medals;
import com.unionyy.mobile.meipai.gift.data.bean.UserIn;
import com.unionyy.mobile.meipai.gift.event.EventMountCarUserIn;
import com.unionyy.mobile.meipai.guard.protocol.IMPGuardCore;
import com.unionyy.mobile.meipai.guard.protocol.data.MPMyGuardInfo;
import com.unionyy.mobile.meipai.guard.protocol.event.MPMyGuardTypeEvent;
import com.unionyy.mobile.meipai.userinfo.MeiPaiUserInfoCore;
import com.unionyy.mobile.meipai.userinfo.entity.MPChatUserInfo;
import com.unionyy.mobile.meipai.vehicle.BroadcastVehicleBean;
import com.unionyy.mobile.meipai.vehicle.PersonalVehicleBean;
import com.unionyy.mobile.meipai.vehicle.Protocols.IMeiPaiVehicleInfo;
import com.unionyy.mobile.meipai.vehicle.Protocols.MeiPaiVehicleProtocols;
import com.unionyy.mobile.meipai.vehicle.VehicleManager;
import com.unionyy.mobile.meipai.vehicle.VehicleManagerBean;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelState;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.HashMap;
import java.util.Map;

public class VehicleEventHandle
implements EventCompat {
    private static final String TAG = "VehicleEventHandle";
    private static final long LESS_ENTRE_TIME = 30000L;
    private static Map<Long, Long> channelTimeMap = new HashMap<Long, Long>();
    private long currentChannelId;
    private volatile int guardType;
    private Gson gson = new Gson();
    private CompositeDisposable disposable = new CompositeDisposable();
    private final boolean isAudience;
    private long uid;
    private boolean isInit = true;
    private boolean guardEventIsPass = false;
    private boolean waitGuard = false;

    public VehicleEventHandle(boolean isAudience) {
        MLog.info((Object)TAG, (String)"VehicleEventHandle()", (Object[])new Object[0]);
        this.isAudience = isAudience;
        if (ICoreManagerBase.getChannelLinkCore().getChannelState() == ChannelState.In_Channel) {
            if (this.currentChannelId != 0L && ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid != 0L && this.currentChannelId == ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid) {
                return;
            }
            this.currentChannelId = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid;
            MPMyGuardInfo info = ((IMPGuardCore)ICoreManagerBase.getCore(IMPGuardCore.class)).getMyGuardInfo();
            if (info == null) {
                this.join(this.currentChannelId, true);
            } else {
                this.guardType = StringUtils.safeParseInt((String)info.getType());
                this.join(this.currentChannelId, false);
            }
        }
    }

    public void init() {
        this.onEventBind();
        if (ICoreManagerBase.getChannelLinkCore().getChannelState() == ChannelState.In_Channel) {
            this.registerVehicle();
            this.currentChannelId = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid;
        }
    }

    public void release() {
        this.disposable.clear();
        VehicleManager.getInstance().clear();
        this.onEventUnBind();
    }

    @BusEvent
    public void joinChannel(IChannelLinkClient_onJoinChannelSuccess_EventArgs join) {
        if (!this.isInit) {
            this.currentChannelId = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid;
            this.join(this.currentChannelId, true);
        }
    }

    @BusEvent
    public void leaveChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs leave) {
        MLog.info((Object)TAG, (String)("leaveChannel//uid= " + this.uid + "//ChannelId= " + this.currentChannelId), (Object[])new Object[0]);
        this.guardType = 0;
        this.isInit = false;
        this.guardEventIsPass = false;
        this.waitGuard = false;
        if (this.uid > 0L) {
            long currentTime = System.currentTimeMillis();
            channelTimeMap.put(this.currentChannelId, currentTime);
        }
        this.uid = 0L;
        VehicleManager.getInstance().clear();
    }

    private void join(long currentChannelId, boolean needQuery) {
        this.uid = LoginUtil.getUid();
        MLog.info((Object)TAG, (String)("joinChannel//uid= " + this.uid + "//ChannelId= " + currentChannelId), (Object[])new Object[0]);
        if (!((IMPGuardCore)ICoreManagerBase.getCore(IMPGuardCore.class)).queryUserGuardInfoState()) {
            if (needQuery) {
                if (!this.waitGuard) {
                    this.waitGuard = true;
                }
                ((IMPGuardCore)ICoreManagerBase.getCore(IMPGuardCore.class)).queryUserGuardInfo(ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId());
            } else {
                this.joinChannel(currentChannelId);
            }
        } else if (!this.waitGuard) {
            this.waitGuard = true;
        }
    }

    private void joinChannel(long key) {
        if (!this.isAudience) {
            return;
        }
        Long time = channelTimeMap.get(key);
        final long oldTime = time == null ? 0L : time;
        final long currentTime = System.currentTimeMillis();
        Disposable d2 = ((IMeiPaiVehicleInfo)ICoreManagerBase.getCore(IMeiPaiVehicleInfo.class)).getVehicleInfo().subscribeOn(Schedulers.io()).flatMapSingle((Function)new Function<MeiPaiVehicleProtocols.MeiPaiVehicleRsp, SingleSource<BroadcastVehicleBean>>(){

            public SingleSource<BroadcastVehicleBean> apply(MeiPaiVehicleProtocols.MeiPaiVehicleRsp rsp) throws Exception {
                PersonalVehicleBean vdata = null;
                try {
                    MLog.info((Object)VehicleEventHandle.TAG, (String)("PersonalVehicleBean=" + rsp.toString()), (Object[])new Object[0]);
                    if (rsp != null && rsp.carInfo != null && rsp.carInfo.size() > 0) {
                        String str = VehicleEventHandle.this.gson.toJson((Object)rsp.carInfo);
                        vdata = (PersonalVehicleBean)VehicleEventHandle.this.gson.fromJson(str, PersonalVehicleBean.class);
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)VehicleEventHandle.TAG, (String)("onMyselfIn//IMeiPaiVehicleInfo" + e), (Object[])new Object[0]);
                }
                final PersonalVehicleBean finalVdata = vdata;
                long uid = LoginUtil.getUid();
                if (uid > 0L) {
                    Single ss = MeiPaiUserInfoCore.INSTANCE.requestChatUserInfo(uid, false).map((Function)new Function<MPChatUserInfo, BroadcastVehicleBean>(){

                        public BroadcastVehicleBean apply(MPChatUserInfo mpChatUserInfo) throws Exception {
                            BroadcastVehicleBean bdata;
                            block7: {
                                bdata = new BroadcastVehicleBean();
                                try {
                                    int level = mpChatUserInfo.getUserLevel();
                                    int guardType = VehicleEventHandle.this.getGuardType();
                                    int enterType = 0;
                                    if (level >= 16) {
                                        enterType = 1;
                                    }
                                    if (guardType > 0) {
                                        enterType = 2;
                                    }
                                    bdata.nickName = mpChatUserInfo.getNickname();
                                    bdata.userLevel = level;
                                    bdata.enterType = enterType;
                                    bdata.guardType = guardType;
                                    if (currentTime - oldTime <= 30000L) break block7;
                                    MLog.info((Object)VehicleEventHandle.TAG, (String)"joinChannel() and time > 30s ", (Object[])new Object[0]);
                                    if (finalVdata == null) break block7;
                                    try {
                                        bdata.userCarId = Integer.valueOf(finalVdata.carID);
                                        bdata.userCarName = finalVdata.name;
                                        bdata.userCarUrl = finalVdata.resUrl;
                                        if (!TextUtils.isEmpty((CharSequence)finalVdata.action)) {
                                            bdata.userCarAction = finalVdata.action;
                                            break block7;
                                        }
                                        bdata.userCarAction = "\u5750\u7740";
                                    }
                                    catch (Exception e) {
                                        MLog.error((Object)VehicleEventHandle.TAG, (String)("onMyselfIn//BroadcastVehicleBean.build=" + e), (Object[])new Object[0]);
                                    }
                                }
                                catch (Exception e) {
                                    MLog.error((Object)VehicleEventHandle.TAG, (String)("onMyselfIn//BroadcastVehicleBean.build=" + e), (Object[])new Object[0]);
                                    bdata = new BroadcastVehicleBean();
                                }
                            }
                            return bdata;
                        }
                    });
                    return ss;
                }
                return Single.error((Throwable)new Exception("uid = 0"));
            }
        }).subscribe((Consumer)new Consumer<BroadcastVehicleBean>(){

            public void accept(BroadcastVehicleBean bdata) throws Exception {
                String broadStr = VehicleEventHandle.this.gson.toJson((Object)bdata);
                MLog.info((Object)VehicleEventHandle.TAG, (String)("onMyselfIn//BroadcastVehicleBean=" + broadStr), (Object[])new Object[0]);
                if (!TextUtils.isEmpty((CharSequence)broadStr)) {
                    VehicleEventHandle.this.sendEnterBroadcas(broadStr);
                } else {
                    VehicleEventHandle.this.sendEnterBroadcas(VehicleEventHandle.this.gson.toJson((Object)new BroadcastVehicleBean()));
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)VehicleEventHandle.TAG, (String)("onMyselfIn//IMeiPaiVehicleInfo" + throwable), (Object[])new Object[0]);
                if (LoginUtil.isLogined()) {
                    VehicleEventHandle.this.sendEnterBroadcas(null);
                }
            }
        });
        this.disposable.add(d2);
    }

    private void sendEnterBroadcas(@Nullable String broadcs) {
        MLog.error((Object)TAG, (String)("sendEnterBroadcas(broadcs)=" + broadcs), (Object[])new Object[0]);
        MPEnterBroadcastMgr.INSTANCE.sendBroadcast(broadcs);
        try {
            BroadcastVehicleBean broadcastVehicleBean = (BroadcastVehicleBean)this.gson.fromJson(broadcs, BroadcastVehicleBean.class);
            VehicleManagerBean bean = new VehicleManagerBean(ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId(), LoginUtil.getUid(), broadcastVehicleBean != null ? broadcastVehicleBean.nickName : "", 0, broadcastVehicleBean);
            this.showVehicle(bean);
        }
        catch (Exception e) {
            e.printStackTrace();
            MLog.error((Object)TAG, (String)("sendEnterBroadcas(broadcs)=" + e), (Object[])new Object[0]);
        }
        this.guardEventIsPass = false;
    }

    private void showVehicle(VehicleManagerBean bean) {
        if (bean != null) {
            MLog.info((Object)TAG, (String)("VehicleManagerBean==" + bean.toString()), (Object[])new Object[0]);
            if (bean.vehicleBean != null) {
                if (bean.vehicleBean.enterType == 0 && bean.vehicleBean.userCarId == 0) {
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)bean.vehicleBean.userCarUrl) && bean.vehicleBean.userCarId > 0) {
                    VehicleManager.getInstance().startVehicle(bean);
                } else {
                    Medals medals = new Medals();
                    medals.setGuard(bean.vehicleBean.guardType);
                    UserIn userIn = new UserIn();
                    userIn.setId(bean.uid);
                    userIn.setNick(bean.nick);
                    userIn.setLevel(bean.vehicleBean.userLevel);
                    userIn.setMedals(medals);
                    EventMountCarUserIn event = new EventMountCarUserIn();
                    event.setType(4);
                    event.setUser(userIn);
                    RxBus.getDefault().post((Object)event);
                }
            }
        }
    }

    private void registerVehicle() {
        Disposable d2 = MPEnterBroadcastMgr.INSTANCE.receiveBroadcast().observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<MPEnterBroadcastRspData>(){

            public void accept(MPEnterBroadcastRspData mpEnterBroadcastRspData) throws Exception {
                try {
                    if (mpEnterBroadcastRspData != null) {
                        String biz;
                        MLog.info((Object)VehicleEventHandle.TAG, (String)("MPEnterBroadcastRspData==" + mpEnterBroadcastRspData.toString()), (Object[])new Object[0]);
                        if (mpEnterBroadcastRspData.getUid() != 0L && LoginUtil.getUid() != 0L && mpEnterBroadcastRspData.getUid() == LoginUtil.getUid()) {
                            return;
                        }
                        MPCMBroadcastData exInfo = mpEnterBroadcastRspData.getExtInfo();
                        if (exInfo != null && !TextUtils.isEmpty((CharSequence)(biz = exInfo.getBiz()))) {
                            VehicleManagerBean bean = new VehicleManagerBean(mpEnterBroadcastRspData.getAid(), mpEnterBroadcastRspData.getUid(), mpEnterBroadcastRspData.getNick(), mpEnterBroadcastRspData.isIOS(), (BroadcastVehicleBean)VehicleEventHandle.this.gson.fromJson(biz, BroadcastVehicleBean.class));
                            VehicleEventHandle.this.showVehicle(bean);
                        }
                    }
                }
                catch (Exception e) {
                    MLog.info((Object)VehicleEventHandle.TAG, (String)("accept()//Exception==" + e), (Object[])new Object[0]);
                }
            }
        });
        this.disposable.add(d2);
    }

    @BusEvent
    public void guardType(MPMyGuardTypeEvent typeEvent) {
        if (this.guardEventIsPass) {
            return;
        }
        this.guardEventIsPass = true;
        String strType = typeEvent.getType();
        MLog.info((Object)TAG, (String)("BusEvent//guardType()= " + strType), (Object[])new Object[0]);
        this.setGuard(strType);
    }

    private void setGuard(String strType) {
        MLog.info((Object)TAG, (String)("setGuard()= " + strType), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)strType)) {
            this.guardType = 0;
        } else {
            try {
                this.guardType = Integer.valueOf(strType);
            }
            catch (Exception e) {
                this.guardType = 0;
                MLog.error((Object)TAG, (String)("guardType()= " + e), (Object[])new Object[0]);
            }
        }
        if (this.waitGuard) {
            this.waitGuard = false;
            long currentChannelId = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid;
            this.joinChannel(currentChannelId);
        }
    }

    private int getGuardType() {
        MLog.info((Object)TAG, (String)"getGuardType()", (Object[])new Object[0]);
        return this.guardType;
    }

    public void onEventBind() {
    }

    public void onEventUnBind() {
    }
}

