/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.presenter;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.unionyy.mobile.meipai.pk.core.IMeiPaiPkCore;
import com.unionyy.mobile.meipai.pk.event.ChangeToMeiPaiPkTemplateArgs;
import com.unionyy.mobile.meipai.pk.event.EventClosePk;
import com.unionyy.mobile.meipai.pk.event.EventCountDownFinished;
import com.unionyy.mobile.meipai.pk.event.PkStatusEvent;
import com.unionyy.mobile.meipai.pk.ui.IPkComponentView;
import com.unionyy.mobile.meipai.pk.ui.model.PkStatusInfo;
import com.unionyy.mobile.meipai.pk.utils.PkChannelMsgSendUtils;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelState;

public abstract class MeiPaiPkBasePresenter
implements EventCompat {
    private static final String TAG = "MeiPaiPkBasePresenter";
    @NonNull
    protected IMeiPaiPkCore core = (IMeiPaiPkCore)CoreFactory.getCore(IMeiPaiPkCore.class);
    @NonNull
    protected IPkComponentView mPkComponentView;
    @NonNull
    protected Handler mHandler;
    protected int lastType;

    public void onEventBind() {
    }

    public void onEventUnBind() {
    }

    public MeiPaiPkBasePresenter(@NonNull IPkComponentView pkComponentView) {
        this.mPkComponentView = pkComponentView;
        this.mHandler = new SafeDispatchHandler(Looper.getMainLooper());
    }

    public void onCreateView() {
        this.onEventBind();
        if (ICoreManagerBase.getChannelLinkCore().getChannelState() == ChannelState.In_Channel) {
            this.core.reqPkLoad();
        }
    }

    public void onDestroyView() {
        this.onEventUnBind();
        this.onClosePk();
    }

    @BusEvent
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"[PK]leaveCurrentChannel called", (Object[])new Object[0]);
        this.core.resetData();
        this.onClosePk();
    }

    @BusEvent
    public void onJoinChannelProgress(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"[PK]onJoinChannelSuccess called", (Object[])new Object[0]);
        this.core.reqPkLoad();
    }

    @BusEvent
    public void onEventCountDownFinished(EventCountDownFinished event) {
        PkStatusInfo info = this.core.getPkStatusInfo();
        this.onEventCountDownFinished(info);
    }

    protected void onEventCountDownFinished(PkStatusInfo info) {
        MLog.info((Object)TAG, (String)("[PK]onEventCountDownFinished" + info), (Object[])new Object[0]);
        if (info.type == 4) {
            info.leftTime = info.pkTime;
            info.type = 5;
            this.mPkComponentView.updatePkBar();
            this.changeTemplateIfNeed(true);
        }
    }

    @BusEvent
    public void onEventPubOverPunish(EventClosePk event) {
        this.onClosePk();
    }

    protected abstract void onPkStatusUpdate();

    @BusEvent
    public void onPkStatusEvent(PkStatusEvent event) {
        PkStatusInfo info = this.core.getPkStatusInfo();
        if (info.state == 0) {
            if ((this.lastType == 5 || this.lastType == 4) && info.isAheadStopInPk()) {
                PkChannelMsgSendUtils.INSTANCE.pkUnNomalEndNotice(info.endResult);
                if (info.bestHelperUid > 0L) {
                    PkChannelMsgSendUtils.INSTANCE.pkBestHelperNotice(info.bestHelperSendNum, info.bestHelperUid);
                }
            }
            this.onClosePk();
        } else {
            this.changeTemplateIfNeed(this.isPkGameTime(info));
            if (this.lastType == 5 && info.type == 6) {
                if (info.bestHelperUid > 0L) {
                    PkChannelMsgSendUtils.INSTANCE.pkBestHelperNotice(info.bestHelperSendNum, info.bestHelperUid);
                }
                PkChannelMsgSendUtils.INSTANCE.pkResultNotice(info.endResult);
            }
            this.mPkComponentView.updatePkBar();
        }
        this.onPkStatusUpdate();
        this.lastType = info.type;
    }

    protected boolean isPkGameTime(PkStatusInfo info) {
        return info.type == 5 || info.type == 6 || info.type == 4 && info.isAgainPk;
    }

    protected void onClosePk() {
        this.lastType = 0;
        this.mPkComponentView.closePk();
        this.mHandler.removeCallbacksAndMessages(null);
        this.changeTemplateIfNeed(false);
    }

    private void changeTemplateIfNeed(boolean isOpen) {
        if (isOpen && !this.core.isInMeiPaiPkTemplate() || !isOpen && this.core.isInMeiPaiPkTemplate()) {
            this.core.setMeiPaiPkTemplate(isOpen);
            RxBus.getDefault().post((Object)new ChangeToMeiPaiPkTemplateArgs(isOpen));
        }
    }
}

