/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view.opengl;

import android.opengl.Matrix;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.GLCanvas;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.GLGraph;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.GLPath;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.MatrixState;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.TextureIdManager;

public class TextureLayer
extends GLPath {
    private static final short[] VER_INDICES = new short[]{0, 1, 2, 2, 3, 1};
    private int vCount = 0;
    public float unitWidth = 0.0f;
    public float unitHeight = 0.0f;
    private float[] mTexCoor;
    private TextureIdManager.TextureData textureData;
    private boolean isDrawWhenLoadBitmap = true;
    private GLGraph mGLGraph = new GLGraph();
    private float[] mVerticePos = new float[4];
    private float[] mFinalVerticePos = new float[4];
    private float[] mVertices;
    private float[] mVerTexCoors;
    private short[] mIndices;

    public TextureLayer() {
        this.initMatrixState();
        this.initVertexData();
        this.initTexCoor();
    }

    public void setUnitSize(float unitWidth, float unitHeight) {
        if (unitWidth > 0.0f && unitHeight > 0.0f && (unitWidth != this.unitWidth || unitHeight != this.unitHeight)) {
            this.unitWidth = unitWidth;
            this.unitHeight = unitHeight;
            this.initVertexData();
        }
    }

    public void initVertexData() {
        this.vCount = 4;
        float[] vertices = new float[]{-1.0f * this.unitWidth, this.unitHeight, 0.0f, -1.0f * this.unitWidth, -1.0f * this.unitHeight, 0.0f, 1.0f * this.unitWidth, 1.0f * this.unitHeight, 0.0f, 1.0f * this.unitWidth, -1.0f * this.unitHeight, 0.0f};
        this.mVertices = vertices;
        this.mIndices = new short[6];
        this.mVerTexCoors = new float[this.vCount * 5];
    }

    private void initTexCoor() {
        if (this.mTexCoor == null) {
            this.mTexCoor = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        }
    }

    public void setTextureMapping(float left, float top, float right, float bottom) {
        this.mTexCoor = new float[]{left, top, left, bottom, right, top, right, bottom};
        this.initTexCoor();
    }

    public void setTextureData(TextureIdManager.TextureData data) {
        this.textureData = data;
        this.setUnitSize(this.textureData.width / 2.0f, this.textureData.height / 2.0f);
    }

    public TextureIdManager.TextureData getTextureData() {
        return this.textureData;
    }

    @Override
    public void drawSelf(GLCanvas glCanvas) {
        if (this.textureData.bitmap != null) {
            this.textureData.textureId = TextureIdManager.initTexture(this.textureData.bitmap);
            this.textureData.bitmap = null;
            if (!this.isDrawWhenLoadBitmap) {
                return;
            }
        }
        MatrixState matrixState = glCanvas.getMatrixState();
        matrixState.initMatrix();
        matrixState.transtate(this.xTrans, this.yTrans, this.zTrans);
        matrixState.rotate(this.rAngle, 0.0f, 0.0f, 1.0f);
        matrixState.scale(this.xScale, this.yScale, 1.0f);
        this.createVerTextoors(matrixState);
        this.mGLGraph.setAlpha(this.alpha);
        this.mGLGraph.setVertices(this.mVerTexCoors);
        this.mGLGraph.setIndices(this.mIndices);
        this.mGLGraph.setTextureId(this.textureData.textureId);
        glCanvas.put(this.mGLGraph);
    }

    private void createVerTextoors(MatrixState matrixState) {
        int i;
        int curIndex = 0;
        float[] finalMatrix = matrixState.getFinalMatrix();
        for (i = 0; i < this.vCount; ++i) {
            int j;
            for (j = 0; j < 3; ++j) {
                this.mVerticePos[j] = this.mVertices[i * 3 + j];
            }
            this.mVerticePos[3] = 1.0f;
            Matrix.multiplyMV((float[])this.mFinalVerticePos, (int)0, (float[])finalMatrix, (int)0, (float[])this.mVerticePos, (int)0);
            for (j = 0; j < 3; ++j) {
                this.mVerTexCoors[curIndex++] = this.mFinalVerticePos[j];
            }
            this.mVerTexCoors[curIndex++] = this.mTexCoor[i * 2];
            this.mVerTexCoors[curIndex++] = this.mTexCoor[i * 2 + 1];
        }
        for (i = 0; i < 6; ++i) {
            this.mIndices[i] = VER_INDICES[i];
        }
    }

    public void setIsDrawWhenLoadBitmap(boolean isDraw) {
        this.isDrawWhenLoadBitmap = isDraw;
    }
}

