/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.popularity.control;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.unionyy.mobile.meipai.popularity.control.ICallProgressCallBack;
import java.util.Timer;
import java.util.TimerTask;

public class CallTimer {
    public static int POPULARITY_GIFT_ELAPSED_TIME = 120000;
    public static final int ICON_VIEW_REFRESH_INTERVAL = 100;
    public static final int MESSAGE_WHAT_REFRESH_ICON = 1;
    private final ICallProgressCallBack callProgressCallBack;
    private Timer mTimer;
    private TimerTask mTimerTask;
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    CallTimer.this.refreshProgress();
                }
            }
        }
    };
    private long mCurrentWatchTime = 0L;

    public CallTimer(ICallProgressCallBack callProgressCallBack) {
        this.callProgressCallBack = callProgressCallBack;
    }

    private void refreshProgress() {
        this.mCurrentWatchTime += 100L;
        if (this.callProgressCallBack != null) {
            this.callProgressCallBack.progress((float)this.mCurrentWatchTime / (float)POPULARITY_GIFT_ELAPSED_TIME);
        }
        if (this.mCurrentWatchTime == (long)POPULARITY_GIFT_ELAPSED_TIME) {
            this.end();
            if (this.callProgressCallBack != null) {
                this.callProgressCallBack.end();
            }
        }
    }

    public void start() {
        this.end();
        this.mCurrentWatchTime = 0L;
        this.mTimer = new Timer("CallTimer");
        this.mTimerTask = new TimerTask(){

            @Override
            public void run() {
                CallTimer.this.mHandler.sendMessage(Message.obtain((Handler)CallTimer.this.mHandler, (int)1));
            }
        };
        this.mTimer.schedule(this.mTimerTask, 0L, 100L);
    }

    public void end() {
        if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
            this.mTimerTask = null;
        }
        if (this.mTimer != null) {
            this.mTimer.purge();
            this.mTimer.cancel();
            this.mTimer = null;
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }

    public void destroy() {
        this.end();
    }
}

