/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.utils;

import android.graphics.Color;
import android.text.TextUtils;
import com.unionyy.mobile.meipai.R;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.log.MLog;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class NumberUtils {
    private static final String TAG = "NumberUtils";

    public static String less100(Integer count) {
        if (count == null) {
            return "0";
        }
        String value = String.valueOf(count);
        if (count > 99) {
            value = "99+";
        }
        return value;
    }

    public static String less1000(Integer count) {
        if (count == null) {
            return "0";
        }
        if (count > 999) {
            return "999+";
        }
        return String.valueOf(count);
    }

    public static String less10W(Integer count) {
        if (count == null) {
            return "0";
        }
        StringBuilder strBuilder = new StringBuilder();
        if (count > 99999) {
            strBuilder.append("99999+");
        } else {
            strBuilder.append(count);
        }
        return strBuilder.toString();
    }

    public static String less10WWith1(Integer count) {
        if (count == null) {
            return "0";
        }
        int absCount = Math.abs(count);
        String value = String.valueOf(count);
        if (absCount > 99999) {
            String language = Locale.getDefault().getLanguage().toLowerCase();
            if ("zh".equals(language)) {
                int i = count / 1000;
                if (i % 10 != 0) {
                    float v = (float)i / 10.0f;
                    value = v + BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_wan);
                } else {
                    int v = i / 10;
                    value = v + BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_wan);
                }
            } else {
                value = count / 1000 + BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_k);
            }
        }
        return value;
    }

    public static String less10WWith1(Long count) {
        if (count == null) {
            return "0";
        }
        long absCount = Math.abs(count);
        String value = String.valueOf(count);
        if (absCount > 99999L) {
            String language = Locale.getDefault().getLanguage().toLowerCase();
            if ("zh".equals(language)) {
                long i = count / 1000L;
                if (i % 10L != 0L) {
                    float v = (float)i / 10.0f;
                    value = v + BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_wan);
                } else {
                    long v = i / 10L;
                    value = v + BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_wan);
                }
            } else {
                value = count / 1000L + BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_k);
            }
        }
        return value;
    }

    public static final String fileSizeKb2Mb(double size) {
        size /= 1024.0;
        String hrSize = "";
        DecimalFormat dec = null;
        try {
            dec = (DecimalFormat)NumberFormat.getInstance(Locale.CHINA);
            dec.applyPattern("0.0");
        }
        catch (Exception e) {
            e.printStackTrace();
            dec = new DecimalFormat("0.0");
        }
        double m = size / 1024.0;
        double g = size / 1048576.0;
        double t = size / 1.073741824E9;
        hrSize = t > 1.0 ? dec.format(t).concat("T") : (g > 1.0 ? dec.format(g).concat("G") : (m > 1.0 ? dec.format(m).concat("M") : dec.format(size).concat("K")));
        return hrSize;
    }

    public static final int hexStringToColorInt(String hexString) {
        if (!TextUtils.isEmpty((CharSequence)hexString) && hexString.length() == 6) {
            try {
                return Color.parseColor((String)("#" + hexString));
            }
            catch (IllegalArgumentException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return Color.parseColor((String)"#ffffff");
    }

    public static final int hexStringToColorIntForSquare(String hexString) {
        if (!TextUtils.isEmpty((CharSequence)hexString) && hexString.length() == 6) {
            try {
                return Color.parseColor((String)("#" + hexString));
            }
            catch (IllegalArgumentException e) {
                MLog.error((Object)TAG, (Throwable)e);
                return Color.parseColor((String)"#00000000");
            }
        }
        return Color.parseColor((String)"#00000000");
    }

    public static String formatPlayNumber(Long count) {
        return NumberUtils.formatNumber(count, 1, 2, 1, 1, 2);
    }

    public static String formatPraiseNumber(Long count) {
        return NumberUtils.formatNumber(count, 1, 3, 1, 1, 2);
    }

    public static String formatNumber(Long number, int lengthWan, int lengthYi, int lengthKilo, int lengthMillion, int lengthBillion) {
        if (number == null || number < 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (NumberUtils.isSimpleChineseSystem()) {
            if (lengthWan < 0) {
                lengthWan = 0;
            }
            if (lengthYi < 0) {
                lengthYi = 0;
            }
            if (number >= 0L && number < 100000L) {
                sb.append(number);
            } else if (number < 99999500L) {
                float temp = (float)number.longValue() / 10000.0f;
                sb.append(String.format("%." + lengthWan + "f", Float.valueOf(temp))).append(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_wan));
            } else {
                float temp = (float)number.longValue() / 1.0E8f;
                sb.append(String.format("%." + lengthYi + "f", Float.valueOf(temp))).append(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_yi));
            }
        } else {
            if (lengthKilo < 0) {
                lengthKilo = 0;
            }
            if (lengthMillion < 0) {
                lengthMillion = 0;
            }
            if (lengthBillion < 0) {
                lengthBillion = 0;
            }
            if (number < 1000L) {
                sb.append(number);
            } else if (number < 999950L) {
                float temp = (float)number.longValue() / 1000.0f;
                sb.append(String.format("%." + lengthKilo + "f", Float.valueOf(temp))).append(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_k));
            } else if (number < 999500000L) {
                float temp = (float)number.longValue() / 1000000.0f;
                sb.append(String.format("%." + lengthMillion + "f", Float.valueOf(temp))).append(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_m));
            } else {
                float temp = (float)number.longValue() / 1.0E9f;
                sb.append(String.format("%." + lengthBillion + "f", Float.valueOf(temp))).append(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_b));
            }
        }
        return sb.toString();
    }

    public static float getLiveCoverRadio(String des) {
        float defaultRadio = 1.3333334f;
        return NumberUtils.getPicRadio(des, defaultRadio);
    }

    public static float getPicRadio(String des, float defaultRadio) {
        if (TextUtils.isEmpty((CharSequence)des)) {
            return defaultRadio;
        }
        int index = des.indexOf("*");
        if (index <= 0) {
            return defaultRadio;
        }
        try {
            int width = Integer.valueOf(des.substring(0, index).trim());
            int height = Integer.valueOf(des.substring(index + 1).trim());
            return (float)height / (float)width;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return defaultRadio;
        }
    }

    public static float getPicWHRadio(String des, float defaultRadio) {
        if (TextUtils.isEmpty((CharSequence)des)) {
            return defaultRadio;
        }
        int index = des.indexOf("*");
        if (index <= 0) {
            return defaultRadio;
        }
        try {
            int width = Integer.valueOf(des.substring(0, index).trim());
            int height = Integer.valueOf(des.substring(index + 1).trim());
            return (float)width / (float)height;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return defaultRadio;
        }
    }

    public static String formatMusicDuring(long time) {
        long m = time % 3600000L / 60000L;
        long s = Math.round((float)(time % 60000L) / 1000.0f);
        String result = (m > 9L ? Long.valueOf(m) : "0" + m) + ":" + (s > 9L ? Long.valueOf(s) : "0" + s);
        if (time >= 3600000L) {
            long h = time % 86400000L / 3600000L;
            result = (h > 9L ? Long.valueOf(h) : "0" + h) + ":" + result;
        }
        return result;
    }

    public static String formatVideoDuring(long time) {
        long m = time % 3600000L / 60000L;
        float s = (float)(time % 60000L) / 1000.0f;
        String result = String.format("%02d:%02.1f", m, Float.valueOf(s));
        return result;
    }

    public static boolean isNumber(String number) {
        if (TextUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        return number.matches("[0-9]*$");
    }

    public static final boolean isSimpleChineseSystem() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        return language != null && "zh".equalsIgnoreCase(language) && "cn".equalsIgnoreCase(country);
    }
}

