/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.gifttarget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.os.Handler;
import android.os.Looper;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.BasicTransformations;
import com.unionyy.mobile.meipai.gift.animation.FrameAnimator;
import com.unionyy.mobile.meipai.gift.animation.GiftAnimation;
import com.unionyy.mobile.meipai.gift.animation.callback.OnGiftPositionChangedListener;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.ComboPointGLTarget;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.ComboPointTarget;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.ComboPointViewTarget;
import com.unionyy.mobile.meipai.gift.animation.model.FansMedalBean;
import com.unionyy.mobile.meipai.gift.animation.model.GiftAnimationParams;
import com.unionyy.mobile.meipai.gift.animation.model.GiftMessage;
import com.unionyy.mobile.meipai.gift.animation.model.GiftPosition;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import com.unionyy.mobile.meipai.gift.animation.utils.DipUtils;
import com.unionyy.mobile.meipai.gift.animation.utils.SpanUtils;
import com.unionyy.mobile.meipai.gift.animation.view.GlAnimationView;
import com.unionyy.mobile.meipai.pk.utils.AvatarRoundUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;

public abstract class GiftTarget
implements BasicTransformations {
    private static final String TAG = "GiftTarget";
    private final int mUserInfoViewMarginTop = (int)ResolutionUtils.convertDpToPixel((float)104.0f, (Context)BasicConfig.getInstance().getAppContext());
    public static final int TYPE_IMAGE = 0;
    public static final int TYPE_LED = 1;
    public static final int TYPE_GIF_IMAGE = 2;
    public static final int TYPE_MULTI_IMAGE = 3;
    public static final int TYPE_IMAGE_WEBP = 4;
    private static final int MARGIN_GIFT_USERINFO = 7;
    public static final int IDLE = -1;
    public static final int BEGINNING = 0;
    public static final int RUNNING = 1;
    public static final int COMBO = 2;
    public static final int ENDING = 3;
    public static final int DISMISS = 4;
    private static final int MAX_COMBO_INTERVAL = 10;
    protected GiftMessage mGiftMessage;
    protected GiftRule mGiftRule;
    private boolean isMount = false;
    private int mType;
    private GiftFrom mGiftFrom;
    private int mImageWidth;
    private int mImageHeight;
    private float mImageLeft;
    private float mImageTop;
    private boolean mHasInitImagePosition;
    private float mUserInfoGroupOffsetX;
    private float mUserInfoGroupOffsetY;
    private int mUserInfoGroupHeight;
    private long mMemoryUsage;
    protected float mImageScale;
    private float mTargetScale;
    private GiftAnimation mMidAnimation;
    private float mComboViewMaxScale;
    private ObjectAnimator mUserInfoEntranceAnimator;
    private int mCurrentCombo;
    private int mCurrentBeginningIndex;
    private boolean mIsSupprotEGL;
    protected TextView mUserInfoView;
    protected TextView mGiftNameView;
    protected ImageView mAvatarView;
    protected ImageView mVerifiedView;
    protected View mUserInfoGroup;
    protected ViewGroup mRootGroup;
    private ComboPointTarget mComboViewTarget;
    protected int mCurrentState = -1;
    private Handler mHandler;
    private GiftTarget mEggTarget;
    private long mDuration;
    private GiftAnimation mEndingAnimation;
    private FrameAnimator mUserInfoShowAnimation;
    private FrameAnimator mAddComboAnimation;
    private GiftAnimation[] mStartAnimations;
    private int mGroupWidth;
    private int mGroupHeight;
    private OnGiftPositionChangedListener mGiftPositionChangedListener;
    private OnUserInfoClickListener mOnUserInfoClickListener;
    private float mTargetTranslationY;
    private View.OnClickListener userClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (GiftTarget.this.mOnUserInfoClickListener != null) {
                GiftTarget.this.mOnUserInfoClickListener.onClick(GiftTarget.this.mGiftMessage);
            }
        }
    };
    private ValueAnimator.AnimatorUpdateListener mAnimateUserInfoGroupCallBack = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            Object obj = valueAnimator.getAnimatedValue();
            if (obj instanceof float[]) {
                if (null != GiftTarget.this.mUserInfoGroup) {
                    float[] point = (float[])obj;
                    GiftTarget.this.mUserInfoGroup.setTranslationX(point[0] + GiftTarget.this.mUserInfoGroupOffsetX);
                    GiftTarget.this.mUserInfoGroup.setTranslationY(point[1] + GiftTarget.this.mUserInfoGroupOffsetY);
                }
            } else {
                if (GiftTarget.this.getGiftImage() == null) {
                    return;
                }
                float translationY = ((BasicTransformations)GiftTarget.this.getGiftImage()).getTranslationY();
                if (null != GiftTarget.this.mUserInfoGroup) {
                    GiftTarget.this.mUserInfoGroup.setTranslationY(translationY + GiftTarget.this.mUserInfoGroupOffsetY);
                }
                GiftTarget.this.mImageTop = translationY;
                GiftTarget.this.updateComboViewPosition(GiftTarget.this.mComboViewMaxScale);
            }
        }
    };
    private AnimatorListenerAdapter mBeginningAnimatorListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
            if (GiftTarget.this.mCurrentState != 0 || GiftTarget.this.mStartAnimations == null) {
                return;
            }
            GiftTarget.this.mCurrentBeginningIndex++;
            if (GiftTarget.this.mCurrentBeginningIndex < GiftTarget.this.mStartAnimations.length) {
                GiftAnimation next = GiftTarget.this.mStartAnimations[GiftTarget.this.mCurrentBeginningIndex];
                if (next != null) {
                    next.setAutoUpdate(GiftTarget.this.isAutoUpdateStartAnimation());
                    next.start((BasicTransformations)GiftTarget.this.getGiftImage(), (Animator.AnimatorListener)GiftTarget.this.mBeginningAnimatorListener);
                    GiftTarget.this.checkMoveUserInfoGroupWithImage(next);
                }
            } else {
                GiftTarget.this.afterBeginningAnimation();
            }
        }
    };
    private static final String TAG1 = "traceNP";
    private Runnable mDismissRunnable = new Runnable(){

        @Override
        public void run() {
            GiftTarget.this.mCurrentState = 3;
            if (GiftTarget.this.mEndingAnimation != null) {
                GiftTarget.this.mEndingAnimation.start(GiftTarget.this, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        if (GiftTarget.this.mCurrentState != 4) {
                            GiftTarget.this.onGiftAnimationEnd();
                        }
                        GiftTarget.this.mEndingAnimation = null;
                    }
                });
            } else {
                GiftTarget.this.onGiftAnimationEnd();
            }
        }
    };
    private AnimatorListenerAdapter mComboAnimationEndListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
            if (GiftTarget.this.mCurrentState >= 3) {
                return;
            }
            GiftTarget.this.mAddComboAnimation = null;
            GiftTarget.this.mCurrentState = 1;
            if (GiftTarget.this.mGiftMessage != null && GiftTarget.this.mCurrentCombo < GiftTarget.this.mGiftMessage.getComboTo()) {
                GiftTarget.this.updateCombPoint(GiftTarget.this.mGiftMessage, false);
            }
        }
    };
    private GiftImageDismissListener mGiftImageDismissListener;

    public GiftTarget(boolean isSupportEGL) {
        this.mIsSupprotEGL = isSupportEGL;
    }

    public GiftTarget getEggTarget() {
        return this.mEggTarget;
    }

    public void setEggTarget(GiftTarget target) {
        this.mEggTarget = target;
    }

    public void setGiftPositionChangedListener(OnGiftPositionChangedListener listener2) {
        this.mGiftPositionChangedListener = listener2;
    }

    public void addTo(Context context, ViewGroup group, float x, float y, int z, int viewWidth, GiftFrom from, boolean orientation_land) {
        if (context == null) {
            return;
        }
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        }
        this.mRootGroup = group;
        if (null != this.mGiftRule) {
            this.mType = this.mGiftRule.type;
        }
        if (this.mUserInfoGroup != null && this.mGiftFrom != from) {
            this.mUserInfoGroup = null;
        }
        this.mGiftFrom = from;
        this.mTargetScale = 1.0f;
        this.mComboViewMaxScale = 0.7f;
        if (!this.mHasInitImagePosition) {
            this.mImageLeft = x;
            this.mImageTop = y;
        }
        int giftImageIndex = z >= 0 ? z++ : -1;
        int nextIndex = z;
        this.addGiftImage(context, group, this.mImageLeft, this.mImageTop, giftImageIndex);
        if (from != GiftFrom.LIVE_EGG && !this.isMount) {
            this.initUserInfoView(context, group, from, viewWidth, z >= 0 ? z++ : -1, orientation_land);
        }
        if (this.mComboViewTarget == null) {
            this.mComboViewTarget = this.mIsSupprotEGL ? new ComboPointGLTarget() : new ComboPointViewTarget();
        }
        this.mComboViewTarget.addTo(context, group, z >= 0 ? z : -1);
        this.mCurrentState = -1;
        if (from != GiftFrom.LIVE) {
            this.startGiftAnimation(this.mGiftRule);
        }
    }

    public void addTo(Context context, ViewGroup group, float x, float y, int z, int viewWidth, GiftFrom from) {
        this.addTo(context, group, x, y, z, viewWidth, from, false);
    }

    public void startUserInfoGroupEntranceAnim(AnimatorListenerAdapter listener2) {
        this.setUserInfo(this.mGiftMessage);
        this.showUserInfo();
        if (null != this.mUserInfoGroup) {
            float transX = BasicConfig.getInstance().getAppContext().getResources().getDimension(R.dimen.meipai_live_gift_user_info_max_width);
            this.mUserInfoEntranceAnimator = ObjectAnimator.ofFloat((Object)this.mUserInfoGroup, (String)"translationX", (float[])new float[]{-transX, 0.0f});
            this.mUserInfoEntranceAnimator.setDuration(330L);
            this.mUserInfoEntranceAnimator.addListener((Animator.AnimatorListener)listener2);
            this.mUserInfoEntranceAnimator.start();
        }
    }

    public void cancelUserInfoEntranceAnim() {
        if (this.mUserInfoGroup != null) {
            this.mUserInfoGroup.clearAnimation();
        }
    }

    public boolean isMount() {
        return this.isMount;
    }

    public void setMount(boolean mount) {
        this.isMount = mount;
    }

    public void startGiftAnimation() {
        if (this.mGiftRule != null) {
            this.startGiftAnimation(this.mGiftRule);
        }
    }

    private void initUserInfoView(Context context, ViewGroup group, GiftFrom from, int viewWidth, int z, boolean orientation_land) {
        if (this.mUserInfoGroup == null) {
            View userInfoGroup;
            int resource = from == GiftFrom.VIDEO ? R.layout.meipai_live_video_gift_user_info_view : (from == GiftFrom.LIVE ? R.layout.meipai_live_gift_user_name_view : R.layout.meipai_live_large_gift_user_name_view);
            this.mUserInfoGroup = userInfoGroup = LayoutInflater.from((Context)context).inflate(resource, null);
            this.mUserInfoView = (TextView)userInfoGroup.findViewById(R.id.tv_user_name);
            this.mGiftNameView = (TextView)userInfoGroup.findViewById(R.id.tv_gift_name);
            this.mAvatarView = (ImageView)userInfoGroup.findViewById(R.id.ivw_avatar);
            this.mVerifiedView = (ImageView)userInfoGroup.findViewById(R.id.ivw_v);
        } else {
            this.mUserInfoView.setVisibility(4);
            if (this.mAvatarView != null) {
                this.mAvatarView.setImageDrawable(AvatarRoundUtil.getRoundAvatar(this.mAvatarView.getContext(), R.drawable.meipai_default_avatar_small));
            }
        }
        if (this.mGiftNameView != null) {
            this.mGiftNameView.setVisibility(8);
        }
        this.mUserInfoGroup.setVisibility(8);
        this.mUserInfoView.setOnClickListener(this.userClickListener);
        if (this.mAvatarView != null && from == GiftFrom.LIVE) {
            this.mAvatarView.setOnClickListener(this.userClickListener);
        }
        int marginTop = 0;
        int userInfoWidth = 0;
        int userInfoHeight = -2;
        int position = 3;
        if (from == GiftFrom.VIDEO) {
            marginTop = DipUtils.dip2px(6.0f);
            userInfoWidth = viewWidth - (int)BasicConfig.getInstance().getAppContext().getResources().getDimension(R.dimen.meipai_live_gift_user_info_margin) * 2;
            position = 3;
        } else if (from == GiftFrom.LIVE) {
            int maxWidth = DipUtils.dip2px(114.0f);
            this.mUserInfoView.setMaxWidth(maxWidth);
            if (this.mGiftNameView != null) {
                this.mGiftNameView.setMaxWidth(maxWidth);
            }
            userInfoWidth = (int)BasicConfig.getInstance().getAppContext().getApplicationContext().getResources().getDimension(R.dimen.meipai_live_gift_user_info_max_width);
            marginTop = 0;
            position = 0;
            userInfoHeight = this.mUserInfoGroupHeight = (int)BasicConfig.getInstance().getAppContext().getResources().getDimension(R.dimen.meipai_live_large_gift_user_info_group_height);
        } else if (from == GiftFrom.LARGE) {
            float maxWidth;
            float desireW;
            if (null == this.mGiftMessage) {
                return;
            }
            String userName = this.mGiftMessage != null ? this.mGiftMessage.getUserName() : "";
            MLog.info((Object)TAG, (String)("mGiftMessage is empty:" + (null == this.mGiftMessage) + ",mGiftMessage.getUserName():" + (this.mGiftMessage != null ? this.mGiftMessage.getUserName() : null) + ", userName:" + (null == userName ? "null" : userName)), (Object[])new Object[0]);
            if (TextUtils.isEmpty((CharSequence)userName)) {
                userName = "";
            }
            userInfoWidth = (desireW = StaticLayout.getDesiredWidth((CharSequence)userName, (TextPaint)this.mUserInfoView.getPaint()) + (float)DipUtils.dip2px(51.0f)) > (maxWidth = (float)DipUtils.dip2px(170.0f)) ? (int)maxWidth : (int)desireW;
            marginTop = DipUtils.dip2px(7.0f);
            position = 2;
            if (this.mUserInfoGroupHeight <= 0) {
                this.mUserInfoGroupHeight = (int)BasicConfig.getInstance().getAppContext().getResources().getDimension(R.dimen.meipai_live_large_gift_user_info_group_height);
            }
            userInfoHeight = this.mUserInfoGroupHeight;
            float scaleTmp = orientation_land ? 0.56f : 1.0f;
            this.mUserInfoGroup.setScaleX(scaleTmp);
            this.mUserInfoGroup.setScaleY(scaleTmp);
        }
        ViewGroup.LayoutParams userInfoParams = new ViewGroup.LayoutParams(userInfoWidth, userInfoHeight);
        float screenNamePositionX = 0.0f;
        float screenNamePositionY = 0.0f;
        if (this.mGiftMessage != null) {
            screenNamePositionX = this.mGiftMessage.getScreen_name_x();
            screenNamePositionY = this.mGiftMessage.getScreen_name_y();
        }
        if (screenNamePositionX > 0.0f && screenNamePositionY > 0.0f) {
            float[] posXY = this.getUserInfoTranslationXY(userInfoWidth, screenNamePositionX, screenNamePositionY, orientation_land);
            this.mUserInfoGroup.setTranslationX(posXY[0]);
            this.mUserInfoGroup.setTranslationY(posXY[1]);
        } else {
            this.addViewAlignTo(this.mUserInfoGroup, userInfoParams.width, userInfoParams.height, position, true, 0.0f, (float)marginTop, 1.0f);
        }
        this.mUserInfoGroupOffsetX = this.mUserInfoGroup.getTranslationX() - this.mImageLeft;
        this.mUserInfoGroupOffsetY = this.mUserInfoGroup.getTranslationY() - this.mImageTop;
        group.addView(this.mUserInfoGroup, z >= 0 ? z : -1, userInfoParams);
    }

    private float[] getUserInfoTranslationXY(int userInfoWidth, float screenNamePositionX, float screenNamePositionY, boolean orientation_land) {
        if (orientation_land) {
            int getAreaH = this.mGroupHeight;
            int scaleUserInfoW = (int)((float)userInfoWidth * 1.0f);
            int scaleUserInfoH = (int)((float)DipUtils.dip2px(17.0f) * 1.0f);
            float giftAreaW = 0.56f * (float)getAreaH;
            float userInfoLeftStart = this.mImageLeft - (giftAreaW - (float)this.getGiftImageWidth()) / 2.0f;
            float positionX = giftAreaW * screenNamePositionX - (float)(scaleUserInfoW >> 1) + userInfoLeftStart;
            float positionY = screenNamePositionY * (float)getAreaH - (float)(scaleUserInfoH >> 1);
            return new float[]{positionX, positionY};
        }
        float transX = screenNamePositionX * (float)this.mGroupWidth - (float)(userInfoWidth >> 1);
        float transY = screenNamePositionY * (float)this.mGroupHeight - (float)(DipUtils.dip2px(17.0f) >> 1);
        return new float[]{transX, transY};
    }

    protected abstract void addGiftImage(Context var1, ViewGroup var2, float var3, float var4, int var5);

    protected abstract Object getGiftImage();

    public int getGiftImageWidth() {
        return this.mImageWidth;
    }

    public int getGiftImageHeight() {
        return this.mImageHeight;
    }

    public float getGiftImageLeft() {
        return this.mImageLeft;
    }

    public float getGiftImageTop() {
        return this.mImageTop;
    }

    public boolean hasInitImagePosition() {
        return this.mHasInitImagePosition;
    }

    public void setGiftImagePosition(float x, float y) {
        this.mImageLeft = x;
        this.mImageTop = y;
        this.mHasInitImagePosition = true;
    }

    public void init(float viewWidth, float viewHeight, int imageWidth, int imageHeight, float scale) {
        this.mCurrentState = -1;
        this.mImageScale = scale;
        this.mHasInitImagePosition = false;
        this.mGroupWidth = (int)viewWidth;
        this.mGroupHeight = (int)viewHeight;
        this.decodeBeginningAnimation(this.mGiftRule, viewWidth, viewHeight, imageWidth, imageHeight);
        this.mImageWidth = (int)((float)imageWidth * this.mImageScale);
        this.mImageHeight = (int)((float)imageHeight * this.mImageScale);
    }

    public String getGiftImagePath() {
        if (this.mGiftMessage != null && this.mGiftRule != null) {
            String imagePath = this.mGiftRule.type == 3 ? GiftTarget.getMultiImagePathFormat(this.mGiftRule, this.mGiftMessage.getGiftLocalPath()) : this.mGiftMessage.getGiftLocalPath() + "/" + this.mGiftRule.image;
            return imagePath;
        }
        return null;
    }

    public static String getMultiImagePathFormat(GiftRule rule, String path) {
        if (rule == null || path == null) {
            return null;
        }
        if (rule.image != null) {
            return path + "/" + rule.image;
        }
        return path + "/" + rule.image_prefix + "%d" + rule.image_extension;
    }

    protected void addViewAlignTo(BasicTransformations view, int viewWidth, int viewHeight, int position, boolean center, float marginX, float marginY, float scale) {
        float[] trans = this.addViewAlignTo(viewWidth, viewHeight, position, center, marginX, marginY, scale);
        if (viewWidth > 0 && scale != 1.0f) {
            trans[0] = trans[0] - (1.0f - scale) / 2.0f * (float)viewWidth;
        }
        if (viewHeight > 0 && scale != 1.0f) {
            trans[1] = trans[1] - (1.0f - scale) / 2.0f * (float)viewHeight;
        }
        view.setTranslationX(trans[0]);
        view.setTranslationY(trans[1]);
    }

    protected void addViewAlignTo(View view, int viewWidth, int viewHeight, int position, boolean center, float marginX, float marginY, float scale) {
        float[] trans = this.addViewAlignTo(viewWidth, viewHeight, position, center, marginX, marginY, scale);
        if (viewWidth > 0 && scale != 1.0f) {
            trans[0] = trans[0] - (1.0f - scale) / 2.0f * (float)viewWidth;
        }
        if (viewHeight > 0 && scale != 1.0f) {
            trans[1] = trans[1] - (1.0f - scale) / 2.0f * (float)viewHeight;
        }
        if (trans[0] < 0.0f) {
            trans[0] = DipUtils.dip2px(20.0f);
        }
        view.setTranslationX(trans[0]);
        if (trans[1] < (float)this.mUserInfoViewMarginTop) {
            trans[1] = ResolutionUtils.getScreenHeight((Context)BasicConfig.getInstance().getAppContext()) / 2;
        }
        view.setTranslationY(trans[1]);
    }

    protected float[] addViewAlignTo(int viewWidth, int viewHeight, int position, boolean center, float marginX, float marginY, float scale) {
        float x = 0.0f;
        float y = 0.0f;
        float[] trans = new float[2];
        float alignX = this.mImageLeft + (1.0f - scale) / 2.0f * (float)this.mImageWidth;
        float alignY = this.mImageTop + (1.0f - scale) / 2.0f * (float)this.mImageHeight;
        float alignToWidth = (float)this.mImageWidth * scale;
        float alignToHeight = (float)this.mImageHeight * scale;
        if (position == 0) {
            x = alignX - (float)viewWidth + marginX;
            y = alignY + marginY;
            if (center) {
                y += (alignToHeight - (float)viewHeight) / 2.0f;
            }
        } else if (position == 1) {
            x = alignX + alignToWidth + marginX;
            y = alignY + marginY;
            if (center) {
                y += (alignToHeight - (float)viewHeight) / 2.0f;
            }
        } else if (position == 2) {
            x = alignX + marginX;
            y = alignY - (float)viewHeight - marginY;
            if (center) {
                x += (alignToWidth - (float)viewWidth) / 2.0f;
            }
        } else if (position == 3) {
            x = alignX + marginX;
            y = alignY + alignToHeight + marginY;
            if (center) {
                x += (alignToWidth - (float)viewWidth) / 2.0f;
            }
        }
        trans[0] = x;
        trans[1] = y;
        return trans;
    }

    protected void startGiftAnimation(GiftRule rule) {
        this.mDuration = rule.display_time;
        this.mCurrentState = 0;
        this.mCurrentCombo = 0;
        if (null != this.mGiftRule && this.mGiftRule.end_animation != null) {
            this.mEndingAnimation = new GiftAnimation(this.mGiftRule.end_animation);
        }
        this.setUserInfo(this.mGiftMessage);
        this.startBeginningAnimation();
    }

    private void startBeginningAnimation() {
        if (this.mStartAnimations == null) {
            this.afterBeginningAnimation();
            return;
        }
        if (this.mGiftFrom == GiftFrom.LARGE) {
            this.showUserInfo();
        }
        this.mCurrentBeginningIndex = 0;
        GiftAnimation animation = this.mStartAnimations[0];
        if (animation != null) {
            animation.setAutoUpdate(this.isAutoUpdateStartAnimation());
            animation.start((BasicTransformations)this.getGiftImage(), (Animator.AnimatorListener)this.mBeginningAnimatorListener);
            this.checkMoveUserInfoGroupWithImage(animation);
        }
    }

    private void checkMoveUserInfoGroupWithImage(GiftAnimation animation) {
        if (this.mGiftFrom == GiftFrom.LARGE && animation.hasPath()) {
            animation.setAnimatorUpdateListener(this.mAnimateUserInfoGroupCallBack);
        }
    }

    private boolean isAutoUpdateStartAnimation() {
        return !this.mIsSupprotEGL || this.mGiftFrom == GiftFrom.LARGE;
    }

    private void decodeBeginningAnimation(GiftRule rule, float viewWidth, float viewHeight, int imageWidth, int imageHeight) {
        if (rule.start_animation == null || rule.start_animation.size() == 0) {
            return;
        }
        if (this.mStartAnimations == null) {
            this.mStartAnimations = new GiftAnimation[rule.start_animation.size()];
        }
        if (rule.start_animation != null && rule.start_animation.size() > 0) {
            float finalScale = 0.0f;
            for (int i = rule.start_animation.size() - 1; i >= 0; --i) {
                GiftAnimation animation;
                GiftAnimationParams params = rule.start_animation.get(i);
                this.mStartAnimations[i] = animation = new GiftAnimation(params);
                if (i == rule.start_animation.size() - 1 && (finalScale = animation.getScaleTo()) > 0.0f) {
                    this.mImageScale *= finalScale;
                }
                if (finalScale != 1.0f && finalScale > 0.0f) {
                    animation.setScaleFrom(animation.getScaleFrom() / finalScale);
                    animation.setScaleTo(animation.getScaleTo() / finalScale);
                }
                PointF[] points = null;
                PointF[] controls = null;
                if (params.positions != null && (points = this.getPositionPoint(params.positions, viewWidth, viewHeight, imageWidth, imageHeight, this.mImageScale)) != null && !this.mHasInitImagePosition) {
                    this.mHasInitImagePosition = true;
                    this.mImageLeft = points[points.length - 1].x;
                    this.mImageTop = points[points.length - 1].y;
                }
                if (params.control_point != null) {
                    controls = this.getPositionPoint(params.control_point, viewWidth, viewHeight, imageWidth, imageHeight, this.mImageScale);
                }
                if (points == null) continue;
                animation.initPath(points, controls);
            }
        }
    }

    private PointF[] getPositionPoint(ArrayList<GiftPosition> positions, float viewWidth, float viewHeight, int imageWidth, int imageHeight, float scale) {
        PointF[] pointFs = new PointF[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            pointFs[i] = positions.get(i).getPosition(viewWidth, viewHeight, (int)((float)imageWidth * scale), (int)((float)imageHeight * scale), scale);
        }
        return pointFs;
    }

    private void updateBeginningAnimation() {
        if (this.mStartAnimations != null) {
            for (GiftAnimation animation : this.mStartAnimations) {
                if (animation == null) continue;
                animation.requestUpdate();
            }
        }
    }

    public void addBeginningAnimation(GiftAnimation beginningAnimation) {
        if (this.mStartAnimations == null) {
            this.mStartAnimations = new GiftAnimation[1];
        }
        this.mStartAnimations[0] = beginningAnimation;
    }

    public void setUserInfo(GiftMessage message) {
        if (this.mUserInfoView != null) {
            this.mUserInfoView.setVisibility(0);
            if (this.mGiftFrom == GiftFrom.VIDEO) {
                String userName = message.getAnchorName();
                this.mUserInfoView.setText((CharSequence)userName);
            } else {
                this.mUserInfoView.setText((CharSequence)message.getUserName());
                if (this.mGiftFrom == GiftFrom.LIVE) {
                    this.setGiftName(message.getGiftName(), message.getPopularity_of_gift());
                } else {
                    FansMedalBean fansMedalBean = new FansMedalBean();
                    try {
                        String giverMedalID = message.getGiverMedalID();
                        fansMedalBean.setId(TextUtils.isEmpty((CharSequence)giverMedalID) ? 0L : Long.parseLong(giverMedalID));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    SpanUtils.addFansMedal(this.mUserInfoView, 2, fansMedalBean);
                }
            }
        }
    }

    public void setOnUserInfoClickListener(OnUserInfoClickListener onUserInfoClickListener) {
        this.mOnUserInfoClickListener = onUserInfoClickListener;
    }

    public void setGiftName(String giftName, long popularity) {
        if (this.mGiftNameView != null && !TextUtils.isEmpty((CharSequence)giftName)) {
            if (this.mGiftFrom == GiftFrom.LIVE) {
                String giftNameStr = String.format(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_live_gift_send_text_des), giftName);
                if (popularity > 0L) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String popularityCount = String.format(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_live_live_popularity_gift_count), popularity);
                    stringBuilder.append(giftNameStr).append(popularityCount);
                    giftNameStr = stringBuilder.toString();
                }
                this.mGiftNameView.setText((CharSequence)giftNameStr);
            } else {
                this.mGiftNameView.setText((CharSequence)giftName);
            }
            this.mGiftNameView.setVisibility(0);
        } else if (this.mGiftNameView != null) {
            this.mGiftNameView.setVisibility(8);
        }
    }

    public boolean updateCombPoint(final GiftMessage message, boolean clearDisplayTime) {
        if (this.mCurrentState >= 3) {
            return false;
        }
        int from = message.getComboFrom();
        int to = message.getComboTo();
        if (this.mCurrentState == 2 || this.mCurrentState <= 0) {
            this.mGiftMessage.setComboTo(Math.max(to, this.mGiftMessage.getComboTo()));
            if (clearDisplayTime && this.mCurrentState != -1) {
                this.postDelayToDismiss();
            }
        } else if (this.mComboViewTarget != null) {
            this.mCurrentState = 2;
            this.mGiftMessage.setComboTo(Math.max(to, this.mGiftMessage.getComboTo()));
            this.mCurrentCombo = Math.max(from, this.mCurrentCombo + 1);
            this.mComboViewTarget.setCombopoint(this.mCurrentCombo);
            this.updateComboViewPosition(this.mComboViewMaxScale);
            this.mComboViewTarget.setVisibility(true);
            this.startAddComboAnimation();
            if (clearDisplayTime) {
                this.postDelayToDismiss();
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    GiftTarget.this.setGiftName(message.getGiftName(), message.getPopularity_of_gift());
                }
            });
        }
        return true;
    }

    public void initResetParams() {
        this.mTargetTranslationY = 0.0f;
    }

    public void setGiftRule(GiftRule rule) {
        this.mGiftRule = rule;
    }

    public GiftRule getGiftRule() {
        return this.mGiftRule;
    }

    public void setGiftMessage(GiftMessage message) {
        this.mGiftMessage = message;
        if (message == null) {
            return;
        }
        if (message.getComboFrom() + 10 < message.getComboTo()) {
            message.setComboFrom(message.getComboTo() - 10);
        }
    }

    public GiftMessage getGiftMessage() {
        return this.mGiftMessage;
    }

    @Override
    public void setTranslationX(float x) {
        ((BasicTransformations)this.getGiftImage()).setTranslationX(x);
        this.mComboViewTarget.setTranslationX(x);
        if (null != this.mUserInfoGroup) {
            this.mUserInfoGroup.setTranslationX(x);
        }
    }

    public void translateGiftImageY(float y) {
        Object giftImage = this.getGiftImage();
        if (giftImage instanceof BasicTransformations) {
            ((BasicTransformations)giftImage).setTranslationY(y);
        }
    }

    @Override
    public void setTranslationY(float y) {
        this.translateGiftImageY(y);
        this.mComboViewTarget.setTranslationY(y);
        if (null != this.mUserInfoGroup) {
            this.mUserInfoGroup.setTranslationY(y);
        }
    }

    @Override
    public float getTranslationX() {
        return 0.0f;
    }

    @Override
    public float getTranslationY() {
        return 0.0f;
    }

    @Override
    public void setAlpha(float alpha) {
        ((BasicTransformations)this.getGiftImage()).setAlpha(alpha);
        this.mComboViewTarget.setAlpha(alpha);
        if (null != this.mUserInfoGroup) {
            this.mUserInfoGroup.setAlpha(alpha);
        }
    }

    @Override
    public float getAlpha() {
        return 0.0f;
    }

    @Override
    public void setScaleX(float scaleX) {
        ((BasicTransformations)this.getGiftImage()).setScaleX(scaleX);
        this.mComboViewTarget.setScaleX(scaleX);
        if (null != this.mUserInfoGroup) {
            this.mUserInfoGroup.setScaleX(scaleX);
        }
    }

    @Override
    public void setScaleY(float scaleY) {
        ((BasicTransformations)this.getGiftImage()).setScaleY(scaleY);
        this.mComboViewTarget.setScaleY(scaleY);
        if (null != this.mUserInfoGroup) {
            this.mUserInfoGroup.setScaleY(scaleY);
        }
    }

    @Override
    public float getScaleX() {
        return 0.0f;
    }

    @Override
    public float getScaleY() {
        return 0.0f;
    }

    @Override
    public void setRotation(float rotation) {
        ((BasicTransformations)this.getGiftImage()).setRotation(rotation);
        this.mComboViewTarget.setRotation(rotation);
        if (null != this.mUserInfoGroup) {
            this.mUserInfoGroup.setRotation(rotation);
        }
    }

    @Override
    public float getRotation() {
        return 0.0f;
    }

    public boolean isImageTargetDismiss() {
        return this.mCurrentState == 4;
    }

    public boolean canReplace() {
        return this.mCurrentState >= 3;
    }

    public void remove() {
        if (this.mCurrentState != 4) {
            this.onGiftAnimationEnd();
        }
    }

    protected boolean afterBeginningAnimation() {
        if (this.mCurrentState != 0) {
            return false;
        }
        this.mCurrentState = 1;
        this.postDelayToDismiss();
        int comboTo = this.mGiftMessage.getComboTo();
        if (this.mGiftFrom == GiftFrom.VIDEO || this.mGiftFrom != GiftFrom.LIVE && this.mStartAnimations == null) {
            this.showUserInfo();
        }
        this.mStartAnimations = null;
        if (comboTo > 0) {
            this.updateCombPoint(this.mGiftMessage, false);
        }
        this.startMidGiftAnimation();
        return true;
    }

    private void showUserInfo() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            if (null != this.mUserInfoGroup) {
                this.mUserInfoGroup.setVisibility(0);
            }
            if (this.mGiftFrom != GiftFrom.LIVE) {
                this.startUserInfoShowAnimation();
            }
            if (this.mGiftNameView != null) {
                this.setGiftName(this.mGiftMessage.getGiftName(), this.mGiftMessage.getPopularity_of_gift());
            }
            if (this.mAvatarView != null) {
                Glide.with((Context)this.mAvatarView.getContext().getApplicationContext()).load(this.mGiftMessage.getAvatar()).apply(RequestOptions.circleCropTransform().placeholder(AvatarRoundUtil.getRoundAvatar(this.mAvatarView.getContext(), R.drawable.meipai_default_avatar_small))).into(this.mAvatarView);
            }
            if (this.mVerifiedView != null) {
                this.mVerifiedView.setVisibility(this.mGiftMessage.isVerified() ? 0 : 8);
            }
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (GiftTarget.this.mCurrentState != 4) {
                        if (null != GiftTarget.this.mUserInfoGroup) {
                            GiftTarget.this.mUserInfoGroup.setVisibility(0);
                        }
                        if (GiftTarget.this.mGiftFrom != GiftFrom.LIVE) {
                            GiftTarget.this.startUserInfoShowAnimation();
                        }
                        if (GiftTarget.this.mGiftNameView != null) {
                            GiftTarget.this.setGiftName(GiftTarget.this.mGiftMessage.getGiftName(), GiftTarget.this.mGiftMessage.getPopularity_of_gift());
                        }
                        if (GiftTarget.this.mAvatarView != null) {
                            Glide.with((Context)GiftTarget.this.mAvatarView.getContext().getApplicationContext()).load(GiftTarget.this.mGiftMessage.getAvatar()).apply(RequestOptions.circleCropTransform().placeholder(AvatarRoundUtil.getRoundAvatar(GiftTarget.this.mAvatarView.getContext(), R.drawable.meipai_default_avatar_small))).into(GiftTarget.this.mAvatarView);
                        }
                        if (GiftTarget.this.mVerifiedView != null) {
                            GiftTarget.this.mVerifiedView.setVisibility(GiftTarget.this.mGiftMessage.isVerified() ? 0 : 8);
                        }
                    }
                }
            });
        }
    }

    private void startUserInfoShowAnimation() {
        if (this.mUserInfoShowAnimation != null) {
            this.mUserInfoShowAnimation.cancel();
        }
        this.mUserInfoShowAnimation = FrameAnimator.ofFloat(0.0f, 1.0f);
        this.mUserInfoShowAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                if (null != GiftTarget.this.mUserInfoGroup) {
                    GiftTarget.this.mUserInfoGroup.setAlpha(valueAnimator.getAnimatedFraction());
                }
            }
        });
        this.mUserInfoShowAnimation.setDuration(300L);
        this.mUserInfoShowAnimation.start();
    }

    private void startAddComboAnimation() {
        if (this.mAddComboAnimation != null) {
            this.mAddComboAnimation.cancel();
            this.mAddComboAnimation = null;
        }
        this.mComboViewTarget.setScaleX(0.0f);
        this.mComboViewTarget.setScaleX(0.0f);
        this.mAddComboAnimation = FrameAnimator.ofFloat(0.8f, 1.5f, 1.0f);
        this.mAddComboAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                GiftTarget.this.mComboViewTarget.setScaleX(value * GiftTarget.this.mComboViewMaxScale);
                GiftTarget.this.mComboViewTarget.setScaleY(value * GiftTarget.this.mComboViewMaxScale);
            }
        });
        this.mAddComboAnimation.addListener((Animator.AnimatorListener)this.mComboAnimationEndListener);
        this.mAddComboAnimation.setStartDelay(10L);
        this.mAddComboAnimation.setDuration(166L);
        if (!this.mIsSupprotEGL) {
            this.mAddComboAnimation.start();
        }
    }

    private void postDelayToDismiss() {
        if (null != this.mHandler) {
            this.mHandler.removeCallbacks(this.mDismissRunnable);
            this.mHandler.postDelayed(this.mDismissRunnable, this.mDuration);
        }
    }

    protected void onGiftAnimationEnd() {
        if (this.mCurrentState == 4) {
            return;
        }
        this.mCurrentState = 4;
        if (this.mRootGroup != null) {
            if (this.mEndingAnimation != null) {
                this.mEndingAnimation.cancel();
            }
            if (this.mMidAnimation != null) {
                this.mMidAnimation.cancel();
            }
            this.setAlpha(1.0f);
            this.setScaleX(1.0f);
            this.setScaleY(1.0f);
            this.mEndingAnimation = null;
            this.mMidAnimation = null;
            if (null != this.mUserInfoGroup) {
                this.mRootGroup.removeView(this.mUserInfoGroup);
            }
            if (null != this.mComboViewTarget) {
                this.mComboViewTarget.remove(this.mRootGroup);
            }
            this.mRootGroup = null;
        }
        this.mAddComboAnimation = null;
        this.cancelBeginningAnimation();
        if (null != this.mGiftMessage) {
            this.mGiftMessage.setEggMessage(null);
        }
        this.setEggTarget(null);
        this.mGiftMessage = null;
        this.mGiftRule = null;
        if (null != this.mHandler) {
            this.mHandler.removeCallbacks(this.mDismissRunnable);
        }
        if (this.mGiftImageDismissListener != null) {
            this.mGiftImageDismissListener.onGiftDismiss(this);
        }
        if (null != this.mUserInfoEntranceAnimator) {
            this.mUserInfoEntranceAnimator.cancel();
        }
        this.mUserInfoEntranceAnimator = null;
    }

    protected void onGiftAnimationFailed() {
        this.mHandler.removeCallbacks(this.mDismissRunnable);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GiftTarget.this.mCurrentState != 4) {
                    GiftTarget.this.onGiftAnimationEnd();
                }
            }
        });
    }

    private void cancelBeginningAnimation() {
        if (this.mStartAnimations != null) {
            for (int i = 0; i < this.mStartAnimations.length; ++i) {
                GiftAnimation animation = this.mStartAnimations[i];
                if (animation == null) continue;
                animation.cancel();
            }
        }
        this.mStartAnimations = null;
    }

    public int getType() {
        return this.mType;
    }

    public void updateGiftPosition(float y) {
        if (this.mCurrentState == 1 || this.mCurrentState == 2) {
            this.mImageTop += y;
            BasicTransformations giftImage = (BasicTransformations)this.getGiftImage();
            giftImage.setTranslationY(giftImage.getTranslationY() + y);
            this.mComboViewTarget.setTranslationY(this.mComboViewTarget.getTranslationY() + y);
            if (null != this.mUserInfoGroup) {
                this.mUserInfoGroup.setTranslationY(this.mUserInfoGroup.getTranslationY() + y);
            }
            if (null != this.mGiftPositionChangedListener && this.getEggTarget() != null) {
                this.mGiftPositionChangedListener.onChanged(this, this.getEggTarget(), -1.0f, y);
            }
        }
    }

    public void setGiftImageDismissListener(GiftImageDismissListener listener2) {
        this.mGiftImageDismissListener = listener2;
    }

    public final int onTextureDraw(GlAnimationView gl, int z) {
        if (this.mCurrentState == -1) {
            return z;
        }
        this.updateBeginningAnimation();
        z = this.onChildTextureDraw(gl, z);
        if (this.mComboViewTarget != null && this.mComboViewTarget instanceof ComboPointGLTarget) {
            if (this.mAddComboAnimation != null && !this.mAddComboAnimation.isAnimatorEnd()) {
                this.mAddComboAnimation.requestUpdate();
            }
            ((ComboPointGLTarget)this.mComboViewTarget).onTextureDraw(gl, z++);
        }
        return z;
    }

    public abstract int onChildTextureDraw(GlAnimationView var1, int var2);

    public void offsetGiftPath(float dx, float dy, float viewWidth, float viewHeight) {
        if (this.mCurrentState == -1) {
            if (this.mImageLeft + (float)this.mImageWidth + dx > viewWidth) {
                dx = viewWidth - this.mImageLeft - (float)this.mImageWidth;
                if (this.mImageLeft + dx < 0.0f) {
                    dx = (this.mImageLeft + dx) / 2.0f - this.mImageLeft;
                }
            } else if (this.mImageLeft + dx < 0.0f && this.mImageLeft + (float)this.mImageWidth + (dx = -this.mImageLeft) > viewWidth) {
                float extra = this.mImageLeft + (float)this.mImageWidth + dx - viewWidth;
                dx -= extra / 2.0f;
            }
            if (this.mUserInfoGroupHeight <= 0) {
                this.mUserInfoGroupHeight = (int)BasicConfig.getInstance().getAppContext().getResources().getDimension(R.dimen.meipai_live_large_gift_user_info_group_height);
            }
            if (this.mImageTop + (float)this.mImageHeight + dy > viewHeight) {
                dy = viewHeight - this.mImageTop - (float)this.mImageHeight;
            }
            this.mImageLeft += dx;
            this.mImageTop += dy;
            if (this.mStartAnimations == null) {
                return;
            }
            for (GiftAnimation animation : this.mStartAnimations) {
                if (animation == null) continue;
                animation.offsetPath(dx, dy);
            }
        }
    }

    public void setMemoryUsage(long usage) {
        this.mMemoryUsage = usage;
    }

    public long getMemoryUsage() {
        return this.mMemoryUsage;
    }

    public void updateTargetScale(float scale) {
        if (scale == this.mTargetScale || this.mCurrentState == 4) {
            return;
        }
        GiftAnimation animation = new GiftAnimation();
        animation.setScaleFrom(this.mTargetScale);
        animation.setScaleTo(scale);
        animation.setDuration(300L);
        animation.setAnimatorUpdateListener(this.mAnimateUserInfoGroupCallBack);
        animation.setAutoUpdate(true);
        animation.setEnableInitScale(false);
        this.mTargetScale = scale;
        this.setMidGiftAnimation(animation);
        this.startMidGiftAnimation();
    }

    public void updateYPostion(float fromY, float toY) {
        if (toY == this.mTargetTranslationY || this.mCurrentState == 4) {
            return;
        }
        this.mTargetTranslationY = toY;
        if (null != this.mGiftPositionChangedListener && this.getEggTarget() != null) {
            this.mGiftPositionChangedListener.onChanged(this, this.getEggTarget(), -1.0f, toY);
        }
        GiftAnimation animation = new GiftAnimation();
        animation.setTransFromY(fromY);
        animation.setTransToY(toY);
        animation.setDuration(300L);
        animation.setAnimatorUpdateListener(this.mAnimateUserInfoGroupCallBack);
        animation.setAutoUpdate(true);
        this.setMidGiftAnimation(animation);
        this.startMidGiftAnimation();
    }

    private void setMidGiftAnimation(GiftAnimation animation) {
        if (this.mMidAnimation != null) {
            this.mMidAnimation.cancel();
        }
        this.mMidAnimation = animation;
    }

    private void startMidGiftAnimation() {
        if (this.mMidAnimation != null && this.mCurrentState > 0 && this.mCurrentState < 4) {
            if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (GiftTarget.this.mMidAnimation != null) {
                            GiftTarget.this.mMidAnimation.start((BasicTransformations)GiftTarget.this.getGiftImage());
                        }
                    }
                });
            } else {
                this.mMidAnimation.start((BasicTransformations)this.getGiftImage());
            }
        }
    }

    private void updateComboViewPosition(float scale) {
        int comboWidth = this.mComboViewTarget.getComboWidth();
        int comboHeight = this.mComboViewTarget.getComboHeight();
        int marginLeft = (int)((scale - 1.0f) / 2.0f * (float)comboWidth);
        this.mComboViewMaxScale = scale;
        this.addViewAlignTo(this.mComboViewTarget, comboWidth, comboHeight, 1, true, (float)marginLeft, 0.0f, 1.0f);
        if (this.mAddComboAnimation == null) {
            this.mComboViewTarget.setScaleX(scale);
            this.mComboViewTarget.setScaleY(scale);
        }
    }

    public static interface OnUserInfoClickListener {
        public void onClick(GiftMessage var1);
    }

    public static interface GiftImageDismissListener {
        public void onGiftDismiss(GiftTarget var1);
    }

    public static enum GiftFrom {
        LIVE,
        VIDEO,
        LARGE,
        LIVE_EGG;

    }
}

