/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.unionyy.mobile.meipai.preview.core.IStickerFilterCore;
import com.unionyy.mobile.meipai.preview.core.LevelOfEffect;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.pref2.SharedPreferencesUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.MD5Utils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PkArManager {
    private static final String TAG = "PkArManager";
    private static final String PK_AR_STICKER_DIR = "pkarstickers";
    private static PkArManager instence;
    private Handler mHandler = new SafeDispatchHandler(Looper.getMainLooper());
    private Map<String, String> mUnZipFileNames = new HashMap<String, String>();
    private SharedPreferences mARGiftManagerPreferences = SharedPreferencesUtils.getSharedPreferences((Context)BasicConfig.getInstance().getAppContext(), (String)"PKARGiftManagerPreferences", (int)0);
    private volatile boolean isShouldShow;
    private static final String NOMEDIA = ".nomedia";
    private static final String PREFERENCE_KEY_RES_MD5_PRE_FIX = "res_md5_";
    private static final String PREFERENCE_NAME = "PKARGiftManagerPreferences";

    public PkArManager() {
        this.createArGiftDirFileIfNeed(BasicConfig.getInstance().getRootDir() + File.separator + PK_AR_STICKER_DIR);
    }

    public static PkArManager getInstence() {
        if (instence == null) {
            instence = new PkArManager();
        }
        return instence;
    }

    public void playPkArEffect(String url, int playLength) {
        MLog.info((Object)TAG, (String)"[PK][\u64ad\u653ePK AR\u7279\u6548]", (Object[])new Object[0]);
        if (FP.empty((CharSequence)url)) {
            return;
        }
        this.mHandler.removeCallbacksAndMessages(null);
        this.isShouldShow = true;
        this.removeInaccuracyStickerFileCache(url, this.mUnZipFileNames.get(url));
        String arFilePath = this.mUnZipFileNames.get(url);
        if (!TextUtils.isEmpty((CharSequence)arFilePath)) {
            ((IStickerFilterCore)CoreFactory.getCore(IStickerFilterCore.class)).setEffectByLevel(arFilePath, LevelOfEffect.MIDDLE);
            this.delayclearPkArEffect(playLength);
        } else {
            this.downloadARFileAndDCompressIfNeed(url, playLength);
        }
    }

    public void clearPkArEffect() {
        MLog.info((Object)TAG, (String)"[PK][\u79fb\u9664PK AR\u7279\u6548]", (Object[])new Object[0]);
        this.isShouldShow = false;
        this.mHandler.removeCallbacksAndMessages(null);
        ((IStickerFilterCore)CoreFactory.getCore(IStickerFilterCore.class)).cleanEffect(LevelOfEffect.MIDDLE);
    }

    private void createArGiftDirFileIfNeed(String path) {
        MLog.info((Object)TAG, (String)("[PK]path " + path), (Object[])new Object[0]);
        File stickerDir = new File(path);
        if (!stickerDir.exists()) {
            stickerDir.mkdir();
        }
        if (!stickerDir.isDirectory()) {
            stickerDir.delete();
            stickerDir.mkdir();
        }
        File file = new File(path + File.separator + NOMEDIA);
        MLog.info((Object)TAG, (String)("[PK] checkPathAndNoMedia path " + file.getAbsolutePath() + " exsit =" + file.exists()), (Object[])new Object[0]);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                MLog.info((Object)TAG, (String)("[PK] checkPathAndNoMedia error  " + e.toString()), (Object[])new Object[0]);
            }
        }
    }

    private String getZipFileNameByUrl(String url) {
        int index = url.lastIndexOf("/");
        String filePath = url.substring(index + 1, url.length());
        return filePath;
    }

    private void downloadARFileAndDCompressIfNeed(final String url, final int length) {
        String filePathFromUrl;
        File stickerPath;
        MLog.info((Object)TAG, (String)("[PK]downloadpkarFile " + url), (Object[])new Object[0]);
        File rootFile = BasicConfig.getInstance().getRootDir();
        if (!rootFile.exists()) {
            rootFile.mkdir();
        }
        if (!(stickerPath = new File(rootFile.getAbsolutePath() + File.separator + PK_AR_STICKER_DIR)).exists()) {
            stickerPath.mkdir();
        }
        if ((filePathFromUrl = this.getZipFileNameByUrl(url)) == null || filePathFromUrl.equals("")) {
            MLog.info((Object)TAG, (String)"[PK]get filepath from url failed, stop download!!!", (Object[])new Object[0]);
            return;
        }
        final String filePath = stickerPath.getAbsolutePath() + File.separator + filePathFromUrl;
        File file = new File(filePath);
        if (!file.exists()) {
            MLog.info((Object)TAG, (String)("[PK]download zip file path:" + filePath), (Object[])new Object[0]);
            RequestManager.instance().submitDownloadRequest(url, filePath, (ResponseListener)new ResponseListener<String>(){

                public void onResponse(String response) {
                    MLog.info((Object)PkArManager.TAG, (String)response.toString(), (Object[])new Object[0]);
                    PkArManager.this.decompressStickInfo(filePath, url, length);
                }
            }, new ResponseErrorListener(){

                public void onErrorResponse(RequestError error) {
                }
            }, new ProgressListener(){

                public void onProgress(ProgressInfo info) {
                }
            }, false, false);
        } else {
            MLog.info((Object)TAG, (String)("[PK]file excist ,unzip file path:" + filePath), (Object[])new Object[0]);
            this.decompressStickInfo(filePath, url, length);
        }
    }

    private String getUnzipResourceDirPath(String zipFileName) {
        File f = new File(BasicConfig.getInstance().getRootDir().getAbsolutePath() + File.separator + PK_AR_STICKER_DIR + File.separator + zipFileName + "_res");
        return f.getAbsolutePath();
    }

    private String cacheMd5(String upzipResourcePath) {
        Object[] resourceFiles = new File(upzipResourcePath).listFiles();
        if (FP.empty((Object[])resourceFiles)) {
            return "";
        }
        return this.filesMd5((File[])resourceFiles);
    }

    public String filesMd5(File[] files2) {
        if (files2 == null) {
            return "";
        }
        Arrays.sort(files2);
        StringBuilder builder = new StringBuilder();
        for (File file : files2) {
            if (!file.exists()) continue;
            builder.append(MD5Utils.fileMd5((File)file)).append("-");
        }
        return builder.toString();
    }

    private String getPreferenceResourceMd5Key(String unzipResourcePath) {
        if (TextUtils.isEmpty((CharSequence)unzipResourcePath)) {
            return "";
        }
        return PREFERENCE_KEY_RES_MD5_PRE_FIX + unzipResourcePath;
    }

    private String getPreferenceResourceMd5(String unzipResourcePath) {
        if (TextUtils.isEmpty((CharSequence)unzipResourcePath)) {
            return "";
        }
        return this.mARGiftManagerPreferences.getString(this.getPreferenceResourceMd5Key(unzipResourcePath), "");
    }

    private void setPreferenceResourceMd5(String unzipResourcePath, String md5) {
        if (TextUtils.isEmpty((CharSequence)unzipResourcePath)) {
            return;
        }
        this.mARGiftManagerPreferences.edit().putString(this.getPreferenceResourceMd5Key(unzipResourcePath), md5).apply();
    }

    @SuppressLint(value={"CheckResult"})
    private void decompressStickInfo(final String zipFilePath, final String url, final int length) {
        Observable.just((Object)0).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<Integer>(){

            public void accept(Integer i) {
                String unzipPath = PkArManager.this.getUnzipResourceDirPath(PkArManager.this.getZipFileNameByUrl(zipFilePath));
                File zipFile = new File(zipFilePath);
                try {
                    if (zipFile.exists()) {
                        FileUtil.unzip((File)zipFile, (String)unzipPath, (String)"");
                        zipFile.delete();
                        PkArManager.this.mUnZipFileNames.put(url, unzipPath);
                        String resourceMd5 = PkArManager.this.cacheMd5(unzipPath);
                        PkArManager.this.setPreferenceResourceMd5(unzipPath, resourceMd5);
                        MLog.info((Object)PkArManager.TAG, (String)("[PK]decompress done. isShouldShow=" + PkArManager.this.isShouldShow), (Object[])new Object[0]);
                        if (PkArManager.this.isShouldShow) {
                            ((IStickerFilterCore)CoreFactory.getCore(IStickerFilterCore.class)).setEffectByLevel(unzipPath, LevelOfEffect.MIDDLE);
                            PkArManager.this.delayclearPkArEffect(length);
                        }
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)PkArManager.TAG, (String)("[PK]ar pk gift decompress failed" + e), (Object[])new Object[0]);
                }
            }
        });
    }

    private void delayclearPkArEffect(int dalaytime) {
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                PkArManager.this.clearPkArEffect();
            }
        }, (long)(dalaytime * 1000));
    }

    private void removeInaccuracyStickerFileCache(String url, String unzipResourcePath) {
        if (url == null || TextUtils.isEmpty((CharSequence)unzipResourcePath)) {
            return;
        }
        String verifyMd5 = this.getPreferenceResourceMd5(unzipResourcePath);
        String cacheMd5 = this.cacheMd5(unzipResourcePath);
        if (TextUtils.isEmpty((CharSequence)verifyMd5) || !verifyMd5.equals(cacheMd5)) {
            FileUtil.delete((String)unzipResourcePath);
            this.mUnZipFileNames.remove(url);
        }
    }
}

