/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.danmaku.basic;

import android.graphics.Paint;
import android.text.TextUtils;

public class TextUtil {
    public static float getTextWidth(Paint paint, String text) {
        if (text == null) {
            return 0.0f;
        }
        if (paint == null) {
            paint = new Paint();
        }
        return paint.measureText(text);
    }

    public static float getTextHeight(Paint.FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            return 0.0f;
        }
        return -(fontMetrics.ascent + fontMetrics.descent);
    }

    public static boolean isEmpty(CharSequence charSequence) {
        boolean isEmpty = false;
        if (null == charSequence) {
            isEmpty = true;
        } else if (TextUtils.isEmpty((CharSequence)charSequence.toString().trim())) {
            isEmpty = true;
        } else if (charSequence.equals("null")) {
            isEmpty = true;
        }
        return isEmpty;
    }

    public static String handleText(String str, int maxLen) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        char[] ch = str.toCharArray();
        int varLength = 0;
        for (char c : ch) {
            if (c >= '\u2e80' && c <= '\ufe4f' || c >= '\u0080') {
                varLength += 2;
                continue;
            }
            ++varLength;
        }
        int count = 0;
        int endIndex = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c;
            c = str.charAt(i);
            varLength = c >= '\u2e80' && c <= '\ufe4f' || c >= '\u0080' ? (varLength += 2) : ++varLength;
            if (maxLen != count && (c < '\u0080' || maxLen + 1 != count)) continue;
            endIndex = i;
        }
        if (count <= maxLen) {
            return str;
        }
        return str.substring(0, endIndex) + "...";
    }

    public static int getTextLength(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return 0;
        }
        int varLength = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\u2e80' && c <= '\ufe4f' || c >= '\u0080') {
                varLength += 2;
                continue;
            }
            ++varLength;
        }
        return varLength;
    }
}

