/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.chat.codec.img.span;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.support.annotation.NonNull;
import android.text.style.ReplacementSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.unionyy.mobile.meipai.R;

public class FansClubSpan
extends ReplacementSpan {
    private static final float TEXT_PADDING_LEFT_DP = 9.5f;
    private static final float TEXT_PADDING_RIGHT_DP = 4.0f;
    private static final float TEXT_SIZE_DP = 8.0f;
    private static final float MIN_DRAWABLE_WIDTH_DP = 35.0f;
    private static final float LEVEL_NAME_MARGIN = 8.0f;
    private static final float LEVEL_WIDTH = 5.0f;
    private static final String LEVEL_COLOR = "#FF6756";
    private int mSpanWith;
    private int mSpanHeight;
    private int mLeftMargin;
    private int mRightMargin;
    private int mLeftPadding;
    private Rect mDrawableRect;
    private RectF mTargetRectF;
    private Paint mLevelPaint;
    private String mLevelText;
    private NinePatchDrawable mLevelDrawable;
    private String mClubName;
    private int mLevel;
    private Resources resources;

    public FansClubSpan(Resources resources, int level, int leftMargin, int rightMargin, String clubName) {
        this.resources = resources;
        this.mSpanWith = this.dip2px(54.0f);
        this.mSpanHeight = this.dip2px(14.0f);
        this.mLeftMargin = leftMargin;
        this.mRightMargin = rightMargin;
        this.mLeftPadding = this.dip2px(9.5f);
        int rightPadding = this.dip2px(4.0f);
        this.mLevelDrawable = (NinePatchDrawable)this.getLevelDrawable(level);
        this.mClubName = clubName;
        this.mLevel = level;
        this.mLevelText = this.mLevel + clubName;
        this.initPaint();
        if (this.mLevelDrawable != null) {
            int mDrawableHeight = this.mLevelDrawable.getIntrinsicHeight();
            float scale = mDrawableHeight / this.mSpanHeight;
            int mDrawableWidth = (int)((float)this.mSpanWith * scale);
            this.mDrawableRect = new Rect(0, 0, mDrawableWidth, mDrawableHeight);
            this.mTargetRectF = new RectF(0.0f, 0.0f, (float)this.mSpanWith, (float)this.mSpanHeight);
        }
    }

    private void initPaint() {
        this.mLevelPaint = new Paint(32);
        DisplayMetrics metrics = this.resources.getDisplayMetrics();
        float textSize = TypedValue.applyDimension((int)2, (float)9.0f, (DisplayMetrics)metrics);
        this.mLevelPaint.setTextSize(textSize);
        this.mLevelPaint.setColor(Color.parseColor((String)LEVEL_COLOR));
        this.mLevelPaint.setAntiAlias(true);
    }

    private void updateTextSize(boolean isReset) {
        DisplayMetrics metrics = this.resources.getDisplayMetrics();
        float textSize = TypedValue.applyDimension((int)2, (float)(isReset ? 8.0f : 9.0f), (DisplayMetrics)metrics);
        this.mLevelPaint.setTextSize(textSize);
        if (isReset) {
            this.mLevelPaint.setColor(Color.parseColor((String)LEVEL_COLOR));
        } else {
            this.mLevelPaint.setColor(-1);
        }
    }

    private Drawable getLevelDrawable(int level) {
        return this.resources.getDrawable(R.drawable.live_medals_fans_club);
    }

    public int getSize(Paint paint, CharSequence text, int start2, int end, Paint.FontMetricsInt fm) {
        return this.mSpanWith + this.mRightMargin;
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start2, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        if (this.mLevelDrawable == null) {
            return;
        }
        float transY = bottom - this.mSpanHeight;
        float transX = x + (float)this.mLeftMargin;
        canvas.translate(transX, transY -= (float)paint.getFontMetricsInt().descent);
        Bitmap bitmap = Bitmap.createBitmap((int)this.mDrawableRect.width(), (int)this.mDrawableRect.height(), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas bitmapCanvas = new Canvas(bitmap);
        this.mLevelDrawable.setBounds(this.mDrawableRect.left, this.mDrawableRect.top, this.mDrawableRect.right, this.mDrawableRect.bottom);
        this.mLevelDrawable.draw(bitmapCanvas);
        canvas.drawBitmap(bitmap, this.mDrawableRect, this.mTargetRectF, null);
        Bitmap bitmap1 = Bitmap.createBitmap((int)this.mSpanWith, (int)this.mSpanHeight, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas bitmapCanvas1 = new Canvas(bitmap1);
        float xCoordinate = this.mLeftPadding;
        Paint.FontMetrics fontMetrics = this.mLevelPaint.getFontMetrics();
        float f1 = fontMetrics.bottom - (fontMetrics.top + fontMetrics.ascent) / 2.0f;
        float yCoordinate = (float)this.mSpanHeight - ((float)this.mSpanHeight - f1) / 2.0f - fontMetrics.bottom;
        this.updateTextSize(true);
        bitmapCanvas1.drawText(this.mLevel + "", xCoordinate, yCoordinate, this.mLevelPaint);
        this.mLevelPaint.setColor(-1);
        this.updateTextSize(false);
        bitmapCanvas1.drawText(this.mClubName, xCoordinate += (float)this.dip2px(13.0f), yCoordinate, this.mLevelPaint);
        canvas.drawBitmap(bitmap1, new Rect(0, 0, this.mSpanWith, this.mSpanHeight), this.mTargetRectF, null);
        canvas.restore();
    }

    public int dip2px(float dipValue) {
        DisplayMetrics dm = this.resources.getDisplayMetrics();
        return (int)(dipValue * dm.density + 0.5f);
    }
}

