/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.ByteBuffer;

public class StreamUtils {
    public static final int IO_BUFFER_SIZE = 8192;
    private static final int END_OF_STREAM = -1;

    public static final void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final void copy(InputStream pInputStream, byte[] pData) throws IOException {
        int read;
        int dataOffset = 0;
        byte[] buf = new byte[8192];
        while ((read = pInputStream.read(buf)) != -1) {
            System.arraycopy(buf, 0, pData, dataOffset, read);
            dataOffset += read;
        }
    }

    public static final void copy(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        int read;
        byte[] buf = new byte[8192];
        while ((read = inputStream.read(buf)) != -1) {
            byteBuffer.put(buf, 0, read);
        }
    }

    public static final void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamUtils.copy(inputStream, outputStream, -1);
    }

    public static final void copy(InputStream inputStream, OutputStream outputStream, int byteLimit) throws IOException {
        if (byteLimit == -1) {
            int read;
            byte[] buf = new byte[8192];
            while ((read = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, read);
            }
        } else {
            int read;
            byte[] buf = new byte[8192];
            int bufferReadLimit = Math.min(byteLimit, 8192);
            long pBytesLeftToRead = byteLimit;
            while ((read = inputStream.read(buf, 0, bufferReadLimit)) != -1) {
                if (pBytesLeftToRead > (long)read) {
                    outputStream.write(buf, 0, read);
                    pBytesLeftToRead -= (long)read;
                    continue;
                }
                outputStream.write(buf, 0, (int)pBytesLeftToRead);
                break;
            }
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readFully(InputStream inputStream) throws IOException {
        StringWriter writer = new StringWriter();
        char[] buf = new char[8192];
        try {
            int read;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((read = reader.read(buf)) != -1) {
                writer.write(buf, 0, read);
            }
        }
        finally {
            StreamUtils.close(inputStream);
        }
        return writer.toString();
    }

    public static final byte[] streamToBytes(InputStream inputStream) throws IOException {
        return StreamUtils.streamToBytes(inputStream, -1);
    }

    public static final byte[] streamToBytes(InputStream inputStream, int readLimit) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(readLimit == -1 ? 8192 : readLimit);
        StreamUtils.copy(inputStream, os, readLimit);
        return os.toByteArray();
    }
}

