/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.utils;

import android.annotation.SuppressLint;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class TimeUtil {
    public static final String TIME_FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_FORMAT_YMDHM = "yyyy-MM-dd HH:mm";
    public static final String TIME_FORMAT_YMD = "yyyy-MM-dd";
    private static SimpleDateFormat YMDHM_DateFormat = null;
    private static final int MIN_CLICK_DELAY_TIME = 200;
    private static long lastClickTime;

    public static String getTimeStamp(String user_time) {
        String re_time = null;
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMAT_YMDHMS);
        try {
            Date d2 = sdf.parse(user_time);
            long l = d2.getTime();
            String str = String.valueOf(l);
            re_time = str.substring(0, 10);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return re_time;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String long2StringYMDHM(Long time) {
        if (null == time) {
            time = 0L;
        }
        if (null == YMDHM_DateFormat) {
            YMDHM_DateFormat = new SimpleDateFormat(TIME_FORMAT_YMDHM);
        }
        return YMDHM_DateFormat.format(new Date(time * 1000L));
    }

    public static String getStrTime(String timeStamp) {
        long lcc_time = Long.valueOf(timeStamp);
        return TimeUtil.getStrTime(lcc_time);
    }

    public static String getStrTime(long lcc_time) {
        String re_StrTime = null;
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMAT_YMDHMS);
        re_StrTime = sdf.format(new Date(lcc_time * 1000L));
        return re_StrTime;
    }

    public static String getStrTime(String timeStamp, String timeFormat) {
        long lcc_time = Long.valueOf(timeStamp);
        return TimeUtil.getStrTime(lcc_time, timeFormat);
    }

    public static String getStrTime(long lcc_time, String timeFormat) {
        String re_StrTime = null;
        SimpleDateFormat sdf = new SimpleDateFormat(timeFormat);
        re_StrTime = sdf.format(new Date(lcc_time * 1000L));
        return re_StrTime;
    }

    public static String getCurrentTime(String timeFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(timeFormat);
        Date curDate = new Date(System.currentTimeMillis());
        return sdf.format(curDate);
    }

    public static String getYYMMDDTime(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMAT_YMD);
        Date curDate = new Date(time);
        return sdf.format(curDate);
    }

    public static int[] getDateIntArr(String timeStr) {
        try {
            long time = Long.parseLong(timeStr);
            return TimeUtil.getDateIntArr(time);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int[] getDateIntArr(long time) {
        SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT_YMDHMS);
        String d2 = format.format(time * 1000L);
        int year = Integer.parseInt(d2.substring(0, 4));
        int month = Integer.parseInt(d2.substring(5, 7));
        int dayOfMonth = Integer.parseInt(d2.substring(8, 10));
        return new int[]{year, month, dayOfMonth};
    }

    public static boolean isTheSameDay(long time1, long time2) {
        if (Math.abs(time1 - time2) > 86400000L) {
            return false;
        }
        Date date1 = new Date(time1);
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        int year1 = calendar1.get(1) - 1900;
        int month1 = calendar1.get(2);
        int dayOfMonth1 = calendar1.get(5);
        Date date2 = new Date(time2);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int year2 = calendar2.get(1) - 1900;
        int month2 = calendar2.get(2);
        int dayOfMonth2 = calendar2.get(5);
        return dayOfMonth1 == dayOfMonth2 && month1 == month2 && year1 == year2;
    }

    public static boolean isTheSameDay(int[] date, String time) {
        if (date == null || date.length < 3) {
            return false;
        }
        int[] date2 = TimeUtil.getDateIntArr(time);
        if (date2 != null && date2.length == 3) {
            for (int i = 0; i < date2.length; ++i) {
                if (date[i] == date2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
    }

    public static Date getDateFromString(String strDate) {
        if (strDate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMAT_YMD, Locale.getDefault());
        try {
            return sdf.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String generateTime(long position) {
        int totalSeconds = Math.round((float)position / 1000.0f);
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        if (hours > 0) {
            return String.format(Locale.US, "%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format(Locale.US, "%02d:%02d", minutes, seconds);
    }

    public static String formatMssDuring(long mss) {
        long m = mss % 3600000L / 60000L;
        long s = mss % 60000L / 1000L;
        return (m > 9L ? Long.valueOf(m) : "0" + m) + ":" + (s > 9L ? Long.valueOf(s) : "0" + s);
    }

    public static String formatLiveLengthDuring(long time) {
        long m = time % 3600000L / 60000L;
        long s = time % 60000L / 1000L;
        String result = (m > 9L ? Long.valueOf(m) : "0" + m) + ":" + (s > 9L ? Long.valueOf(s) : "0" + s);
        if (time >= 3600000L) {
            long h = time % 86400000L / 3600000L;
            result = (h > 9L ? Long.valueOf(h) : "0" + h) + ":" + result;
        }
        return result;
    }

    public static String formatLongVideoLengthDuring(long time) {
        if (time < 60000L) {
            return String.format(Locale.US, "%.1f", Float.valueOf((float)time / 1000.0f));
        }
        return String.format(Locale.US, "%d:%02d", time / 60000L, time / 1000L % 60L);
    }

    public static boolean isFastClick() {
        boolean flag = false;
        long curClickTime = System.currentTimeMillis();
        if (curClickTime - lastClickTime >= 200L) {
            flag = true;
        }
        lastClickTime = curClickTime;
        return flag;
    }
}

