/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import android.util.LruCache;

public class AvatarRoundUtil {
    private static final LruCache<Integer, RoundedBitmapDrawable> sRoundBitmapCache = new LruCache(10);

    @Nullable
    public static Drawable getRoundAvatar(Context context, int drawable2) {
        RoundedBitmapDrawable roundedBitmapDrawable = (RoundedBitmapDrawable)sRoundBitmapCache.get((Object)drawable2);
        if (null == roundedBitmapDrawable) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = false;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)drawable2, (BitmapFactory.Options)options);
            if (null != bitmap && !bitmap.isRecycled()) {
                roundedBitmapDrawable = RoundedBitmapDrawableFactory.create((Resources)context.getResources(), (Bitmap)bitmap);
                roundedBitmapDrawable.setCircular(true);
                sRoundBitmapCache.put((Object)drawable2, (Object)roundedBitmapDrawable);
            }
        }
        return roundedBitmapDrawable;
    }
}

