/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.ui.dialog.DialogManager;
import com.unionyy.mobile.meipai.pk.ui.dialog.MeiPaiBottomComponentDialog;
import com.unionyy.mobile.meipai.pk.ui.dialog.RandomView.PKRandomConnectView;
import com.unionyy.mobile.meipai.pk.ui.dialog.RandomView.PKRandomSearchView;
import com.unionyy.mobile.meipai.pk.ui.model.PkStatusInfo;
import com.unionyy.mobile.meipai.pk.ui.view.PKVersusLayout;
import com.yy.mobile.image.CircleCompatImageView;
import com.yy.mobile.ui.utils.ViewUtils;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.FP;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.UserInfo;
import io.reactivex.functions.Consumer;

public class MeiPaiPKInviteRandom
extends MeiPaiBottomComponentDialog {
    private static final String TAG = "MeiPaiPKInviteRandom";
    private PKRandomConnectView mPKRandomConnectView;
    private PKRandomSearchView mPKRandomSearchView;
    private PKVersusLayout mPKVersusView;
    private CircleCompatImageView mLeftUserPhoto;
    private TextView mLeftUserName;
    private TextView mRightUserName;
    private TextView mCancelMatch;
    private boolean isPlayMatchAnim;

    @Override
    public int getLayoutId() {
        return R.layout.meipai_dialog_pk_invite_random;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog2 = super.onCreateDialog(savedInstanceState);
        Window dialogWindow = dialog2.getWindow();
        dialogWindow.setLayout(-1, DimenConverter.dip2px((Context)this.getContext(), (float)260.0f));
        return dialog2;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = super.onCreateView(inflater, container, savedInstanceState);
        this.initViews(rootView);
        this.onPkStatusEvent(this.core.getPkStatusInfo());
        return rootView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    protected void onPkStatusEvent(PkStatusInfo info) {
        UserInfo userInfo = ((IUserCore)CoreFactory.getCore(IUserCore.class)).getCacheLoginUserInfo();
        if (!FP.empty((CharSequence)info.leftUrl)) {
            Glide.with((FragmentActivity)this.getActivity()).load(info.leftUrl).apply(RequestOptions.placeholderOf((int)R.drawable.meipai_default_avatar_small)).into((ImageView)this.mLeftUserPhoto);
        } else if (userInfo != null) {
            Glide.with((FragmentActivity)this.getActivity()).load(userInfo.iconUrl).apply(RequestOptions.placeholderOf((int)R.drawable.meipai_default_avatar_small)).into((ImageView)this.mLeftUserPhoto);
        }
        if (!FP.empty((CharSequence)info.leftName)) {
            this.mLeftUserName.setText((CharSequence)info.leftName);
        } else if (userInfo != null) {
            this.mLeftUserName.setText((CharSequence)userInfo.nickName);
        }
        if (info.type == 1) {
            this.goMatchAnim();
        } else if (info.type == 4) {
            if (info.rightName != null) {
                this.mRightUserName.setText((CharSequence)info.rightName);
            } else {
                this.mRightUserName.setText((CharSequence)"");
            }
            if (!this.isPlayMatchAnim) {
                this.matchSucceceAnim();
                this.isPlayMatchAnim = true;
            }
        }
    }

    private void goMatchAnim() {
        if (this.mPKRandomConnectView != null && this.mPKRandomConnectView != null) {
            this.mPKRandomConnectView.stop();
            this.mPKRandomConnectView.startTimeTask();
        }
    }

    private void matchSucceceAnim() {
        if (this.mCancelMatch != null) {
            this.mCancelMatch.setText((CharSequence)"\u5339\u914d\u6210\u529f");
            this.mCancelMatch.setClickable(false);
            this.mCancelMatch.setEnabled(false);
        }
        if (this.mPKRandomConnectView != null) {
            this.mPKRandomConnectView.stop();
            this.mPKRandomConnectView.setVisibility(8);
        }
        if (this.mPKRandomSearchView != null) {
            this.mPKRandomSearchView.setVisibility(0);
            this.mPKRandomSearchView.loadPhoto(this.core.getPkStatusInfo().rightUrl);
            this.mPKRandomSearchView.ExecuteMatchSuccessAnim();
        }
        if (this.mPKVersusView != null) {
            this.mPKVersusView.setVisibility(0);
            this.mPKVersusView.startAnimation();
            this.mPKVersusView.setPKVSAnimatorListener(new PKVersusLayout.PKVSAnimatorListener(){

                @Override
                public void vsAnimatorStart() {
                }

                @Override
                public void vsAnimatorEnd() {
                    DialogManager.getInstence().dismissAllPopupComponents(MeiPaiPKInviteRandom.this.getActivity());
                }
            });
        }
    }

    private void initViews(View view) {
        this.mLeftUserPhoto = (CircleCompatImageView)view.findViewById(R.id.image_pk_random_left_user_photo);
        this.mLeftUserName = (TextView)view.findViewById(R.id.text_random_left_user_name);
        this.mRightUserName = (TextView)view.findViewById(R.id.text_random_right_user_name);
        this.mCancelMatch = (TextView)view.findViewById(R.id.button_cancel_random_pk);
        ViewUtils.clicks((View)this.mCancelMatch, (long)300L).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                DialogManager.getInstence().dismissAllPopupComponents(MeiPaiPKInviteRandom.this.getActivity());
                MeiPaiPKInviteRandom.this.core.reqPkQuit();
            }
        });
        this.mPKRandomConnectView = (PKRandomConnectView)view.findViewById(R.id.pk_random_connect_view);
        this.mPKRandomSearchView = (PKRandomSearchView)view.findViewById(R.id.image_pk_random_right_user_photo);
        this.mPKVersusView = (PKVersusLayout)view.findViewById(R.id.live_random_pk_versus_layout);
        this.mPKVersusView.customStyle();
    }
}

