/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view.guard;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;

@SuppressLint(value={"MissingBraces"})
public class GuardStarView
extends View {
    private final int SCALE_ANIMATION_DURATION = 400;
    private final int SCALE_ANIMATION_BACK = 60;
    private final int DELAY_DURATION = 30;
    private final int[] starSizeArray = new int[]{DeviceUtils.dip2px(20.0f), DeviceUtils.dip2px(20.0f), DeviceUtils.dip2px(23.0f), DeviceUtils.dip2px(26.0f), DeviceUtils.dip2px(36.0f), DeviceUtils.dip2px(30.0f)};
    private final ScalePoint[] targetPointScaleArray = new ScalePoint[]{new ScalePoint(0.14f, 0.27f), new ScalePoint(0.65f, 0.12f), new ScalePoint(0.2f, 0.5f), new ScalePoint(0.82f, 0.35f), new ScalePoint(0.5f, 0.48f), new ScalePoint(0.6f, 0.68f)};
    private Paint paint;
    private ValueAnimator valueAnimator;
    private int animatedValue;
    private Bitmap bitmap;
    private Rect srcRect = new Rect();
    private Rect targetRect = new Rect();
    private final int MAX_ROTATE = 16;
    private final int ROTATE_SPEED = 4;
    private boolean isLeftRotate = true;
    private int currentRotate = 0;
    private Matrix matrix = new Matrix();
    private boolean isTranslateAnimation = false;
    private Runnable drawRunnable = new Runnable(){

        @Override
        public void run() {
            GuardStarView.this.invalidate();
        }
    };

    public GuardStarView(Context context) {
        super(context);
        this.init();
    }

    public GuardStarView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GuardStarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        try {
            this.bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.live_guard_love_star);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.bitmap == null || this.getVisibility() != 0) {
            return;
        }
        Bitmap rotateBitmap = null;
        if (!this.isTranslateAnimation) {
            if (this.isLeftRotate) {
                this.currentRotate -= 4;
                if (Math.abs(this.currentRotate) >= 16) {
                    this.isLeftRotate = false;
                }
            } else {
                this.currentRotate += 4;
                if (Math.abs(this.currentRotate) >= 16) {
                    this.isLeftRotate = true;
                }
            }
            this.matrix.reset();
            this.matrix.postRotate((float)(360 + this.currentRotate));
            rotateBitmap = Bitmap.createBitmap((Bitmap)this.bitmap, (int)0, (int)0, (int)this.bitmap.getWidth(), (int)this.bitmap.getHeight(), (Matrix)this.matrix, (boolean)true);
        }
        for (int index = 0; index < this.starSizeArray.length; ++index) {
            int size = this.starSizeArray[index];
            float scale = (float)this.animatedValue / 340.0f;
            float bitmapSizeScale = 0.5f + (float)this.animatedValue / 2.0f / 340.0f;
            ScalePoint scalePoint = this.targetPointScaleArray[index];
            float srcLeft = (float)(this.getWidth() - size) / 2.0f;
            float targetLeft = (float)this.getWidth() * scalePoint.x;
            int left = (int)(srcLeft + (targetLeft - srcLeft) * scale);
            float srcTop = (float)(this.getHeight() - size) / 2.0f;
            float targetTop = (float)this.getHeight() * scalePoint.y;
            int top = (int)(srcTop + (targetTop - srcTop) * scale);
            int right = (int)((float)left + (float)size * bitmapSizeScale);
            int bottom = (int)((float)top + (float)size * bitmapSizeScale);
            this.targetRect.set(left, top, right, bottom);
            if (!this.isTranslateAnimation) {
                Bitmap bitmap = rotateBitmap == null ? this.bitmap : rotateBitmap;
                int rotateSize = (int)((double)size * Math.sin(Math.PI / 180 * (double)((360 + this.currentRotate) % 90)) + (double)size * Math.cos(Math.PI / 180 * (double)((360 + this.currentRotate) % 90)));
                this.srcRect.set(0, 0, bitmap.getWidth(), bitmap.getHeight());
                int dValue = (rotateSize - size) / 2;
                this.targetRect.set(this.targetRect.left - dValue, this.targetRect.top - dValue, this.targetRect.right + dValue, this.targetRect.bottom + dValue);
                canvas.drawBitmap(bitmap, this.srcRect, this.targetRect, this.paint);
                continue;
            }
            this.srcRect.set(0, 0, this.bitmap.getWidth(), this.bitmap.getHeight());
            canvas.drawBitmap(this.bitmap, this.srcRect, this.targetRect, this.paint);
        }
        if (!this.isTranslateAnimation) {
            this.removeOrPostMessage(true);
        }
    }

    public void startAnimation() {
        if (this.valueAnimator != null && this.valueAnimator.isRunning()) {
            return;
        }
        this.currentRotate = 0;
        this.animatedValue = 0;
        this.removeOrPostMessage(false);
        this.isTranslateAnimation = true;
        this.valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, 460});
        this.valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.valueAnimator.setDuration(460L);
        this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                GuardStarView.this.animatedValue = (Integer)animation.getAnimatedValue();
                GuardStarView.this.animatedValue = GuardStarView.this.animatedValue > 400 ? 400 - GuardStarView.this.animatedValue % 400 : GuardStarView.this.animatedValue;
                GuardStarView.this.invalidate();
            }
        });
        this.valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                GuardStarView.this.isTranslateAnimation = false;
            }
        });
        this.valueAnimator.start();
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.removeOrPostMessage(visibility == 0);
        if (visibility != 0 && this.valueAnimator != null && this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
        }
    }

    private void removeOrPostMessage(boolean isPost) {
        if (this.getHandler() == null) {
            return;
        }
        this.getHandler().removeCallbacks(this.drawRunnable);
        if (isPost) {
            this.getHandler().postDelayed(this.drawRunnable, 30L);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeOrPostMessage(false);
        this.getHandler().removeCallbacksAndMessages(null);
        if (this.valueAnimator != null && this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
        }
    }

    private class ScalePoint {
        float x;
        float y;

        ScalePoint(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

