/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import com.unionyy.mobile.meipai.gift.animation.BasicTransformations;
import com.unionyy.mobile.meipai.gift.animation.utils.LedBitmapLoader;
import java.util.Timer;
import java.util.TimerTask;

public class LedTextView
extends AppCompatImageView
implements BasicTransformations {
    private static final int REFRESH_INTERVAL = 20;
    private int mScroll;
    private int mPaddingLeft;
    private int mPaddingTop;
    private int mPaddingRight;
    private int mPaddingBottom;
    private Rect mSrcRect = new Rect();
    private Rect mDstRect = new Rect();
    private float mMoveDis;
    private float mSpeed;
    private int mWidth;
    private int mHeight;
    private Timer mGifTimer;
    private TimerTask mGifTimerTask;
    private LedBitmapLoader mLedBitmapLoader;

    public LedTextView(Context context) {
        super(context);
    }

    public LedTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setSpeed(float speed) {
        this.mSpeed = speed;
    }

    private void stopGifTimer() {
        if (null != this.mGifTimerTask) {
            this.mGifTimerTask.cancel();
        }
        if (null != this.mGifTimer) {
            this.mGifTimer.cancel();
            this.mGifTimer.purge();
        }
        this.mGifTimerTask = null;
        this.mGifTimer = null;
    }

    public void start(LedBitmapLoader ledBitmapLoader) {
        this.mLedBitmapLoader = ledBitmapLoader;
        if (this.mSpeed <= 0.0f || this.mLedBitmapLoader == null || this.mLedBitmapLoader.getLedBitmap() == null) {
            return;
        }
        this.mSrcRect.top = 0;
        this.mSrcRect.bottom = this.mLedBitmapLoader.getLedBitmap().getHeight();
        this.stopGifTimer();
        this.mGifTimer = new Timer("gifTimer");
        this.mGifTimerTask = new TimerTask(){

            @Override
            public void run() {
                int visibleLen;
                if (LedTextView.this.mLedBitmapLoader.getLedBitmap() == null || LedTextView.this.mWidth <= 0 || LedTextView.this.mHeight <= 0) {
                    return;
                }
                int bitmapWidth = LedTextView.this.mLedBitmapLoader.getLedBitmap().getWidth();
                if (LedTextView.this.mScroll <= -bitmapWidth) {
                    LedTextView.this.mScroll = LedTextView.this.mWidth;
                }
                int move = (int)(LedTextView.this.mMoveDis * 20.0f);
                LedTextView.this.mScroll = LedTextView.this.mScroll - move;
                if (LedTextView.this.mScroll < 0) {
                    visibleLen = Math.min(bitmapWidth + LedTextView.this.mScroll, LedTextView.this.mWidth);
                    ((LedTextView)LedTextView.this).mSrcRect.left = -LedTextView.this.mScroll;
                    ((LedTextView)LedTextView.this).mDstRect.left = LedTextView.this.mPaddingLeft;
                } else {
                    visibleLen = Math.min(LedTextView.this.mWidth - LedTextView.this.mScroll, bitmapWidth);
                    ((LedTextView)LedTextView.this).mSrcRect.left = 0;
                    ((LedTextView)LedTextView.this).mDstRect.left = LedTextView.this.mScroll + LedTextView.this.mPaddingLeft;
                }
                ((LedTextView)LedTextView.this).mSrcRect.right = ((LedTextView)LedTextView.this).mSrcRect.left + visibleLen;
                ((LedTextView)LedTextView.this).mDstRect.right = ((LedTextView)LedTextView.this).mDstRect.left + visibleLen;
                LedTextView.this.postInvalidate();
            }
        };
        this.mGifTimer.schedule(this.mGifTimerTask, 0L, 20L);
    }

    public void setLedingPadding(int left, int top, int right, int bottom) {
        this.mPaddingLeft = left;
        this.mPaddingRight = right;
        this.mPaddingTop = top;
        this.mPaddingBottom = bottom;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
        int height = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
        if (this.mWidth <= 0 || this.mHeight <= 0) {
            this.mWidth = width;
            this.mHeight = height;
            if (this.mSpeed > 0.0f) {
                this.mMoveDis = (float)this.mWidth / this.mSpeed;
            }
            this.mDstRect.top = this.mPaddingTop;
            this.mDstRect.bottom = this.mPaddingTop + this.mHeight;
            this.mScroll = this.mWidth;
        }
        if (this.mSrcRect.width() > 0 && this.mDstRect.width() > 0 && this.mLedBitmapLoader.getLedBitmap() != null) {
            canvas.drawBitmap(this.mLedBitmapLoader.getLedBitmap(), this.mSrcRect, this.mDstRect, null);
        }
    }

    public void release() {
        this.mWidth = 0;
        this.mHeight = 0;
        this.mSrcRect.set(0, 0, 0, 0);
        this.mDstRect.set(0, 0, 0, 0);
        if (this.mLedBitmapLoader != null) {
            this.mLedBitmapLoader.release();
        }
    }
}

