/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.ScaleAnimation;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.utils.CountDownTimer;
import com.yy.mobile.util.log.MLog;

public class CountDownTimerView
extends RelativeLayout {
    private static final String TAG = "CountDownTimerView";
    private View mView;
    private TextView mTime;
    private RelativeLayout mLayout;
    private LivePkCountDownTimer mLivePkCountDownTimer;
    private CountDownTimerListener mCountDownTimerListener;

    public CountDownTimerView(Context context) {
        super(context);
        this.initView(context);
    }

    public CountDownTimerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public void initView(Context context) {
        this.mView = LayoutInflater.from((Context)context).inflate(R.layout.meipai_count_down_time, (ViewGroup)this);
        this.mTime = (TextView)this.mView.findViewById(R.id.btn_live_text);
        this.mLayout = (RelativeLayout)this.mView.findViewById(R.id.layout_time);
    }

    public void start(long millisInFuture, long countDownInterval) {
        MLog.info((Object)TAG, (String)("[PK]millisInFuture:" + millisInFuture + "mLivePkCountDownTimer" + this.mLivePkCountDownTimer), (Object[])new Object[0]);
        if (this.mLivePkCountDownTimer != null) {
            this.mLivePkCountDownTimer.cancel();
            this.mLivePkCountDownTimer = null;
        }
        this.mTime.setText((CharSequence)"");
        this.mLivePkCountDownTimer = new LivePkCountDownTimer(millisInFuture, countDownInterval);
        this.mLivePkCountDownTimer.start();
    }

    public void stop() {
        MLog.info((Object)TAG, (String)("[PK]mLivePkCountDownTimer" + this.mLivePkCountDownTimer), (Object[])new Object[0]);
        if (this.mLivePkCountDownTimer != null) {
            this.mLivePkCountDownTimer.cancel();
            this.mLivePkCountDownTimer = null;
        }
        if (this.mLayout != null) {
            this.mLayout.clearAnimation();
        }
        if (this.mTime != null) {
            this.mTime.clearAnimation();
        }
        this.mTime.setText((CharSequence)"");
    }

    public void setCountDownTimerListener(CountDownTimerListener mCountDownTimerListener) {
        this.mCountDownTimerListener = mCountDownTimerListener;
    }

    public static interface CountDownTimerListener {
        public void onFinish();

        public void onAnimEnd();
    }

    class LivePkCountDownTimer
    extends CountDownTimer {
        public LivePkCountDownTimer(long millisInFuture, long countDownInterval) {
            super(millisInFuture, countDownInterval);
        }

        @Override
        public void onTick(long millisUntilFinished) {
            if (CountDownTimerView.this.mTime == null) {
                return;
            }
            CountDownTimerView.this.mTime.setText((CharSequence)String.valueOf(millisUntilFinished / 1000L + 1L));
            AnimationSet animationSet = new AnimationSet(true);
            ScaleAnimation scaleAnimation = new ScaleAnimation(2.5f, 1.0f, 2.5f, 1.0f, 1, 0.5f, 1, 0.5f);
            AlphaAnimation alphaAnimation = new AlphaAnimation(0.3f, 1.0f);
            animationSet.addAnimation((Animation)scaleAnimation);
            animationSet.addAnimation((Animation)alphaAnimation);
            animationSet.setDuration(300L);
            CountDownTimerView.this.mTime.startAnimation((Animation)animationSet);
            animationSet.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (CountDownTimerView.this.mTime == null) {
                        return;
                    }
                    ScaleAnimation scaleAnimation = new ScaleAnimation(1.0f, 1.2f, 1.0f, 1.2f, 1, 0.5f, 1, 0.5f);
                    scaleAnimation.setDuration(300L);
                    CountDownTimerView.this.mTime.startAnimation((Animation)scaleAnimation);
                    scaleAnimation.setAnimationListener(new Animation.AnimationListener(){

                        public void onAnimationStart(Animation animation) {
                        }

                        public void onAnimationEnd(Animation animation) {
                            if (CountDownTimerView.this.mTime == null) {
                                return;
                            }
                            AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
                            alphaAnimation.setDuration(400L);
                            CountDownTimerView.this.mTime.startAnimation((Animation)alphaAnimation);
                        }

                        public void onAnimationRepeat(Animation animation) {
                        }
                    });
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }

        @Override
        public void onFinish() {
            MLog.info((Object)CountDownTimerView.TAG, (String)("[PK]onFinish" + CountDownTimerView.this.mTime), (Object[])new Object[0]);
            if (CountDownTimerView.this.mTime == null) {
                return;
            }
            if (CountDownTimerView.this.mCountDownTimerListener != null) {
                CountDownTimerView.this.mCountDownTimerListener.onFinish();
            }
            ScaleAnimation scaleAnimation = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 1, 0.5f, 1, 0.5f);
            scaleAnimation.setDuration(200L);
            if (CountDownTimerView.this.mLayout != null) {
                CountDownTimerView.this.mLayout.startAnimation((Animation)scaleAnimation);
            }
            scaleAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    MLog.info((Object)CountDownTimerView.TAG, (String)"[PK]onAnimationEnd", (Object[])new Object[0]);
                    if (CountDownTimerView.this.mCountDownTimerListener != null) {
                        CountDownTimerView.this.mCountDownTimerListener.onAnimEnd();
                    }
                    if (CountDownTimerView.this.mLayout != null) {
                        CountDownTimerView.this.mLayout.clearAnimation();
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
    }
}

