/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view.opengl;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.animation.AnimationUtils;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.GLCanvas;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.GlProgramUtil;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.MatrixState;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.TextureIdManager;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public abstract class GlCanvasSurfaceView
extends GLSurfaceView {
    private SceneRenderer mRenderer;
    private TextureIdManager textureIdManager;
    private GLCanvas mGLCanvas;
    private MatrixState mMatrixState;
    private int width;
    private int height;
    private boolean hasCheckNpot;
    private int mFps = 25;

    public GlCanvasSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public GlCanvasSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        this.mRenderer = new SceneRenderer();
        this.setRenderer(this.mRenderer);
        this.getHolder().setFormat(-3);
        this.setZOrderMediaOverlay(true);
        this.switchRenderMode(false);
        this.textureIdManager = new TextureIdManager();
    }

    public void switchRenderMode(boolean continuously) {
        int renderMode = continuously ? 1 : 0;
        this.setRenderMode(renderMode);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public TextureIdManager getTextureIdManager() {
        return this.textureIdManager;
    }

    public abstract void onTextureDraw(GLCanvas var1);

    public GLCanvas getCanvas() {
        return this.mGLCanvas;
    }

    public float getGlCoordinatesX(float x) {
        if (this.width == 0) {
            return 0.0f;
        }
        return this.mRenderer.xRatio * (x -= (float)(this.width / 2));
    }

    public float getGlCoordinatesY(float y) {
        if (this.height == 0) {
            return 0.0f;
        }
        y = (float)(this.height / 2) - y;
        return this.mRenderer.yRatio * y;
    }

    public float getGlImageWidth(int w) {
        return this.mRenderer.xRatio * (float)w;
    }

    public float getGlImageHeight(int h) {
        return this.mRenderer.yRatio * (float)h;
    }

    private boolean isSupportNpot() {
        String extensions = GLES20.glGetString((int)7939);
        boolean contains = extensions.contains("GL_OES_texture_npot");
        this.hasCheckNpot = true;
        return contains;
    }

    protected void notSupportNpotTexture() {
    }

    public void setFps(int fps) {
        if (fps > 0) {
            this.mFps = 1000 / fps;
        }
    }

    private class SceneRenderer
    implements GLSurfaceView.Renderer {
        private float ratio;
        private float xRatio;
        private float yRatio;
        private long lastUpdateTime;

        private SceneRenderer() {
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            if (!GlCanvasSurfaceView.this.hasCheckNpot && !GlCanvasSurfaceView.this.isSupportNpot()) {
                GlCanvasSurfaceView.this.notSupportNpotTexture();
            }
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlProgramUtil.createAlphaShaderProgram();
            GLES20.glEnable((int)2929);
            GLES20.glDisable((int)2884);
            MatrixState matrixState = new MatrixState();
            matrixState.setInitStack();
            GlCanvasSurfaceView.this.mMatrixState = matrixState;
            GlCanvasSurfaceView.this.mGLCanvas = new GLCanvas(matrixState);
            this.lastUpdateTime = 0L;
            GLES20.glEnable((int)2929);
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
            this.ratio = (float)width / (float)height;
            GlCanvasSurfaceView.this.width = width;
            GlCanvasSurfaceView.this.height = height;
            this.xRatio = this.yRatio = 2.0f / (float)height;
            GlCanvasSurfaceView.this.mMatrixState.setProjectOrtho(-this.ratio, this.ratio, -1.0f, 1.0f, 1.0f, 110.0f);
            GlCanvasSurfaceView.this.mMatrixState.setCamera(0.0f, 0.0f, 100.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDrawFrame(GL10 gl) {
            if (GlCanvasSurfaceView.this.getVisibility() != 0) {
                return;
            }
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            long remainTime = (long)GlCanvasSurfaceView.this.mFps - (currentTime - this.lastUpdateTime);
            if (remainTime > 5L) {
                try {
                    SceneRenderer sceneRenderer = this;
                    synchronized (sceneRenderer) {
                        this.wait(remainTime);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.lastUpdateTime = AnimationUtils.currentAnimationTimeMillis();
            GLES20.glClear((int)16640);
            GLES20.glEnable((int)3042);
            GLES20.glBlendFunc((int)1, (int)771);
            GlCanvasSurfaceView.this.mGLCanvas.preDraw();
            GlCanvasSurfaceView.this.onTextureDraw(GlCanvasSurfaceView.this.mGLCanvas);
            GlCanvasSurfaceView.this.mGLCanvas.draw();
            GLES20.glDisable((int)3042);
        }
    }
}

