/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.unionyy.mobile.meipai.gift.animation.BasicTransformations;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import java.util.Timer;
import java.util.TimerTask;

public class GiftImageView
extends AppCompatImageView
implements BasicTransformations {
    private Bitmap mBitmap;
    private int mFrameNumber;
    private int mLoopFrom;
    private int mLoopTo;
    private int mWidthFrames;
    private int mHeightFrames;
    private int mPerFrameWidth;
    private int mPerFrameHeight;
    private int mFrameRate;
    private int mCurrentFrame;
    private int mLoopMode;
    private boolean isPlayingBackWards;
    private boolean isStartLoop;
    private float mScale;
    private float mRotaion;
    private int mTargetMeasureWidth;
    private int mTargetMeasureHeight;
    private Rect mSrc = new Rect();
    private Rect mDst = new Rect();
    private Timer mGifTimer;
    private TimerTask mGifTimerTask;

    public GiftImageView(Context context) {
        super(context);
        this.init();
    }

    public GiftImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mFrameNumber = 1;
        this.setScaleType(ImageView.ScaleType.FIT_XY);
    }

    public void setImageBitmap(Bitmap bm) {
        this.mBitmap = bm;
        super.setImageBitmap(bm);
    }

    public void startGifAnimation() {
        this.startGifTimer();
    }

    public void setGifParams(GiftRule rule, int width, int height, float scale) {
        if (this.mBitmap == null || null == rule) {
            return;
        }
        this.mFrameNumber = rule.frames_number;
        this.mFrameRate = rule.frame_rate;
        this.mLoopMode = rule.loop_mode;
        this.mLoopFrom = rule.loop_from;
        this.mLoopTo = rule.loop_to;
        if (rule.h_frames != 0 && rule.v_frames != 0) {
            this.mPerFrameWidth = this.mBitmap.getWidth() / rule.h_frames;
            this.mPerFrameHeight = this.mBitmap.getHeight() / rule.v_frames;
        }
        this.mWidthFrames = rule.h_frames;
        this.mHeightFrames = rule.v_frames;
        this.mCurrentFrame = 1;
        this.isStartLoop = false;
        this.isPlayingBackWards = false;
        this.mScale = scale;
        int offset = 0;
        if (width > 0 && height > 0) {
            this.mTargetMeasureWidth = width;
            this.mTargetMeasureHeight = height;
            int vheight = height - this.getPaddingTop() - this.getPaddingBottom();
            int vwidth = width - this.getPaddingLeft() - this.getPaddingRight();
            boolean fits = !(this.mPerFrameWidth > 0 && vwidth != this.mPerFrameWidth || this.mPerFrameHeight > 0 && vheight != this.mPerFrameHeight);
            int dstWidth = 0;
            int dstHeight = 0;
            int x = 0;
            int y = 0;
            if (fits) {
                dstWidth = this.mPerFrameWidth;
                dstHeight = this.mPerFrameHeight;
            } else {
                scale = Math.min((float)vwidth / (float)this.mPerFrameWidth, (float)vheight / (float)this.mPerFrameHeight);
                dstWidth = (int)((float)this.mPerFrameWidth * scale);
                dstHeight = (int)((float)this.mPerFrameHeight * scale);
                x = vwidth - dstWidth >> 1;
                y = vheight - dstHeight >> 1;
            }
            this.mDst.set(x, y, dstWidth - offset, dstHeight);
        } else {
            this.mDst.set(0, 0, (int)((float)this.mPerFrameWidth * this.mScale - (float)offset), (int)((float)this.mPerFrameHeight * this.mScale));
        }
        this.mSrc.set(0, 0, this.mPerFrameWidth, this.mPerFrameHeight);
    }

    public void setGifParams(GiftRule rule, int width, int height) {
        this.setGifParams(rule, width, height, 1.0f);
    }

    public void setGifParams(GiftRule rule, float scale) {
        this.setGifParams(rule, 0, 0, scale);
    }

    public void stopGifTimer() {
        if (null != this.mGifTimerTask) {
            this.mGifTimerTask.cancel();
        }
        if (null != this.mGifTimer) {
            this.mGifTimer.cancel();
            this.mGifTimer.purge();
        }
        this.mGifTimerTask = null;
        this.mGifTimer = null;
    }

    private void startGifTimer() {
        if (this.mFrameRate <= 0) {
            return;
        }
        this.stopGifTimer();
        this.mGifTimer = new Timer("gifTimer");
        this.mGifTimerTask = new TimerTask(){

            @Override
            public void run() {
                int x = (GiftImageView.this.mCurrentFrame - 1) % GiftImageView.this.mWidthFrames * GiftImageView.this.mPerFrameWidth;
                int y = (GiftImageView.this.mCurrentFrame - 1) / GiftImageView.this.mWidthFrames * GiftImageView.this.mPerFrameHeight;
                GiftImageView.this.mSrc.set(x, y, x + GiftImageView.this.mPerFrameWidth - 1, y + GiftImageView.this.mPerFrameHeight - 1);
                GiftImageView.this.postInvalidate();
                GiftImageView.this.mCurrentFrame = GiftImageView.this.mCurrentFrame + (GiftImageView.this.isPlayingBackWards ? -1 : 1);
                if (GiftImageView.this.isStartLoop && (!GiftImageView.this.isPlayingBackWards && GiftImageView.this.mCurrentFrame > GiftImageView.this.mLoopTo || GiftImageView.this.isPlayingBackWards && GiftImageView.this.mCurrentFrame < GiftImageView.this.mLoopFrom) || GiftImageView.this.mCurrentFrame > GiftImageView.this.mFrameNumber) {
                    if (GiftImageView.this.mLoopFrom > 0) {
                        if (GiftImageView.this.mLoopMode > 0) {
                            if (GiftImageView.this.isStartLoop || GiftImageView.this.mLoopTo == GiftImageView.this.mFrameNumber) {
                                GiftImageView.this.mCurrentFrame = GiftImageView.this.isPlayingBackWards ? GiftImageView.this.mLoopFrom + 1 : GiftImageView.this.mLoopTo - 1;
                            } else {
                                GiftImageView.this.mCurrentFrame = GiftImageView.this.mLoopTo;
                            }
                            GiftImageView.this.isPlayingBackWards = !GiftImageView.this.isPlayingBackWards;
                        } else {
                            GiftImageView.this.mCurrentFrame = GiftImageView.this.mLoopFrom;
                        }
                        GiftImageView.this.isStartLoop = true;
                    } else {
                        GiftImageView.this.mCurrentFrame = GiftImageView.this.mFrameNumber;
                    }
                }
            }
        };
        this.mGifTimer.schedule(this.mGifTimerTask, 0L, (long)(1000 / this.mFrameRate));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mTargetMeasureWidth == 0 && this.mTargetMeasureHeight == 0 && this.mPerFrameWidth > 0 && this.mPerFrameHeight > 0) {
            this.setMeasuredDimension((int)((float)this.mPerFrameWidth * this.mScale), (int)((float)this.mPerFrameHeight * this.mScale));
            return;
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public void setRotation(float rotation) {
        this.mRotaion = rotation;
        this.invalidate();
    }

    @Override
    public float getRotation() {
        return this.mRotaion;
    }

    public void release() {
        this.stopGifTimer();
        this.setImageBitmap(null);
    }

    protected void onDraw(Canvas canvas) {
        canvas.rotate(this.mRotaion, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        if (this.mFrameNumber <= 1 || null == this.mBitmap) {
            super.onDraw(canvas);
        } else {
            canvas.drawBitmap(this.mBitmap, this.mSrc, this.mDst, null);
        }
    }
}

