/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.decoder.sub;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ViewGroup;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.decoder.AbstractAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.decoder.sub.LiveEggAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import com.unionyy.mobile.meipai.gift.animation.model.GiftMessage;
import com.unionyy.mobile.meipai.gift.animation.utils.DipUtils;
import com.unionyy.mobile.meipai.gift.controller.GiftAnimateController;
import com.yy.mobile.config.BasicConfig;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.internal.NamedRunnable;

public class LiveSmallGiftAnimateDecoder
extends AbstractAnimateDecoder {
    private static final String TAG = "LiveSmallGiftAnimateDec";
    private float smallGiftItemHeight;
    private float smallGiftItemOffset;
    private GiftTarget mGiftTop;
    private GiftTarget mGiftBottom;
    private GiftMessage mGiftMessageTop;
    private GiftMessage mGiftMessageBottom;
    private float LIVE_GIFT_LEFT_PADDING = 160.0f;
    private LiveEggAnimateDecoder mLiveEggAnimateDecoder;
    private float mPortGiftOffsetEventFragment;
    private float mLandGiftOffsetEventFragment;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private static final int CORE_POOL_SIZE_DECODER = 5;
    private static final int MAXIMUM_POOL_SIZE_DECODER = 50;
    private static final long KEEP_ALIVE_TIME_DECODER = 30L;
    private ThreadPoolExecutor mThreadPoolExecutor = new ThreadPoolExecutor(5, 50, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable runnable2, ThreadPoolExecutor threadPoolExecutor) {
            threadPoolExecutor.execute(runnable2);
        }
    });
    private LiveEggAnimateDecoder.ILiveGiftEggAttachListener mEggAttachListener = new LiveEggAnimateDecoder.ILiveGiftEggAttachListener(){

        @Override
        public GiftTarget findEggTargetAttachOn(GiftMessage giftEggMessage) {
            GiftTarget littleGiftTarget = null;
            String doubleHitId = giftEggMessage.getDoublehitId();
            if (null != LiveSmallGiftAnimateDecoder.this.mGiftMessageTop && !TextUtils.isEmpty((CharSequence)LiveSmallGiftAnimateDecoder.this.mGiftMessageTop.getDoublehitId()) && LiveSmallGiftAnimateDecoder.this.mGiftMessageTop.getDoublehitId().equals(doubleHitId)) {
                littleGiftTarget = LiveSmallGiftAnimateDecoder.this.mGiftTop;
            } else if (null != LiveSmallGiftAnimateDecoder.this.mGiftMessageBottom && !TextUtils.isEmpty((CharSequence)LiveSmallGiftAnimateDecoder.this.mGiftMessageBottom.getDoublehitId()) && LiveSmallGiftAnimateDecoder.this.mGiftMessageBottom.getDoublehitId().equals(doubleHitId)) {
                littleGiftTarget = LiveSmallGiftAnimateDecoder.this.mGiftBottom;
            }
            return littleGiftTarget;
        }
    };

    public LiveSmallGiftAnimateDecoder(Context context, ViewGroup viewGroup) {
        super(context, viewGroup);
        this.mLiveEggAnimateDecoder = new LiveEggAnimateDecoder(context, viewGroup);
        this.mLiveEggAnimateDecoder.setLiveEggAttachListener(this.mEggAttachListener);
        Resources resource = context.getResources();
        this.smallGiftItemHeight = resource.getDimension(R.dimen.meipai_live_live_gift_user_info_group_height);
        this.LIVE_GIFT_LEFT_PADDING = DipUtils.dip2px(this.LIVE_GIFT_LEFT_PADDING);
        this.smallGiftItemOffset = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)resource.getDisplayMetrics());
        this.marginTop = 0.0f;
        this.setGiftParamsWithOrientation(1);
    }

    @Override
    public void onDisplaySizeChanged(int w, int h) {
        this.mLiveEggAnimateDecoder.onDisplaySizeChanged(w, h);
        this.updateGiftYPosition(this.mGiftTop, this.mHeight, h);
        this.updateGiftYPosition(this.mGiftBottom, this.mHeight, h);
        this.mWidth = w;
        this.mHeight = h;
        if (this.mOrientation == 1) {
            this.mScreenScale = (float)this.mWidth / 750.0f;
        }
    }

    @Override
    public void onConfigurationChanged(int orientation) {
        super.onConfigurationChanged(orientation);
        this.setGiftParamsWithOrientation(orientation);
    }

    @Override
    public boolean dispatchGiftMessage(ArrayList<GiftMessage> giftMessageList) {
        return super.dispatchGiftMessage(giftMessageList);
    }

    @Override
    public boolean dispatchGiftMessage(GiftMessage giftMessage) {
        if (this.checkGiftMessageFitDecoder(giftMessage)) {
            if (giftMessage.getGift_type() == this.mLiveEggAnimateDecoder.desireGiftMessageType()) {
                if (this.isNeedEggDecoderTodoEggAnimation(giftMessage)) {
                    return this.mLiveEggAnimateDecoder.dispatchGiftMessage(giftMessage);
                }
                return false;
            }
            return this.dealWithGiftMessage(giftMessage);
        }
        return false;
    }

    @Override
    public boolean checkGiftMessageFitDecoder(GiftMessage giftMessage) {
        return giftMessage != null && (giftMessage.getGift_type() == this.desireGiftMessageType() || giftMessage.getGift_type() == this.mLiveEggAnimateDecoder.desireGiftMessageType());
    }

    @Override
    protected float getGiftViewHeight() {
        return (float)this.mHeight - this.marginTop - this.marginBottom;
    }

    @Override
    public boolean dealWithGiftMessage(GiftMessage giftMessage) {
        return this.dealWithTwoGiftMessage(giftMessage, null);
    }

    @Override
    public boolean dealWithGiftMessage(ArrayList<GiftMessage> giftMessages) {
        if (giftMessages != null && giftMessages.size() > 0) {
            GiftMessage gift1 = giftMessages.get(0);
            GiftMessage gift2 = giftMessages.size() > 1 ? giftMessages.get(1) : null;
            return this.dealWithTwoGiftMessage(gift1, gift2);
        }
        return true;
    }

    public void addGiftTargetToGroup(boolean isTop) {
        GiftTarget target = isTop ? this.mGiftTop : this.mGiftBottom;
        float x = this.LIVE_GIFT_LEFT_PADDING;
        int imageHeight = target.getGiftImageHeight();
        float y = this.getLiveGiftYPosition(this.mHeight, imageHeight, isTop);
        int indexPos = LiveEggAnimateDecoder.EGG_VIEW_PARTS * this.mLiveEggAnimateDecoder.getCurrentEggGiftSize();
        target.addTo(this.mContext, this.mGiftViewGroup, x, y, indexPos, this.mWidth, GiftTarget.GiftFrom.LIVE);
        target.startUserInfoGroupEntranceAnim(new EntranceAnimatorListener(target));
        this.calculateExpensiveGift(null);
    }

    @Override
    public void clear() {
        this.recycleGiftTarget(this.mGiftTop);
        this.recycleGiftTarget(this.mGiftBottom);
        this.mGiftTop = null;
        this.mGiftBottom = null;
        this.mGiftMessageTop = null;
        this.mGiftMessageBottom = null;
        this.mLiveEggAnimateDecoder.clear();
    }

    @Override
    public void release() {
        super.release();
        this.mHandler.removeCallbacksAndMessages(null);
        this.mLiveEggAnimateDecoder.release();
        this.mThreadPoolExecutor.shutdownNow();
        this.mThreadPoolExecutor = null;
    }

    @Override
    public int desireGiftMessageType() {
        return 0;
    }

    private boolean isNeedEggDecoderTodoEggAnimation(GiftMessage giftMessage) {
        String doubleHitId = giftMessage.getDoublehitId();
        boolean match = false;
        if (null != this.mGiftMessageTop && !TextUtils.isEmpty((CharSequence)this.mGiftMessageTop.getDoublehitId()) && this.mGiftMessageTop.getDoublehitId().equals(doubleHitId)) {
            if (null == this.mGiftTop || this.mGiftTop.isImageTargetDismiss()) {
                this.mGiftMessageTop.setEggMessage(giftMessage);
                return false;
            }
            match = true;
        }
        if (!match && null != this.mGiftMessageBottom && !TextUtils.isEmpty((CharSequence)this.mGiftMessageBottom.getDoublehitId()) && this.mGiftMessageBottom.getDoublehitId().equals(doubleHitId)) {
            if (null == this.mGiftBottom || this.mGiftBottom.isImageTargetDismiss()) {
                this.mGiftMessageBottom.setEggMessage(giftMessage);
                return false;
            }
            match = true;
        }
        return match;
    }

    private void updateGiftYPosition(GiftTarget target, int oldHeight, int height) {
        if (target == null) {
            return;
        }
        float lastGiftY = this.getLiveGiftYPosition(oldHeight, target.getGiftImageHeight(), false);
        float giftY = this.getLiveGiftYPosition(height, target.getGiftImageHeight(), false);
        target.updateGiftPosition(giftY - lastGiftY);
    }

    private float getLiveGiftYPosition(int height, int imageHeight, boolean isTop) {
        float giftHeight = (float)height - this.marginBottom - (isTop ? this.smallGiftItemHeight + this.smallGiftItemOffset : 0.0f) - (this.smallGiftItemHeight + (float)imageHeight) / 2.0f;
        giftHeight = this.isLandscape() ? (giftHeight += (float)DipUtils.dip2px(9.0f)) : (giftHeight += (float)DipUtils.dip2px(30.0f));
        return giftHeight;
    }

    public boolean isLandscape() {
        return this.mOrientation == 2;
    }

    public boolean dealWithTwoGiftMessage(GiftMessage gift1, GiftMessage gift2) {
        if (this.mIsPause || gift1 == null && gift2 == null) {
            return true;
        }
        boolean result = false;
        if (this.updateComboPointIfExits(this.mGiftTop, gift1)) {
            if (gift1 != null) {
                this.playEggIfNeed(gift1);
            }
            gift1 = null;
            result = true;
        }
        if (this.updateComboPointIfExits(this.mGiftTop, gift2)) {
            if (gift2 != null) {
                this.playEggIfNeed(gift2);
            }
            gift2 = null;
            result = true;
        }
        if (this.updateComboPointIfExits(this.mGiftBottom, gift1)) {
            if (gift1 != null) {
                this.playEggIfNeed(gift1);
            }
            gift1 = null;
            result = true;
        }
        if (this.updateComboPointIfExits(this.mGiftBottom, gift2)) {
            if (gift2 != null) {
                this.playEggIfNeed(gift2);
            }
            gift2 = null;
            result = true;
        }
        if (this.mGiftTop != null) {
            if (this.mGiftTop.canReplace()) {
                this.recycleGiftTarget(this.mGiftTop);
                this.mGiftTop = null;
                this.mGiftMessageTop = null;
            }
        } else if (this.isTwoGiftMessageFromSameCombo(gift1, this.mGiftMessageTop)) {
            if (gift1.getComboTo() > this.mGiftMessageTop.getComboTo()) {
                this.mGiftMessageTop.setComboTo(gift1.getComboTo());
            }
            gift1 = null;
            result = true;
        } else if (this.isTwoGiftMessageFromSameCombo(gift2, this.mGiftMessageTop)) {
            if (gift2.getComboTo() > this.mGiftMessageTop.getComboTo()) {
                this.mGiftMessageTop.setComboTo(gift2.getComboTo());
            }
            gift2 = null;
            result = true;
        } else {
            this.mGiftMessageTop = null;
        }
        if (this.mGiftBottom != null) {
            if (this.mGiftBottom.canReplace()) {
                this.recycleGiftTarget(this.mGiftBottom);
                this.mGiftMessageBottom = null;
                this.mGiftBottom = null;
            }
        } else if (this.isTwoGiftMessageFromSameCombo(gift1, this.mGiftMessageBottom)) {
            if (gift1.getComboTo() > this.mGiftMessageBottom.getComboTo()) {
                this.mGiftMessageBottom.setComboTo(gift1.getComboTo());
            }
            result = true;
            gift1 = null;
        } else if (this.isTwoGiftMessageFromSameCombo(gift2, this.mGiftMessageBottom)) {
            if (gift2.getComboTo() > this.mGiftMessageBottom.getComboTo()) {
                this.mGiftMessageBottom.setComboTo(gift2.getComboTo());
            }
            result = true;
            gift2 = null;
        } else {
            this.mGiftMessageBottom = null;
        }
        GiftMessage[] newGifts = new GiftMessage[2];
        if (this.isMoreValuableThan(gift1, gift2)) {
            this.putGiftsToTarget(newGifts, gift2);
            this.putGiftsToTarget(newGifts, gift1);
        } else {
            this.putGiftsToTarget(newGifts, gift1);
            this.putGiftsToTarget(newGifts, gift2);
        }
        this.calculateExpensiveGift(newGifts);
        if (newGifts[0] != null || newGifts[1] != null) {
            result = true;
            this.mThreadPoolExecutor.execute((Runnable)((Object)new LoadGiftResourceTask("LiveSmallGiftExcutor", newGifts[0], newGifts[1])));
        }
        return result;
    }

    private boolean isTwoGiftMessageFromSameCombo(GiftMessage gift1, GiftMessage gift2) {
        if (gift1 == null || gift2 == null) {
            return false;
        }
        return gift1.getDoublehitId() != null && gift1.getDoublehitId().equals(gift2.getDoublehitId());
    }

    private boolean updateComboPointIfExits(GiftTarget target, GiftMessage message) {
        if (target == null || message == null || target.isImageTargetDismiss()) {
            return false;
        }
        GiftMessage targetMessage = target.getGiftMessage();
        if (targetMessage != null && targetMessage.getDoublehitId() != null && targetMessage.getDoublehitId().equals(message.getDoublehitId())) {
            if (message.getComboTo() > targetMessage.getComboTo()) {
                target.updateCombPoint(message, true);
            }
            return true;
        }
        return false;
    }

    private boolean isMoreValuableThan(GiftMessage gift1, GiftMessage gift2) {
        int giftValue2;
        if (gift1 == null) {
            return false;
        }
        if (gift2 == null) {
            return true;
        }
        int giftValue1 = GiftAnimateController.getGiftValue(gift1);
        return giftValue1 > (giftValue2 = GiftAnimateController.getGiftValue(gift2));
    }

    private void calculateExpensiveGift(GiftMessage[] newGifts) {
        int giftValue1 = GiftAnimateController.getGiftValue(this.mGiftMessageTop);
        int giftValue2 = GiftAnimateController.getGiftValue(this.mGiftMessageBottom);
        boolean isTopGiftExpensive = true;
        if (giftValue1 <= giftValue2 && giftValue1 < giftValue2) {
            isTopGiftExpensive = false;
        }
        if (!isTopGiftExpensive) {
            boolean changePos = false;
            if (this.mGiftTop != null && giftValue2 >= 0) {
                changePos = true;
                this.mGiftTop.updateYPostion(this.mGiftTop.getGiftImageTop(), this.getLiveGiftYPosition(this.mHeight, this.mGiftTop.getGiftImageHeight(), false));
            }
            if (this.mGiftBottom != null && giftValue1 >= 0) {
                changePos = true;
                this.mGiftBottom.updateYPostion(this.mGiftBottom.getGiftImageTop(), this.getLiveGiftYPosition(this.mHeight, this.mGiftBottom.getGiftImageHeight(), true));
            }
            if (changePos) {
                GiftTarget tmpTarget = this.mGiftTop;
                GiftMessage tmpMessage = this.mGiftMessageTop;
                this.mGiftTop = this.mGiftBottom;
                this.mGiftMessageTop = this.mGiftMessageBottom;
                this.mGiftBottom = tmpTarget;
                this.mGiftMessageBottom = tmpMessage;
                if (newGifts != null) {
                    GiftMessage tmpMessage2 = newGifts[0];
                    newGifts[0] = newGifts[1];
                    newGifts[1] = tmpMessage2;
                }
            }
        }
    }

    private void putGiftsToTarget(GiftMessage[] newGifts, GiftMessage gift) {
        if (gift == null) {
            return;
        }
        if (this.isMoreValuableThan(this.mGiftMessageBottom, this.mGiftMessageTop)) {
            if (this.isMoreValuableThan(gift, this.mGiftMessageTop)) {
                this.recycleGiftTarget(this.mGiftTop);
                this.mGiftTop = null;
                newGifts[0] = gift;
                this.mGiftMessageTop = gift;
            }
        } else if (this.isMoreValuableThan(gift, this.mGiftMessageBottom)) {
            this.recycleGiftTarget(this.mGiftBottom);
            this.mGiftBottom = null;
            newGifts[1] = gift;
            this.mGiftMessageBottom = gift;
        }
    }

    private void playEggIfNeed(GiftMessage message) {
        GiftMessage eggMessage = message.getEggMessage();
        if (null != eggMessage) {
            message.setEggMessage(null);
            if (this.isNeedEggDecoderTodoEggAnimation(message)) {
                this.mLiveEggAnimateDecoder.dispatchGiftMessage(eggMessage);
            }
        }
    }

    private void setGiftParamsWithOrientation(int orientation) {
        if (orientation == 1) {
            if (this.mPortGiftOffsetEventFragment <= 0.0f) {
                this.mPortGiftOffsetEventFragment = this.getGiftMaringOffset(orientation);
            }
            this.marginBottom = this.mPortGiftOffsetEventFragment;
        } else {
            if (this.mLandGiftOffsetEventFragment <= 0.0f) {
                this.mLandGiftOffsetEventFragment = this.getGiftMaringOffset(orientation);
            }
            this.marginBottom = this.mLandGiftOffsetEventFragment;
        }
        this.mLiveEggAnimateDecoder.setBottomMargin((int)this.marginBottom);
    }

    private float getGiftMaringOffset(int orientation) {
        int eventHeight = 50;
        if (orientation == 1) {
            eventHeight = DipUtils.dip2px(eventHeight) + (int)BasicConfig.getInstance().getAppContext().getResources().getDimension(R.dimen.new_chatlist_height);
            return eventHeight;
        }
        return 0.0f;
    }

    private class LoadGiftResourceTask
    extends NamedRunnable {
        private GiftTarget targetTop;
        private GiftTarget targetBottom;
        private GiftMessage giftTop;
        private GiftMessage giftBottom;
        private GiftMessage mGiftMessageFirst;
        private GiftMessage mGiftMessageSecond;

        public LoadGiftResourceTask(String name, GiftMessage params0, GiftMessage params1) {
            super(name, new Object[0]);
            this.mGiftMessageFirst = params0;
            this.mGiftMessageSecond = params1;
        }

        public void execute() {
            long startTime = System.currentTimeMillis();
            this.giftTop = this.mGiftMessageFirst;
            this.giftBottom = this.mGiftMessageSecond;
            if (this.giftTop != null) {
                this.targetTop = LiveSmallGiftAnimateDecoder.this.loadGiftImageTarget(this.giftTop);
            }
            if (this.giftBottom != null) {
                this.targetBottom = LiveSmallGiftAnimateDecoder.this.loadGiftImageTarget(this.giftBottom);
            }
            if (LiveSmallGiftAnimateDecoder.this.mHandler != null) {
                LiveSmallGiftAnimateDecoder.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        LoadGiftResourceTask.this.onPostExecuteLive();
                    }
                });
            }
        }

        private void onPostExecuteLive() {
            if (this.giftTop != null && this.giftTop == LiveSmallGiftAnimateDecoder.this.mGiftMessageTop) {
                if (this.targetTop != null) {
                    LiveSmallGiftAnimateDecoder.this.mGiftTop = this.targetTop;
                    LiveSmallGiftAnimateDecoder.this.addGiftTargetToGroup(true);
                    LiveSmallGiftAnimateDecoder.this.playEggIfNeed(LiveSmallGiftAnimateDecoder.this.mGiftMessageTop);
                } else {
                    LiveSmallGiftAnimateDecoder.this.mGiftMessageTop = null;
                }
            }
            if (this.giftBottom != null && this.giftBottom == LiveSmallGiftAnimateDecoder.this.mGiftMessageBottom) {
                if (this.targetBottom != null) {
                    LiveSmallGiftAnimateDecoder.this.mGiftBottom = this.targetBottom;
                    LiveSmallGiftAnimateDecoder.this.addGiftTargetToGroup(false);
                    LiveSmallGiftAnimateDecoder.this.playEggIfNeed(LiveSmallGiftAnimateDecoder.this.mGiftMessageBottom);
                } else {
                    LiveSmallGiftAnimateDecoder.this.mGiftMessageBottom = null;
                }
            }
        }
    }

    private class EntranceAnimatorListener
    extends AnimatorListenerAdapter {
        private GiftTarget giftTarget;

        public EntranceAnimatorListener(GiftTarget tartget) {
            this.giftTarget = tartget;
        }

        public void onAnimationEnd(Animator animator) {
            if (this.giftTarget != null && !this.giftTarget.isImageTargetDismiss()) {
                this.giftTarget.startGiftAnimation();
                LiveSmallGiftAnimateDecoder.this.requestAutoInvalidate();
            }
        }
    }
}

