/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.danmaku.basic;

import android.graphics.Paint;
import android.text.TextUtils;
import com.unionyy.mobile.meipai.danmaku.BarrageEntity;
import com.unionyy.mobile.meipai.danmaku.basic.BarrageLog;
import com.unionyy.mobile.meipai.danmaku.basic.BarrageRunnable;
import com.unionyy.mobile.meipai.danmaku.basic.BarrageView;
import com.unionyy.mobile.meipai.danmaku.basic.BaseBarrage;
import com.unionyy.mobile.meipai.danmaku.basic.TextUtil;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentLinkedQueue;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.Duration;

public final class BarrageDispatcher {
    private static final String TAG = "BarrageDispatcher";
    private ConcurrentLinkedQueue<BarrageRunnable> barrageQueue = new ConcurrentLinkedQueue();
    private Thread loopThread;
    private WeakReference<BarrageView> targetWeakReference;
    public static long barrageSleepTime = 500L;
    private volatile Paint paint;

    public static BarrageDispatcher getInstance() {
        return Inner.INSTANCE;
    }

    public void setTarget(BarrageView barrageView) {
        if (barrageView == null) {
            this.targetWeakReference = null;
        } else if (this.targetWeakReference == null || this.targetWeakReference.get() != barrageView) {
            this.targetWeakReference = new WeakReference<BarrageView>(barrageView);
        }
    }

    public void asyncExecute() {
        while (!Thread.currentThread().isInterrupted()) {
            if (this.barrageQueue.size() == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            while (this.barrageQueue.size() != 0) {
                BarrageRunnable barrageRunnable = this.barrageQueue.peek();
                if (barrageRunnable == null) continue;
                barrageRunnable.run();
                this.barrageQueue.poll();
            }
        }
    }

    public void addBarrage(BaseBarrage baseBarrage) {
        BarrageLog.commonBarrageLog(TAG, "addBarrage() called with: baseBarrage = [" + baseBarrage.toString() + "]");
        this.buildNextRunnable(baseBarrage, new BarrageRunnable(){

            @Override
            protected void execute() {
                MLog.info((Object)BarrageDispatcher.TAG, (String)("execute(), baseBarrage:" + this.baseBarrage.baseDanmaku.text), (Object[])new Object[0]);
                BarrageView barrageView = null;
                BaseDanmaku baseDanmaku = null;
                if (this.baseBarrage == null || (baseDanmaku = this.baseBarrage.baseDanmaku) == null || BarrageDispatcher.this.targetWeakReference == null || (barrageView = (BarrageView)((Object)BarrageDispatcher.this.targetWeakReference.get())) == null || TextUtils.isEmpty((CharSequence)baseDanmaku.text)) {
                    BarrageLog.commonBarrageLog(BarrageDispatcher.TAG, "barrageLog: addBarrage() execute called with before sleep: baseBarrage = [" + this.baseBarrage + "], baseDanmaku = [" + baseDanmaku + "]targetWeakReference = [" + BarrageDispatcher.this.targetWeakReference + "]barrageView = [" + (Object)((Object)barrageView) + "], ");
                    return;
                }
                try {
                    Thread.sleep(barrageSleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.baseBarrage == null || (baseDanmaku = this.baseBarrage.baseDanmaku) == null || BarrageDispatcher.this.targetWeakReference == null || (barrageView = (BarrageView)((Object)BarrageDispatcher.this.targetWeakReference.get())) == null || TextUtils.isEmpty((CharSequence)baseDanmaku.text)) {
                    BarrageLog.commonBarrageLog(BarrageDispatcher.TAG, "barrageLog: addBarrage() execute called with baseBarrage = [" + this.baseBarrage + "], baseDanmaku = [" + baseDanmaku + "]targetWeakReference = [" + BarrageDispatcher.this.targetWeakReference + "]barrageView = [" + (Object)((Object)barrageView) + "], ");
                    return;
                }
                Object baseDanmakuObject = baseDanmaku.tag;
                if (!(baseDanmakuObject instanceof BarrageEntity)) {
                    BarrageLog.commonBarrageLog(BarrageDispatcher.TAG, "barrageLog: addBarrage() execute called with: baseDanmakuObject instanceof BarrageEntity is false");
                    return;
                }
                BarrageEntity barrageEntity = (BarrageEntity)baseDanmakuObject;
                if (barrageView.isIgnoreBarrage(barrageEntity.barrageOwnerId)) {
                    return;
                }
                long currentTime = barrageView.getCurrentTime();
                baseDanmaku.setTime(currentTime);
                int viewWidth = barrageView.getWidth();
                float barrageSpeed = (float)viewWidth * 1.0f / (float)baseDanmaku.getDuration();
                float senderNameWidth = TextUtil.getTextWidth(BarrageDispatcher.this.buildPaint(), barrageEntity.senderNickname);
                float senderNamePaddingMargin = ScreenUtil.getInstance().dip2px(41);
                float barrageContentWidth = 0.0f;
                if (baseDanmaku.text != null) {
                    barrageContentWidth = TextUtil.getTextWidth(BarrageDispatcher.this.buildPaint(), baseDanmaku.text.toString());
                }
                float barrageContentPaddingMargin = ScreenUtil.getInstance().dip2px(71);
                float textWidth = Math.max(senderNameWidth + senderNamePaddingMargin, barrageContentWidth + barrageContentPaddingMargin);
                float contentWidth = (float)viewWidth + textWidth;
                long delayTime = (long)(contentWidth / barrageSpeed);
                MLog.debug((Object)BarrageDispatcher.TAG, (String)("barrageLog: addBarrage() execute called with: currentTime = [" + currentTime + "], tempTime = [" + delayTime + "], contentWidth = [" + contentWidth + "], barrageSpeed = [" + barrageSpeed + "], viewWidth = [" + viewWidth + "], textWidth = [" + textWidth + "], senderNameWidth = [" + senderNameWidth + "], barrageContentWidth = [" + barrageContentWidth + "], barrageContentPaddingMargin = [" + barrageContentPaddingMargin + "]"), (Object[])new Object[0]);
                baseDanmaku.setDuration(new Duration(delayTime));
                barrageView.addDanmaku(baseDanmaku);
                barrageSleepTime = (long)(textWidth * 1.0f / barrageSpeed + 400.0f);
            }
        });
    }

    public Paint buildPaint() {
        if (this.paint == null) {
            this.paint = new Paint();
            this.paint.setTextSize((float)ScreenUtil.getInstance().dip2px(14));
        }
        return this.paint;
    }

    private void buildNextRunnable(BaseBarrage baseBarrage, BarrageRunnable runnable2) {
        runnable2.baseBarrage = baseBarrage;
        try {
            this.barrageQueue.offer(runnable2);
        }
        catch (Exception e) {
            BarrageLog.commonBarrageLog(TAG, "Queue full");
        }
    }

    public void cancelAll() {
        BarrageLog.commonBarrageLog(TAG, "cancelAll() called0");
        this.barrageQueue.clear();
        BarrageLog.commonBarrageLog(TAG, "cancelAll() called1");
    }

    public int getBarrageQueueSize() {
        return this.barrageQueue.size();
    }

    public void startLoop() {
        if (this.loopThread != null && this.loopThread.isAlive()) {
            return;
        }
        this.loopThread = new Thread(new Runnable(){

            @Override
            public void run() {
                BarrageDispatcher.this.asyncExecute();
                MLog.info((Object)BarrageDispatcher.TAG, (String)"thread finished", (Object[])new Object[0]);
            }
        });
        this.loopThread.start();
    }

    public void quit() {
        if (this.loopThread != null) {
            this.loopThread.interrupt();
        }
    }

    public static class Inner {
        public static BarrageDispatcher INSTANCE = new BarrageDispatcher();
    }
}

